proc test

local nHan,           ; && N  Handle of output .txt file
      bIndexKey,      ; && B  Code block returning index key 
      cCrLf,          ; && C  Carriage return, line feed
      nCount,         ; && N  Loop iteration counter
      nCol,           ; && N  Column for on-screen display of progress
      cStr              && C  Work string

REQUEST DBFCDX
RDDSETDEFAULT( "DBFCDX" )

// Open input file
USE MM_VOL INDEX MM_VOL

// Initialize loop variables
cCrLf = chr(13)+chr(10)
nHan = fcreate("MM_VOL.TXT")
bIndexKey = &( "{ || "+indexkey(0)+" }")
nCount = 0

// Write output file header
fwrite(nHan,"Primary Index listing of file MM_VOL.DBF"+cCrLf)
fwrite(nHan,"Index on expression="+indexkey(0)+cCrLf)
fwrite(nHan,"Record count="+ltrim(str(reccount()))+cCrLf)
fwrite(nHan,cCrLf)

// Write progress message on screen
clear screen
@ 01,00 to 03,79 double
cStr = "Test traversing MM_VOL using primary index of MM_VOL.CDX"
@ 02,(80-len(cStr))/2 say cStr
cStr = "xx,xxx records of "+transform(reccount(),"99,999")+" processed"
nCol = int((80-len(cStr))/2)
@ 05,nCol say cStr

// Write
do while .not. eof()

   cStr  = "Iteration "+str(nCount,5)
   cStr += " Record #"+str(recno(),5)
   cStr += " Key "+eval(bIndexKey)
   fwrite(nHan,cStr+cCrLf)
   skip
   nCount += 1
   @ 05,nCol say transform(nCount,"99,999")

enddo

// Close output,input files
close data
fclose(nHan)
return
