*---------------------------------------------------------------------------*
*****************************************************************************
*
*       Program       : FUNCky.lib
*       Author        : Dirk Andrew Lesko
*       Copyright     : (C) 1988 dLESKO ASSOCIATES. All rights reserved
*
*       Function      : macdbfview()
*       Purpose       : view a dbf file in a window with mouse support resizing
*       Usage         : <offset> = macdbfview(<row>,<col>,<row>,<col>, ;
*                                            <titles>,<fields>,[<color>]), ;
*					     <_criteria1>,<_criteria2>)
*
*	Modified      : Jeffrey Springer (after Mark Wollam)
*			1. display matter info for each line (see SPECIAL())
*			2. don't allow scrolling into empty stuff
*			3. _criteria1 = loop control based on index key
*			4. _criteria2 = expression to match records
*
***********************************   
        EXTERN  movewin2
*------------------------------------*
*    Comments:  Uses the MMA
*               
*               
*               
*----------------------------------------------------*
FUNCTION macdbfview
*-----------------------------------------------------------*
parameter m_trow, m_tcol, m_brow, m_bcol, _fheader, _fields, _color
	  _criteria1, _criteria2

private _trow,_tcol,_brow,_bcol,_fname,_color, ;
        _alen, _width, _pkey, _plast, _pactive, _header, ;
        _pback, _fstring, _tempstr, tempscrn2, ;
        _tempstr2, _y, _fieldnum, _findstr, _fcount, _phigh, _temprec, ;
        _up, _down, _left, _right, _minwidth, _esc, _control, _flag, ;
        _tempscrn, _tempwin, _temp, _temp2, _tempniks, _nikniks

        * make sure there is a DBF open and the arrays are present
        **********************************************************  
        if (! used()) .or. (pcount() < 5)
                m_data(30,-8)
                return(-8)
        endif

        * if there is a DBF open, store the current recno()
        * in case they escape out, or click outside the window area
        *********************************************************** 
        _temprec = recno()

        * check for conditions
        ****************************************
        if (type('_criteria1') = 'U')
           _criteria1 = .t.
        else
           m_data(31) = recno()
        endif

        if (type('_criteria2') = 'U')
           _criteria2 = .t.
        endif

        * get the color, and setup the defaults
        ***************************************
        if (pcount() < 7)
                _color = -1
        endif
        if (_color = -1)                        && if no color, use default
                _color   = standard()
                _pback   = enhanced()
                _phigh   = roloc(_color)
        else
                _pback   = roloc(_color)        && reverse of _color
                _phigh   = roloc(_color)
        endif

        * variables to store keystroke, active, and last active elements
        * temporary strings and whatnot
        ****************************************************************
        store 0 to _pkey,;
                   _temp,;
                   _temp2,;
                   _tempniks,;
                   _nikniks,;
                   _esc,;
                   _up,;
                   _down,;
                   _left,;
                   _right  

        _plast   = 1                    
        _pactive = 1                    
        _tempstr = ""
        _tempstr2= ""
        _header  = ""
        _fcount  = len(_fheader)
        _trow    = m_trow
        _tcol    = m_tcol
        _brow    = m_brow
        _bcol    = m_bcol
        _flag    = .T.
        _tempscrn= ""
        _tempwin = ""

        ****************************************************** 
        *** setup scroll bars based on global mouse data   ***
        ****************************************************** 

        * setup start of control panel ESC portion
        ******************************************     
        _control = chr(179)+chr(240)+chr(179)+chr(24)+ ;
                   chr(179)+chr(25)+chr(179)
 
        * see if panning is allowed, add pan bars
        ***************************************** 
        if (m_data(23) = 1)
                _control = _control+chr(27)+chr(179)+chr(26)+chr(179)
                _left    = 4
                _right   = 2
        endif

        * calculate locations and width of control panel
        ************************************************
        _minwidth= len(_control)        && minimum width of interior window
        _esc     = _minwidth - 1        && location of escape bar in control
        _up      = _esc - 2
        _down    = _esc - 4

        * declare the array that holds the offsets for scrolling
        ********************************************************
        declare _offset[len(_fields)]

        * setup the header string and the offsets for each field
        ********************************************************
        for _x = 1 to len(_fields)
                _tempstr= _fields[_x]
                _temp   = len(&_tempstr)
                _offset[_x] = len(_header)+1
                _fheader[_x]= untrim(_fheader[_x], iif(_temp>(len(_fheader[_x])+1), ;
                                         _temp,len(_fheader[_x])))
                _header     = _header+_fheader[_x]+chr(179)
        next

        * starting left offset to start printing is from the first field
        ****************************************************************
        _fieldnum = 1                   

      ******************************************************************
      *** get type of shadow and calculate the extra space to add to ***
      *** the rows and columns to accomodate the shadow when         ***
      *** positioning and saving/restoring the screen                ***
      ******************************************************************
        declare _shadsize[4]

        * use _tempscrn temporarily so we don't have to declare a variable
        * and get the shadow type to calculate correct size of box
        ******************************************************************
        _shadow   = m_data(16)
        _tempscrn = ltrim(str(m_data(16))) 

        * can't let shadow disappear off the screen! so setup
        * the elements to add to the box coordinates for bounds checking
        ****************************************************************  
        _shadsize[1] = iif(_tempscrn $ "789", 1,0)
        _shadsize[2] = iif(_tempscrn $ "963", 1,0)
        _shadsize[3] = iif(_tempscrn $ "123", 1,0)
        _shadsize[4] = iif(_tempscrn $ "741", 1,0)

        * see if the width if the box can hold the status line
        * and the control panel, if it can't, then expand it a little
        *************************************************************
        _width   = ((_bcol-_tcol)-1)
        do while (_width < 11)   
                _bcol    = _bcol+1
                _tcol    = _tcol-1
                _width   = ((_bcol-_tcol)-1)
        enddo

        * make sure box has at least 5 lines in it
        ****************************************** 
        do while ((_brow-_trow) < 5)
                _brow = _brow+1
                if ((_brow-_trow) < 5)
                        _trow = _trow-1
                endif
        enddo

        ****************************************************** 
        *** verify that the window is within the current   ***
        *** defined virtual coordinates                    ***
        *** Window must start out inside the virtual       ***
        *** coordinates. If not, an error is returned      ***
        *** once inside, the window does not move outside  ***
        *** the virtual window                             ***
        ****************************************************** 

        if (_trow < m_data(8)) .or. ;           && top row
           (_tcol < m_data(9)) .or. ;           && left column
           (_brow > m_data(10)) .or. ;          && bottom row
           (_bcol > m_data(11))                 && right column

                m_data(30,-6)                   && notify MMA
                return(-6)
        endif

        * calculate starting height of the window
        *****************************************
        _alen    = ((_brow-_trow)-3)

        * declare all the arrays that will hold the lines
        * of text, the record # into the file for each line, as
        * well as the rows and columns of each displayed line of text
        * use maxrow() to allocate enough for the entire screen
        *************************************************************
        declare linearray[maxrow()-4], recnum[maxrow()-4], _arow[maxrow()-4], ;
                _acol[maxrow()-4], _acol2[maxrow()-4], _dbfwinmov[4]

        * fill the arrays with the starting values
        ******************************************
        do dbxarrfill

        * coordinate the mouse cursor
        *****************************  
        m_csron()
        m_csroff()

        * the dbfwinmov array is used only to check if the window
        * has moved.
        ********************************************************* 
        _dbfwinmov[1] = _trow
        _dbfwinmov[2] = _tcol
        _dbfwinmov[3] = _brow
        _dbfwinmov[4] = _bcol

        * save the screen for movement
        ***************************************************************
        _tempscrn = savescreen()

        * if they entered the routine and are still holding down the
        * left mouse button, wait here until they release it
        ************************************************************
        do while _isbutton(0)
        enddo

        * use scroll to clear the location of the box since it
        * is faster than letting box() do it.
        ******************************************************
        scroll(_trow, _tcol, _brow, _bcol, 0, _color)

        * display our box and status line
        ********************************* 
        do dbxdispbox

        * if the auto restart flag is set to 1 then move the
        * file pointer to the record # stored in the file position
        * global data area (m_data(31)), and reset the active element
        * to where it was. the file position data contains the
        * file record # of the first displayed line of text
        * the last active element should have the last active element
        * that was highlighted. This has to be set in the calling program
        *****************************************************************
        if (m_data(29) = 1)
                goto m_data(31)
                _pactive = m_data(2)

                * do some bounds checking
                *************************
                if (_pactive > _alen)
                        _pactive = _alen
                endif
                _plast = _pactive
        endif

        * mouse cursor on, regular cursor off, and read in the lines of text
        * into the array used for display
        ******************************************************************** 
        m_csron()
        csroff()
        do readarrdbx
	IF _x = 0
		RETURN(-3) && no conditions2 met
	ENDIF
        goto recnum[1]

        * use the loop inside a loop trick for programming ease
        *******************************************************

        do while .T.
        
            * display the entire array if inside the outer loop
            ***************************************************   
            m_csroff()
            do dbxdisparr
            m_csron()
        

            * check for mouse or key activity
            *********************************

            do while .T.
        
                * if active element has been moved, then 
                * redisplay the highlight
                ****************************************
                if (_pactive != _plast)
                        m_csroff()
                        print(_trow+_pactive+1,_tcol+1, ;
                              substr(linearray[_pactive], ;
                              _offset[_fieldnum],_width),_pback,_width)
                        print(_trow+_plast+1,_tcol+1, ;
                              substr(linearray[_plast], ;
                              _offset[_fieldnum],_width),_color,_width)
                              do _dbxstat with SPECIAL(recno())
                        m_csron()
                endif        

                * check for a key, and save last active element
                ***********************************************
                _pkey  = waitkey()      
                _plast = _pactive
        
                * check if valid key, or mouse movement
                ***************************************
                do case

                ****************************************************** 
                *** if exceptions are to be processed, then see if ***
                *** the user clicks outside the window area, if so ***
                *** then return with no selection made (-2),       ***
                *** else beep if they can't exit that way          ***
                ****************************************************** 
        
                case (_isbutton(0).and.(! m_region(_trow,_tcol,_brow,_bcol)))
                        if (m_data(3) = 1)
                                do dbxxret
                                m_data(4,1)     && tell em they clicked
                                                && outside the box coords     
                                goto _temprec   && restore record ptr
                                m_data(30,-2)   && notify MMA
                                return(-2)
                        else 
                                m_squeak()
                                loop
                        endif

                ****************************************************** 
                *** if any window_move flag is .T., check for      ***
                *** the proper keystrokes or mouse position.       ***
                *** always check for keyboard stuff FIRST!         ***
                *** Using the .or. operater after the mouse stuff  ***
                *** gets confusing, consider :                     ***
                *** if (_isbutton(1)) .and. (m_row() = 20) .or. ;  ***
                ***    inkey() = 27                                ***
                ***                                                ***
                *** This example means ( if left button pressed    ***
                *** and m_row() = 27) or (if left button pressed   ***
                *** and inkey = 27) when it should say ( if        ***
                *** inkey = 27) or (if left button pressed and     ***
                *** m_row() = 20), got it?                         ***
                ****************************************************** 
        
                * check if user wants to expand right
                *************************************
                case (((kbdstat(2).and.(_pkey = 54 .or. _pkey = 52)))).or.;
                     (_isbutton(1) .and. ;
                       m_region(_trow,_bcol,_brow,_bcol))
        
                ******************************************************
                *** check if we're allowed to expand the right     ***
                *** side of the window....                         ***
                ******************************************************
        
                        if (m_data(18) = 0)
                                do while _isbutton(1) && hangem up for a while
                                enddo                 && since they're not allowed
                                loop                  && or just return if on keys
                        endif
        
                        do dbxmovrite
                        loop
        
                * check if user wants to pull down down the bottom of the window
                **************************************************************** 
                case (((kbdstat(2).and.(_pkey = 56 .or. _pkey = 50)))).or.;
                     (_isbutton(1) .and. ;
                      m_region(_brow,_tcol,_brow,_bcol))
        
        
                ******************************************************
                *** check if we're allowed to pull down the        ***
                *** bottom of the window....                       ***
                ******************************************************
        
                        if (m_data(20) = 0)
                                do while _isbutton(1) && hangem up for a while
                                enddo                 && since they're not allowed
                                loop                  && or just return if on keys
                        endif
        
                        do dbxmovebot
                        loop
        
                * check if user wants to move the window
                * subroutine checks if the movement is allowed
                ********************************************** 
                case kbdstat(16) .or. ((_isbutton(1) .and. ;
                     m_region(_trow,_tcol,_brow-2,_bcol-1)))
                        do dbxmove
                        loop
        
                * see if they pressed ESCape or clicked the triple bar
                * in the control panel
                ******************************************************   
                case (_pkey = 27) .or. (_isbutton(0) .and. ;  
                     (m_row() = _brow-1) .and. (m_col() = (_bcol - _esc)))
                        putkey(27)
                        do dbxxret
                        goto _temprec   && restore record ptr
                        m_data(30,0)    && notify MMA
                        return(0)

                * see if they pressed return or clicked on a record
                ******************************************************
                case (_pkey = 13) .or. (_isbutton(0) .and. ;
                     m_region(_trow+2,_tcol+1,_brow-2,_bcol-1))
                        putkey(13)
                        do dbxxret
                        m_data(30,-1)
                        return(recnum[_pactive])

                * see if they pressed the up arrow, or clicked the
                * left button on the up arrow in the control panel
                **************************************************
                case (_pkey = 5) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. (m_col() = _bcol-_up)))
        
                        putkey(5)
                        if (_pactive = 1)
                                do readbakdbx
                                exit
                        else 
                                _pactive = _pactive-1
                                goto recnum[_pactive]
                                loop
                        endif
        
                * see if they pressed the down arrow, or pressed the
                * left button while on the down arrow in the control panel
                **********************************************************
                case (_pkey = 24) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-_down)))     && down arrow
        
                        putkey(24)
                        if (_pactive = _alen)
                                do readfordbx 
                                exit
                        else 
                                _pactive = _pactive+1
                                goto recnum[_pactive]
                                loop
                        endif
        
                 * don't let them scroll into a blank element
                **********************************************************
                               if ( ! empty(linearray[_pactive+1]) )
                                   _pactive = _pactive+1
                                   goto recnum[_pactive]
                                else
                                   m_squeak()
                                   waitkey(8)
                                endif
                                loop
                        endif

                * see if they pressed the left arrow, or clicked the
                * left button while on the left arrow in the control panel
                **********************************************************  
                case (_pkey = 19) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-_left)))              && left arrow
        
                ******************************************************
                *** check if we're allowed to pan                  ***
                ******************************************************
        
                        if (m_data(23) = 0)
                                do while _isbutton(1) && hangem up for a while
                                enddo                 && since they're not allowed
                                loop                  && or just return if on keys
                        endif
        
                        putkey(19)

                        * check to see if the left offset is at
                        * the beginning when moving left
                        ***************************************
                        if (_fieldnum <= 1)
                                m_squeak()
                                loop
                        else 
                                _fieldnum = _fieldnum-1
                                waitkey(1)
                                exit
                        endif
        
                * see if they pressed the right arrow, or clicked the
                * left button while on the right arrow in the control panel
                ***********************************************************  
                case (_pkey = 4) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-_right)))       && right arrow
        
                ******************************************************
                *** check if we're allowed to pan                  ***
                ******************************************************
        
                        if (m_data(23) = 0)
                                do while _isbutton(1) && hangem up for a while
                                enddo                 && since they're not allowed
                                loop                  && or just return if on keys
                        endif

                        putkey(4)
                        if (_fieldnum < len(_fields))
                                _fieldnum = _fieldnum+1
                                waitkey(1)
                                exit
                        else 
                                m_squeak()
                                loop
                        endif
        
                * see if the user pressed CTRL/HOME key, or clicked
                * the left button while on the top line of the box
                * goto top of file if so
                ***************************************************
                case (_pkey = 29) .or. ((_isbutton(0) .and. ;    
                     (m_region(_trow,_tcol+1,_trow,_bcol-1))))

                        putkey(29)
                        go top
                        do readarrdbx
                        goto recnum[1]
                        _pactive = 1
                        exit
        
                * see if the user pressed HOME key
                **********************************
                case (_pkey = 1)
                        putkey(1)
                        goto recnum[1]
                        _pactive = 1
                        loop
        
                * see if the user pressed END key
                *********************************
                case (_pkey = 6)
                        putkey(6)
                        goto recnum[_alen]
                        _pactive = _alen
                        loop
        
                * see if the user pressed CTRL/END key, or clicked
                * the left button while on the bottom line of the box
                * goto bottom of file if so
                ******************************************************
                case (_pkey = 23) .or. ((_isbutton(0) .and. ;    
                     (m_region(_brow,_tcol+1,_brow,_bcol-1))))

                        putkey(23)
                        go bott
                        if (_alen > 1)
                                skip (1-_alen)
                        endif
                        _pactive = _alen
                        do readarrdbx
                        goto recnum[_pactive]
                        exit
        
                * see if the user pressed the page up key, or if
                * they clicked the right button on the up arrow
                * in the control panel. Advance a page of text if they did
                **********************************************************
                case (_pkey = 18) .or. ((_isbutton(1)) .and. ;
                     ((m_row() = _brow-1) .and. (m_col() = _bcol-8)))  

                        putkey(18)
                        goto recnum[1]
                        skip -1
                        if bof()
                                do _dbxstat with "Top of File..."
                                m_squeak()
                                _pactive = 1
                                goto recnum[_pactive]
                                exit
                        else 
                                if (_alen > 1)
                                        skip (1-_alen)
                                endif
                                do readarrdbx
                                goto recnum[_pactive]
                                exit
                        endif
        
                * see if the user pressed the page down key, or if
                * they clicked the right button on the down arrow
                * in the control panel. Rewind a page of text if they did
                *********************************************************
                case (_pkey = 3) .or. ((_isbutton(1)) .and. ;   
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-6)))     

                        putkey(3)
                        goto recnum[_alen]
                        skip 1
                        if eof()
                                do _dbxstat with "End of File..."
                                m_squeak()
                                goto recnum[_alen]
                                _pactive = _alen
                                exit
                        else
                                do readarrdbx
                                goto recnum[_pactive]
                                exit
                        endif

                * see if they pressed ALT/S or clicked the mouse
                * over the Record # portion of the screen
                ************************************************   
                case (_pkey = 287) .or. (_isbutton(0) .and. ;
                     m_region(_brow-1,_tcol+1,_brow-1,_bcol-(_minwidth+1)))
                        if .not. isindex()
                                m_squeak()
                                loop
                        endif
                        if (((_width-_minwidth)-14) < 1)
                                m_squeak()
                                loop
                        endif
                        _findstr = space((_width-_minwidth)-8)
                        putkey(287)
                        m_csroff()
                        print(_brow-1,_tcol+1,"Search: ",_phigh)
                        csron()
                        reads(_brow-1,_tcol+9,_findstr,_phigh)
                        m_csron()
                        csroff()

                        * if they ESCaped out, just return
                        **********************************
                        if (lastkey() = 27) .or. ("" == trim(_findstr))
                                m_csroff()
                                print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                                m_csron()
                                loop
                        endif

                        * otherwise go fish.....
                        ************************
                        do _dbxstat with "Searching.... "
                        seek upper(alltrim(_findstr))
                        if ( found() .AND. &_criteria1 .AND. &_criteria2 )
                                do readarrdbx
                                goto recnum[1]
                                _pactive = 1
                                exit
                        else
                                m_squeak()
                                goto recnum[_pactive]
                                do _dbxstat with "Not Found.... "
                                waitkey(38)      && wait two seconds (more or less)
                                m_csroff()
                                do dbxdispbox
                                m_csron()
                                loop
                        endif

                * see if they pressed ALT/G
                ***************************   
                case (_pkey = 290)

                        * verify width
                        ************** 
                        if (((_width-_minwidth)-14) < 1)
                                m_squeak()
                                loop
                        endif
                        _findstr = space((_width-_minwidth)-6)
                        m_csroff()
                        print(_brow-1,_tcol+1,"Goto: ",_phigh)
                        csron()
                        reads(_brow-1,_tcol+7,_findstr,_phigh)
                        csroff()

                        * if they ESCaped out, just return
                        **********************************
                        if (lastkey() = 27) .or. ("" == trim(_findstr))
                                print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                                m_csron()
                                loop
                        endif

                        * otherwise go fish.....
                        ************************
                        m_csron()
                        _temp = val(_findstr)

                        if ((_temp < 0) .or. (_temp > lastrec()) .OR. ;
                        	(! &_criteria1) .OR. (! &_criteria2))
                                m_squeak()
                                do _dbxstat with "Out of Range.."
                                goto recnum[_pactive]
                                waitkey(38)      && wait two seconds (more or less)
                                m_csroff()
                                do dbxdispbox
                                m_csron()
                                loop
                        else 
                                goto _temp
                                do readarrdbx
                                goto recnum[1]
                                _pactive = 1
                                exit
                        endif

                * if an ALT/R is pressed, refresh the display
                * so that a set key to can reposition the record pointer
                ********************************************************
                case (_pkey = 275)
                        goto recnum[1]
                        do readarrdbx 
                        goto recnum[_pactive]
                        m_csroff()
                        do dbxdispbox
                        do dbxdisparr
                        m_csron()
                        goto recnum[_pactive]
                        do _dbxstat with "Record #:"+str(recno(),5)
                        loop

                * if the user presses a letter, then hunt it down
                * within the file only if an index is active
                *************************************************
                case (_pkey != 0)
                        if isindex()
                                keyboard ""
                                seek upper(chr(_pkey))
                                if ( found() .AND. &_criteria1 .AND. &_criteria2 )
                                        do _dbxstat with "Searching.... "
                                        do readarrdbx
                                        goto recnum[1]
                                        _pactive = 1
                                        exit
                                else 
                                        m_squeak()
                                        do _dbxstat with "Not Found.... "
                                        goto recnum[_pactive]
                                        exit
                                endif
                        else 
                                m_squeak()
                                loop
                        endif

                ****************************************************** 
                *** if the mouse cursor is over an element then    ***
                *** make that element active, and redisplay the    ***
                *** highlight over it.                             ***
                ****************************************************** 
        
                case m_region(_trow+2,_tcol+1,_brow-2,_bcol-1)       && mouse
                        _temp = m_aregion(_arow,_acol,_arow,_acol2)  
                        if _temp > 0
                                _pactive = _temp
                                goto recnum[_temp]
                        endif
                        loop                
        
                endcase
        
            enddo
        enddo
        
PROC readbakdbx

        ***************************************************
        *** this routine reads backwards one record     ***               
        *** and inserts it into the first element       ***
        *** of the array                                ***
        ***************************************************
        skip -1
        if ( bof() .OR. ! &_criteria1 .OR. ! &_criteria2)
                do _dbxstat with "Top of File..."
                m_squeak()
                goto recnum[1]
                return
        endif
        ains(linearray,1)
        ains(recnum,1)
        recnum[1]    = recno()
        linearray[1] = ""
        for _y = 1 to _fcount
                _tempstr2= _fields[_y]
                linearray[1] = linearray[1]+ ;
                                   untrim(&_tempstr2,len(_fheader[_y])+1)
        next
        goto recnum[_pactive]

return

PROC readfordbx

        ***************************************************
        *** this routine reads forward one record       ***               
        *** and inserts it into the last element        ***
        *** of the array                                ***
        ***************************************************

        skip 1
        * loop forwards thru file, looking for next match
        ************************************

       do while ( &_criteria1 .and. ! eof() )

           if (&_criteria2)
              * found one
              *****************************
              adel(recnum,1)
              adel(linearray,1)
              recnum[_alen]    = recno()
              linearray[_alen] = ""
              for _y = 1 to _fcount
                      _tempstr2= _fields[_y]
                      linearray[_alen] = linearray[_alen]+ ;
                                         untrim(&_tempstr2,len(_fheader[_y])+1)
              next
              goto recnum[_pactive]
              exit
           endif
           skip 1

       enddo


        if ( eof() .OR. ! &_criteria1 )
                do _dbxstat with "End of File..."
                m_squeak()
                goto recnum[_alen]
                return
        endif
        adel(recnum,1)
        adel(linearray,1)
        recnum[_alen]    = recno()
        linearray[_alen] = ""
        for _y = 1 to _fcount
                _tempstr2= _fields[_y]
                linearray[_alen] = linearray[_alen]+ ;
                                   untrim(&_tempstr2,len(_fheader[_y])+1)
        next
        goto recnum[_pactive]

return

PROC readarrdbx

        ***************************************************
        *** this routine reads forward the number       ***               
        *** of records needed to fill the entire array  ***
        ***************************************************
        do _dbxstat with "Reading....   "

        _x = 0

        * read the file
        ************************************
        do while ( &_criteria1. .and. _x <= _alen .and. ! eof() )

           if ( &_criteria2 )
               * we have a winner
               **********************
              _x = _x+1
              linearray[_x] = ""
              for _y = 1 to _fcount
                  _tempstr2= _fields[_y]
                  linearray[_x] = linearray[_x]+ ;
                        untrim(&_tempstr2,len(_fheader[_y])+1)
              next
              recnum[_x] = recno()
           endif
           skip 1

        enddo

	IF _x = 0  && no winners
		RETURN
	ENDIF
	
	_x = _x + 1
        if ( _x < _alen )

           * fill out the balance of the array
           ****************************
           _z = _x
           skip -1
           for _z = _x to _alen
               linearray[_z] = " "
               recnum[_z] = recno()
           next
        endif

return

        ******************************************************
        *** This part expands the window left and right    ***
        *** from the right side of the window              ***
        ****************************************************** 

proc dbxmovrite 

        * clear the mickey count
        * store current mouse row
        * shut mouse cursor off
        ***********************
        _tempniks = m_hmickeys()        
        _temp = m_row()                 
        m_csroff()                      

        * shut off the highlight
        ************************
        print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
              _offset[_fieldnum],_width),_color,_width)
        
        * save the screen
        *****************
        _tempscrn2 = savescreen()
        
        ******************************************************
        *** Loop around while the appropriate key or       ***
        *** button is being pressed                        ***
        ******************************************************

do while (kbdstat(2) .or. (_isbutton(1)))

        if (_isbutton(1))
                _tempniks = m_movement()
                print(_temp,_bcol,chr(29),roloc(_color))
                m_csrput(_temp,_bcol)
        endif

        if ((_tempniks = 4) .or. ;             && going left
             (_pkey = 52))
                if (_bcol = (_tcol+_minwidth+1))
                        m_squeak()
                        _pkey = inkey()
                        loop
                else
                        m_csroff()
                        restscreen(_trow,_bcol,_brow,_bcol,savescreen(;
                                   _trow,_bcol,_brow,_bcol,_tempscrn2))
                        _bcol = _bcol-1
                        _width = (_bcol-_tcol)-1
                        box(_trow, _tcol, _brow, _bcol, left(m_frame(),8), _color)
                        _pkey = inkey()
                        loop
                endif
        elseif ((_tempniks = 2) .or. ;                 && going right
               (_pkey = 54))

        ******************************************************
        *** see if we're beyond maximum virtual coordinate ***
        ******************************************************

                if (_bcol >= m_data(11)-_shadsize[2])
                        m_squeak()
                        _pkey = inkey()
                        loop
                else
                        restscreen(_trow,_bcol,_brow,_bcol,savescreen(;
                                   _trow,_bcol,_brow,_bcol,_tempscrn2))
                        _bcol = _bcol+1
                        _width = (_bcol-_tcol)-1
                        box(_trow, _tcol, _brow, _bcol, left(m_frame(),8), _color)
                        _pkey = inkey()
                        loop
                endif
        endif

_pkey = inkey()

enddo

restscreen(_trow,_bcol,maxrow(),maxcol(),savescreen(;
           _trow,_bcol,maxrow(),maxcol(),_tempscrn))

m_csroff()
do dbxdispbox
print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
      _offset[_fieldnum],_width),_pback,_width)
do dbxdisparr
do dbxarrfill
m_csron()

return

        ****************************************************** 
        *** This part expands the window up and down from  ***
        *** the bottom of window. Notice how the FUNCky    ***
        *** edition of savescreen() allows the function to ***
        *** restore part of a previously saved screen      ***
        ****************************************************** 


proc dbxmovebot 

        _tempniks = m_vmickeys()            && clear the micky count
        m_csroff()                          && we'll simulate a mouse cursor
        _temp = m_col()                     && store current col

        * shut off the highlight
        ************************
        print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
              _offset[_fieldnum],_width),_color,_width)

        * save the screen
        *****************
        _tempscrn2 = savescreen()
        
do while (kbdstat(2) .or. (_isbutton(1)))

        if (_isbutton(1))
                _tempniks = m_movement()
                m_csrput(_brow,_temp)
                print(_brow,_temp,chr(18),roloc(_color))
        endif

        if (_pkey = 56 ) .or. ;                         && going up
           _tempniks = 1
                if ((_brow-_trow) < 5)
                        m_squeak()
                        _pkey = inkey()
                        loop
                else
                        m_csroff()
                        restscreen(_brow,_tcol,_brow,_bcol,savescreen(;
                                   _brow,_tcol,_brow,_bcol,_tempscrn2))
                        _pactive = iif(_pactive = _alen,_pactive-1,_pactive)
                        _brow = _brow-1
                        _alen = _alen-1
                        box(_trow, _tcol, _brow, _bcol, left(m_frame(),8), _color)
                        _pkey = inkey()
                        loop
                endif
        elseif (_pkey = 50) .or. ;                      && going down
                _tempniks = 3

        ******************************************************
        *** see if we're beyond maximum virtual coordinate ***
        *** or at end of array                             ***
        ******************************************************

                if (_brow >= (m_data(10)-_shadsize[3])) .or.;
                   (((_brow-_trow)-3) = len(linearray))
                        m_squeak()
                        _pkey = inkey()
                        loop
                else
                        restscreen(_brow,_tcol,_brow,_bcol,savescreen(;
                                   _brow,_tcol,_brow,_bcol,_tempscrn2))
                        _brow    = _brow+1
                        _alen    = _alen+1
                        box(_trow, _tcol, _brow, _bcol, left(m_frame(),8), _color)
                        _pkey = inkey()
                        loop
                endif
        endif

_pkey = inkey()

enddo

m_csroff()
restscreen(_brow,_tcol-_shadsize[4],maxrow(),maxcol(),savescreen(;
           _brow,_tcol-_shadsize[4],maxrow(),maxcol(),_tempscrn))

_plast = _pactive
do dbxdispbox
goto recnum[1]
do readarrdbx
m_csron()
goto recnum[_pactive]
do dbxdisparr
do dbxarrfill
_plast = _pactive

return

proc dbxmove 

        * see if we are allowed to move the window
        ******************************************
        if (m_data(12) = 0)
                return
        endif

        m_csroff()      
        print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
              _offset[_fieldnum],_width),_color,_width)
        
        _temp = m_row()                        && store current row
        _temp2= m_col()                        && store current col
        _tempniks  = m_hmickeys()              && clear any extra movement

        do movewin2 with _trow, _tcol, _brow, _bcol, _temp, _temp2, _shadsize, _tempscrn, _color
        
        m_csroff()
        m_csrput(_temp,_temp2)
        restscreen(0,0,_trow,maxcol(),savescreen(;
                   0,0,_trow,maxcol(),_tempscrn))
        restscreen(0,_bcol,maxrow(),maxcol(),savescreen(;
                   0,_bcol,maxrow(),maxcol(),_tempscrn))
        restscreen(_brow,0,maxrow(),maxcol(),savescreen(;
                   _brow,0,maxrow(),maxcol(),_tempscrn))
        restscreen(0,0,maxrow(),_tcol,savescreen(;
                   0,0,maxrow(),_tcol,_tempscrn))

        do dbxdispbox
        do dbxdisparr
        m_csroff()
        print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
              _offset[_fieldnum],_width),_pback,_width)
        m_csron()
        do dbxarrfill
        
return

proc dbxarrfill

        afill(_acol,-1)
        afill(_acol2,-1)
        afill(_arow,-1)

        for _x = 1 to _alen
                _arow[_x] = (_trow+_x+1)
                _acol[_x] = (_tcol+1)
                _acol2[_x]= (_tcol+_width)
        next

return

proc dbxdispbox

        box(_trow, _tcol, _brow, _bcol, m_frame(), _color,m_data(16),m_data(17))
        print(_trow+1,_tcol+1,substr(_header,_offset[_fieldnum],_width), ;
              _phigh,_width)
        _tempstr = untrim(chr(179)+m_title(),(_width-_minwidth)-15)
        _fstring = untrim("Record #:"+str(recno(),5),(_width-_minwidth)-len(_tempstr))+;
                   _tempstr+_control
        print(_brow-1,_tcol+1, _fstring,_phigh,_width)

return

proc dbxdisparr

        print(_trow+1,_tcol+1,substr(_header,_offset[_fieldnum],_width), ;
              _phigh,_width)
        for _x = 1 to _alen
               print(_trow+_x+1,_tcol+1,substr(linearray[_x], ;
                     _offset[_fieldnum],_width),_color,_width)
        next
        if (_flag)
                print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
                      _offset[_fieldnum],_width),_pback,_width)
        endif
        _tempstr = untrim(chr(179)+m_title(),(_width-_minwidth)-15)
        _fstring = untrim("Record #:"+str(recno(),5),(_width-_minwidth)-len(_tempstr))+;
                   _tempstr+_control
        print(_brow-1,_tcol+1, _fstring,_phigh,_width)

return

proc _dbxstat
para _word

        _tempstr = untrim(chr(179)+m_title(),(_width-_minwidth)-15)
        _fstring = untrim(_word,(_width-_minwidth)-len(_tempstr))+;
                   _tempstr+_control
        m_csroff()
        print(_brow-1,_tcol+1, _fstring,_phigh,_width)
        m_csron()

return

proc dbxxret

        && since we're leaving, shut off the highlight
        m_csroff()
        print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
              _offset[_fieldnum],_width),_color,_width)
        m_csron()

        m_data(2,_pactive)              && set the last active element
        m_data(24,_trow)                && new top row coordinates
        m_data(25,_tcol)                && new top col coordinates
        m_data(26,_brow)                && new bot row coordinates
        m_data(27,_bcol)                && new bot col coordinates

        m_data(31,recnum[_pactive])     && place last record # into data area
        m_data(4,0)                     && calling proc sets this we don't
                                        && set to 1 except when the MOUSE
                                        && is clicked in the inner loop!
                                        && if mouse was or wasn't
                                        && clicked outside of window

        if (_trow != _dbfwinmov[1]) .or. ; 
           (_tcol != _dbfwinmov[2]) .or. ; 
           (_brow != _dbfwinmov[3]) .or. ;
           (_bcol != _dbfwinmov[4])
                                        && if the window was moved
                m_data(28,1)            && record that it was
                m_trow = _trow          && and load the new values into
                m_tcol = _tcol          && initial variables in case they     
                m_brow = _brow          && were sent with the @ sign
                m_bcol = _bcol
        else                            
                m_data(28,0)            && else it wasn't moved
        endif

        if (m_data(22) = 1)              && and if we are supposed
                                         && to automatically restore screen
                m_csroff()
                restscreen(0,0,maxrow(),maxcol(),_tempscrn)
                m_csron()
        endif

return


*----------------------------------------------------------------------------*





*****************************************************************************
*
*       Program       : FUNCky.lib
*       Author        : Dirk Andrew Lesko
*       Copyright     : (C) 1988 dLESKO ASSOCIATES. All rights reserved
*
*       Function      : m_dbfview()
*       Purpose       : view a dbf file in a window with mouse support
*       Usage         : <offset> = m_dbfview(<row>,<col>,<row>,<col>, ;
*                                           <titles>, <fields>, [<color]), ;
*					     <_criteria1>,<_criteria2>)
*
*	Modified      : Jeffrey Springer (after Mark Wollam)
*			1. display matter info for each line (see SPECIAL())
*			2. don't allow scrolling into empty stuff
*			3. _criteria1 = loop control based on index key
*			4. _criteria2 = expression to match records
*
*
***********************************   
*------------------------------------*
*    Comments:  Uses the MMA
*               
*               
*               
*----------------------------------------------------*
FUNCTION m_dbfview
*-----------------------------------------------------------*
parameter _trow, _tcol, _brow, _bcol, _fheader, _fields, _color, ;
	  _criteria1, _criteria2

private _trow,_tcol,_brow,_bcol,_fname,_color,_shadow, ;
        _handle, _alen, _width, _pkey, _plast, _pactive, _header, ;
        _pback, _temp, _fstring, _linelen, _text, _tscreen, _tempstr, ;
        _tempstr2, _y, _fieldnum, _findstr, _fcount, _phigh, _temprec

        * make sure there is a DBF open and the arrays are present
        **********************************************************  
        if (! used()) .or. (pcount() < 6)
                m_data(30,-8)           && notify MMA
                return(-8)              && no DBF in use
        endif

        * if there is a DBF open, store the current recno()
        * in case they escape out, or click outside the window area
        *********************************************************** 
        _temprec = recno()

        * check for conditions
        ****************************************
        if (type('_criteria1') = 'U')
           _criteria1 = .t.
        else
           m_data(31) = recno()
        endif

        if (type('_criteria2') = 'U')
           _criteria2 = .t.
        endif

        * get the color, and setup the defaults
        ***************************************
        if (pcount() < 7)                       && if no color, use default
                _color = -1
        endif
        if (_color = -1)                        && if no color, use default
                _color   = standard()
                _pback   = enhanced()
                _phigh   = roloc(_color)
        else
                _pback   = roloc(_color)        && reverse of _color
                _phigh   = roloc(_color)
        endif

        * variables to store keystroke, active, and last active elements
        * temporary strings and whatnot
        ****************************************************************
        _pkey    = 0                    
        _plast   = 1                    
        _pactive = 1                    
        _tempstr = ""
        _tempstr2= ""
        _header  = ""
        _fcount  = len(_fheader)

        * declare the array that holds the offsets for scrolling
        ********************************************************
        declare _offset[len(_fields)]

        * setup the header string and the offsets for each field
        ********************************************************
        for _x = 1 to len(_fields)
                _tempstr= _fields[_x]
                _temp   = len(&_tempstr)
                _offset[_x] = len(_header)+1
                _fheader[_x] = untrim(_fheader[_x], iif(_temp>(len(_fheader[_x])+1), ;
                                         _temp,len(_fheader[_x])))
                _header = _header+_fheader[_x]+chr(179)
        next

        * starting left offset to start printing is from the first field
        ****************************************************************
        _fieldnum = 1                   

      ******************************************************************
      *** get type of shadow and calculate the extra space to add to ***
      *** the rows and columns to accomodate the shadow when         ***
      *** positioning and saving/restoring the screen                ***
      ******************************************************************
        declare _shadsize[4]

        * use _tscreen temporarily so we don't have to declare a variable
        * and get the shadow type to calculate correct size of box
        *****************************************************************
        _shadow = m_data(16)            && shadow type data
        _tscreen= ltrim(str(_shadow)) 

        * can't let shadow disappear off the screen! so setup
        * the elements to add to the box coordinates for bounds checking
        ****************************************************************  
        _shadsize[1] = iif(_tscreen $ "789", 1,0)
        _shadsize[2] = iif(_tscreen $ "963", 1,0)
        _shadsize[3] = iif(_tscreen $ "123", 1,0)
        _shadsize[4] = iif(_tscreen $ "741", 1,0)

        * see if the width if the box can hold the status line
        * and the control panel, if it can't, then expand it a little
        *************************************************************
        _width   = ((_bcol-_tcol)-1)
        do while (_width < 26)   
                _bcol    = _bcol+1
                _tcol    = _tcol-1
                _width   = ((_bcol-_tcol)-1)
        enddo

        * make sure box has at least 5 lines in it
        ****************************************** 
        do while ((_brow-_trow) < 5)
                _brow = _brow+1
                if ((_brow-_trow) < 5)
                        _trow = _trow-1
                endif
        enddo

      *********************************************************************
      *** now check that the box is inside the screen. Since the box    ***
      *** doesn't move, it is not checked against the virtual window    ***
      *** coordinates in the global mouse data area, the shadow size    ***
      *** is added in however.
      *********************************************************************

        * if the box is beyond the screen boundaries
        * move it back. Check for the shadow as well
        ********************************************
        if (_tcol-_shadsize[4] < 0)
                _tcol = 0+_shadsize[4]
                _bcol=_tcol+_width
        endif

        * now do the right side.....
        ****************************
        if (_bcol+_shadsize[2] > maxcol())           
                _bcol = maxcol()-_shadsize[2]
        endif

        * now do the top....
        ********************
        if (_trow-_shadsize[1] < 0)
                _trow = 0+_shadsize[1]
        endif

        * now do the bottom....
        ***********************
        if (_brow+_shadsize[3] > maxrow()+_shadsize[3])
                _brow = maxrow()-_shadsize[3]
        endif

        * recalculate the width of the box
        ********************************
        _width   = ((_bcol-_tcol)-1)    

        * calculate the length of the array that will hold the fields  
        * from the file.
        ***************************************************************
        _alen    = ((_brow-_trow)-3)    

        * this builds that status line that gets 
        * displayed on the bottom line of the box
        *****************************************
        _fstring = "Record #:     "+chr(179)+ ;
                   untrim(m_title(),_width-26)+chr(179)+chr(240)+chr(179)+chr(24)+;
                   chr(179)+chr(25)+chr(179)+chr(27)+chr(179)+chr(26)+" "

        * declare all the arrays that will hold the lines
        * of text, the record # into the file for each line, as
        * well as the rows and columns of each displayed line of text
        *************************************************************
        declare linearray[_alen], recnum[_alen], _arow[_alen], ;
                _acol[_alen], _acol2[_alen]

        afill(_acol,_tcol)
        afill(_acol2,_tcol+_width)
        for _x = 1 to _alen
                _arow[_x] = _trow+_x+1
        next

        * coordinate the mouse cursor
        *****************************  
        m_csron()
        m_csroff()

        * if the autosave flag is set to 1, then save the screen under
        * the box so we can restore it automatically for you!, how nice
        ***************************************************************
        if (m_data(22) = 1)
                _tscreen = savescreen(_trow-_shadsize[1], ;
                                      _tcol-_shadsize[4], ;
                                      _brow+_shadsize[3], ;
                                      _bcol+_shadsize[2])
        endif

        * if they entered the routine and are still holding down the
        * left mouse button, wait here until they release it
        ************************************************************
        do while _isbutton(0)
        enddo

        * use scroll to clear the location of the box since it
        * is faster than letting box() do it.
        ******************************************************
        scroll(_trow, _tcol, _brow, _bcol, 0, _color)

        * display our box and status line
        ********************************* 
        box(_trow, _tcol, _brow, _bcol, m_frame(), _color,m_data(16),m_data(17))
        print(_trow+1,_tcol+1,_header,_phigh,_width)
        print(_brow-1,_tcol+1, "Reading....   "+chr(179)+ ;
              right(_fstring,len(_fstring)-15),_phigh,_width)

        * if the auto restart flag is set to 1 then move the
        * file pointer to the record # stored in the file position
        * global data area (m_data(31)), and reset the active element
        * to where it was. the file position data contains the
        * file record # of the first displayed line of text
        * the last active element should have the last active element
        * that was highlighted. This has to be set in the calling program
        *****************************************************************
        if (m_data(29) = 1)
                goto m_data(31)
                _pactive = m_data(2)

                * do some bounds checking
                *************************
                if (_pactive > _alen)
                        _pactive = _alen
                endif
                _plast = _pactive
        endif

        * mouse cursor on, regular cursor off, and read in the lines of text
        * into the array used for display
        ******************************************************************** 
        m_csron()
        csroff()
        do dbfreadarr
	IF _x = 0
		RETURN(-3) && no conditions2 met
	ENDIF
        goto recnum[1]

        * use the loop inside a loop trick for programming ease
        *******************************************************

        do while .T.
        
            * display the entire array if inside the outer loop
            ***************************************************   
            m_csroff()
            print(_trow+1,_tcol+1,substr(_header,_offset[_fieldnum],_width), ;
                  _phigh,_width)
            for _x = 1 to _alen
                   print(_trow+_x+1,_tcol+1,substr(linearray[_x], ;
                         _offset[_fieldnum],_width),_color,_width)
            next
            print(_trow+_pactive+1,_tcol+1,substr(linearray[_pactive], ;
                  _offset[_fieldnum],_width),_pback,_width)
            print(_brow-1,_tcol+1, ;
                  SPECIAL(recno()),_phigh)
            m_csron()
        

            * check for mouse or key activity
            *********************************

            do while .T.
        
                * if active element has been moved, then 
                * redisplay the highlight
                ****************************************
                if (_pactive != _plast)
                        m_csroff()
                        print(_trow+_pactive+1,_tcol+1, ;
                              substr(linearray[_pactive], ;
                              _offset[_fieldnum],_width),_pback,_width)
                        print(_trow+_plast+1,_tcol+1, ;
                              substr(linearray[_plast], ;
                              _offset[_fieldnum],_width),_color,_width)
                        print(_brow-1,_tcol+1, ;
                              SPECIAL(recno()),_phigh)
                        m_csron()
                endif        

                * check for a key, and save last active element
                ***********************************************
                _pkey  = waitkey()      
                _plast = _pactive
        

                * check if valid key, or mouse movement
                ***************************************
                do case

                ****************************************************** 
                *** if exceptions are to be processed, then see if ***
                *** the user clicks outside the window area, if so ***
                *** then return with no selection made (-2),       ***
                *** else beep if they can't exit that way          ***
                ****************************************************** 
        
                case (_isbutton(0).and.(! m_region(_trow,_tcol,_brow,_bcol)))
                        if (m_data(3) = 1)
                                do dbfviewret
                                m_data(4,1)     && tell em they clicked
                                                && outside the box coords     
                                goto _temprec   && restore record ptr
                                m_data(30,-2)   && notify MMA
                                return(-2)
                        else 
                                m_squeak()
                                loop
                        endif

                * see if they pressed ESCape or clicked the triple bar
                * in the control panel
                ******************************************************   
                case (_pkey = 27) .or. (_isbutton(0) .and. ;    
                      (m_row() = _brow-1) .and. (m_col() = _bcol - 10))
                        putkey(27)
                        do dbfviewret
                        goto _temprec   && restore record ptr
                        m_data(30,0)    && notify MMA
                        return(0)

                * see if they pressed return or clicked on a record
                ******************************************************
                case (_pkey = 13) .or. (_isbutton(0) .and. ;
                     m_region(_trow+3,_tcol+1,_brow-3,_bcol-1))
                        putkey(13)
                        do dbfviewret
                        m_data(30,-1)           && selection made
                        return(recnum[_pactive])

                * see if they pressed the up arrow, or clicked the
                * left button on the up arrow in the control panel
                **************************************************
                case (_pkey = 5) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. (m_col() = _bcol-8)))
                        putkey(5)
                        if (_pactive = 1)
                                do dbfreadbac
                                exit
                        else 
                                _pactive = _pactive-1
                                goto recnum[_pactive]
                                loop
                        endif
        
                * see if they pressed the down arrow, or pressed the
                * left button while on the down arrow in the control panel
                **********************************************************
                case (_pkey = 24) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-6))) 
                        putkey(24)
                        if (_pactive = _alen)
                                do dbfreadfor 
                                exit
                        else 
                 * don't let them scroll into a blank element
                **********************************************************
                               if ( ! empty(linearray[_pactive+1]) )
                                   _pactive = _pactive+1
                                   goto recnum[_pactive]
                                else
                                   m_squeak()
                                   waitkey(8)
                                endif
                                loop
                        endif
      
                * see if they pressed the left arrow, or clicked the
                * left button while on the left arrow in the control panel
                **********************************************************  
                case (_pkey = 19) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. (m_col() = _bcol-4)))
                        putkey(19)

                        * check to see if the left offset is at
                        * the beginning when moving left
                        ***************************************
                        if (_fieldnum <= 1)
                                m_squeak()
                                loop
                        else 
                                _fieldnum = _fieldnum-1
                                waitkey(1)
                                exit
                        endif
        
                * see if they pressed the right arrow, or clicked the
                * left button while on the right arrow in the control panel
                ***********************************************************  
                case (_pkey = 4) .or. ((_isbutton(0)) .and. ;
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-2)))              
                        putkey(4)
                        if (_fieldnum < len(_fields))
                                _fieldnum = _fieldnum+1
                                waitkey(1)
                                exit
                        else 
                                m_squeak()
                                loop
                        endif
        
                * see if the user pressed CTRL/HOME key, or clicked
                * the left button while on the top line of the box
                * goto top of file if so
                ***************************************************
                case (_pkey = 29) .or. ((_isbutton(0) .and. ;    
                     (m_region(_trow,_tcol+1,_trow,_bcol-1))))
                        putkey(29)
                        go top
                        do dbfreadarr
                        goto recnum[1]
                        _pactive = 1
                        exit
        
                * see if the user pressed HOME key
                **********************************
                case (_pkey = 1)
                        putkey(1)
                        goto recnum[1]
                        _pactive = 1
                        loop
        
                * see if the user pressed END key
                *********************************
                case (_pkey = 6)
                        putkey(6)
                        goto recnum[_alen]
                        _pactive = _alen
                        loop
        
                * see if the user pressed CTRL/END key, or clicked
                * the left button while on the bottom line of the box
                * goto bottom of file if so
                ******************************************************
                case (_pkey = 23) .or. ((_isbutton(0) .and. ;    
                     (m_region(_brow,_tcol+1,_brow,_bcol-1))))
                        putkey(23)
                        print(_brow-1,_tcol+1, ;
                              "Reading....   "+chr(179),_phigh)
                        go bott
                        for _x = 1 to _alen-1
                                skip -1
                        next
                        _pactive = _alen
                        do dbfreadarr
                        goto recnum[_pactive]
                        exit
        
                * see if the user pressed the page up key, or if
                * they clicked the right button on the up arrow
                * in the control panel. Advance a page of text if they did
                **********************************************************
                case (_pkey = 18) .or. ((_isbutton(1)) .and. ;
                     ((m_row() = _brow-1) .and. (m_col() = _bcol-8)))  
                        putkey(18)
                        goto recnum[1]
                        skip -1
                        if bof()
                                print(_brow-1,_tcol+1, ;
                                      "Top of File..."+chr(179),_phigh)
                                m_squeak()
                                _pactive = 1
                                goto recnum[_pactive]
                                exit
                        else 
                                print(_brow-1,_tcol+1, ;
                                      "Reading....   "+chr(179),_phigh)
                                if (_alen > 1)
                                        skip (1-_alen)
                                endif
                                do dbfreadarr
                                goto recnum[_pactive]
                                exit
                        endif
        
                * see if the user pressed the page down key, or if
                * they clicked the right button on the down arrow
                * in the control panel. Rewind a page of text if they did
                *********************************************************
                case (_pkey = 3) .or. ((_isbutton(1)) .and. ;   
                     ((m_row() = _brow-1) .and. ;
                     (m_col() = _bcol-6)))     
                        putkey(3)
                        goto recnum[_alen]
                        skip 1
                        if eof()
                                print(_brow-1,_tcol+1, ;
                                      "End of File..."+chr(179),_phigh)
                                m_squeak()
                                goto recnum[_alen]
                                _pactive = _alen
                                exit
                        else
                                do dbfreadarr
                                goto recnum[_pactive]
                                exit
                        endif

                * see if they pressed ALT/S or clicked the mouse
                * over the Record # portion of the screen
                ************************************************   
                case (_pkey = 287) .or. (_isbutton(0) .and. ;
                     m_region(_brow-1,_tcol+1,_brow-1,_bcol-11))
                        if .not. isindex()
                                loop
                        endif
                        putkey(287)
                        m_csroff()
                        _findstr = space(_width-19)
                        print(_brow-1,_tcol+1,"Search: ",_phigh)
                        csron()
                        reads(_brow-1,_tcol+9,_findstr,_phigh)
                        csroff()

                        * if they ESCaped out, just return
                        **********************************
                        if (lastkey() = 27)
                                print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                                m_csron()
                                loop
                        endif

                        * otherwise go fish.....
                        ************************
                        print(_brow-1,_tcol+1, ;
                              "Searching.... "+chr(179),_phigh)
                        seek upper(alltrim(_findstr))
                        if ( found() .AND. &_criteria1 .AND. &_criteria2 )
                                do dbfreadarr
                                goto recnum[1]
                                _pactive = 1
                        else
                                m_squeak()
                                goto recnum[_pactive]
                                print(_brow-1,_tcol+1,[TEXT "]+alltrim(_findstr)+ ;
                                      [" Not Found],_phigh,_width)
                                waitkey(38)      && wait two seconds (more or less)
                        endif
                        print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                        print(_brow-1,_tcol+1, ;
                              SPECIAL(recno()),_phigh)
                        m_csron()
                        exit

                * see if they pressed ALT/G
                ***************************   
                case (_pkey = 290)
                        _findstr = space(_width-17)
                        m_csroff()
                        print(_brow-1,_tcol+1,"Goto: ",_phigh)
                        csron()
                        reads(_brow-1,_tcol+7,_findstr,_phigh)
                        csroff()

                        * if they ESCaped out, just return
                        **********************************
                        if (lastkey() = 27)
                                print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                                m_csron()
                                loop
                        endif

                        * otherwise go fish.....
                        ************************
                        print(_brow-1,_tcol+1, ;
                              "Going....     "+chr(179),_phigh)
                        _temp = val(_findstr)
                        if ((_temp < 0) .or. (_temp > lastrec()) .OR. ;
                        	(! &_criteria1) .OR. (! &_criteria2))
                                m_squeak()
                                print(_brow-1,_tcol+1,"Out of Range....",_phigh,_width)
                                goto recnum[_pactive]
                                waitkey(38)      && wait two seconds (more or less)
                        else
                                goto _temp
                                do dbfreadarr
                                _pactive = 1
                                goto recnum[1]
                        endif
                        print(_brow-1,_tcol+1,_fstring,_phigh,_width)
                        print(_brow-1,_tcol+1, ;
                              SPECIAL(recno()),_phigh)
                        m_csron()
                        exit

                * if an ALT/R is pressed, refresh the display
                * so that a set key to can reposition the record pointer
                ********************************************************
                case (_pkey = 275)
                        goto recnum[1]
                        do dbfreadarr 
                        goto recnum[_pactive]
                        exit

                * if the user presses a letter, then hunt it down
                * within the file only if an index is active
                *************************************************
                case (_pkey != 0)                                
                        if isindex()
                                print(_brow-1,_tcol+1, ;
                                      "Searching.... "+chr(179),_phigh)
                                seek upper(chr(_pkey))
                                if ( found() .AND. &_criteria1 .AND. &_criteria2 )
                                        do dbfreadarr
                                        goto recnum[1]
                                        _pactive = 1
                                        exit
                                else 
                                        m_squeak()
                                        goto recnum[_pactive]
                                endif
                        endif

                ****************************************************** 
                *** if the mouse cursor is over an element then    ***
                *** make that element active, and redisplay the    ***
                *** highlight over it.                             ***
                ****************************************************** 
        
                case m_region(_trow+2,_tcol+1,_brow-2,_bcol-1)       && mouse
                        _temp = m_aregion(_arow,_acol,_arow,_acol2)  
                        if _temp > 0
                                _pactive = _temp
                                goto recnum[_temp]
                        endif
                        loop                
        
                endcase
        
            enddo
        enddo
        
PROC dbfreadbac

        ***************************************************
        *** this routine reads backwards one record     ***               
        *** and inserts it into the first element       ***
        *** of the array                                ***
        ***************************************************
        skip -1
        if ( bof() .OR. ! &_criteria1 .OR. ! &_criteria2)
                print(_brow-1,_tcol+1, ;
                      "Top of File..."+chr(179),_phigh)
                m_squeak()
                goto recnum[1]
                return
        endif
        ains(linearray,1)
        ains(recnum,1)
        recnum[1]    = recno()
        linearray[1] = ""
        for _y = 1 to _fcount
                _tempstr2= _fields[_y]
                linearray[1] = linearray[1]+ ;
                                   untrim(&_tempstr2,len(_fheader[_y])+1)
        next
        goto recnum[_pactive]

return

PROC dbfreadfor

        ***************************************************
        *** this routine reads forward one record       ***               
        *** and inserts it into the last element        ***
        *** of the array                                ***
        ***************************************************

       skip 1

        * loop forwards thru file, looking for next match
        ************************************

       do while ( &_criteria1 .and. ! eof() )

           if (&_criteria2)
              * found one
              *****************************
              adel(recnum,1)
              adel(linearray,1)
              recnum[_alen]    = recno()
              linearray[_alen] = ""
              for _y = 1 to _fcount
                      _tempstr2= _fields[_y]
                      linearray[_alen] = linearray[_alen]+ ;
                                         untrim(&_tempstr2,len(_fheader[_y])+1)
              next
              goto recnum[_pactive]
              exit
           endif
           skip 1

       enddo


        if ( eof() .OR. ! &_criteria1 )
                print(_brow-1,_tcol+1, ;
                      "End of File..."+chr(179),_phigh)
                m_squeak()
                goto recnum[_alen]
                return
        endif
        adel(recnum,1)
        adel(linearray,1)
        recnum[_alen]    = recno()
        linearray[_alen] = ""
        for _y = 1 to _fcount
                _tempstr2= _fields[_y]
                linearray[_alen] = linearray[_alen]+ ;
                                   untrim(&_tempstr2,len(_fheader[_y])+1)
        next
        goto recnum[_pactive]

return

PROC dbfreadarr

        ***************************************************
        *** this routine reads forward the number       ***               
        *** of records needed to fill the entire array  ***
        ***************************************************
        print(_brow-1,_tcol+1, ;
              "Reading....   "+chr(179),_phigh)
        _x = 0

        * read the file
        ************************************
        do while ( &_criteria1. .and. _x <= _alen .and. ! eof() )

           if ( &_criteria2 )
               * we have a winner
               **********************
              _x = _x+1
              linearray[_x] = ""
              for _y = 1 to _fcount
                  _tempstr2= _fields[_y]
                  linearray[_x] = linearray[_x]+ ;
                        untrim(&_tempstr2,len(_fheader[_y])+1)
              next
              recnum[_x] = recno()
           endif
           skip 1

        enddo

	IF _x = 0  && no winners
		RETURN
	ENDIF
	
	_x = _x + 1
        if ( _x < _alen )

           * fill out the balance of the array
           ****************************
           _z = _x
           skip -1
           for _z = _x to _alen
               linearray[_z] = " "
               recnum[_z] = recno()
           next
        endif

return

proc dbfviewret

        ***************************************************
        *** this routine does all the exit stuff.       ***               
        *** Global mouse data is updated                ***
        ***************************************************

        * if we're supposed to autosave the screen, then restore
        * what was there originally
        *********************************************************
        if (m_data(22) = 1)
                m_csroff()
                restscreen(_trow-_shadsize[1], ;
                           _tcol-_shadsize[4], ;
                           _brow+_shadsize[3], ;
                           _bcol+_shadsize[2], ;
                           _tscreen)
                m_csron()
        endif

        m_data(31,recnum[1])            && place first line of text's
                                        && record number into the data area

        m_data(2,_pactive)              && set the last active element #
        m_data(4,0)                     && click outside of box area??
                                        && set to true by the previous
                                        && case statement if they did

        m_data(28,0)                    && window moved flag (it didn't)

return
*----------------------------------------------------------------------------*
********************************************************************
* displays client and mattercode along with matter description
FUNCTION special
PARAMETER recnum
_str = SPACE(15)
IF ALIAS() = "DOC"
	GOTO recnum
	code =  clientcode + mattercode
	SELECT client
	SET ORDER TO 2
	SEEK doc->clientcode
	SET ORDER TO 1
	_str1 = RTRIM(SUBSTR(RTRIM(client),1,20)) + CHR(179)
	SELECT matter
	SEEK code
	_str2 = SUBSTR(matterdesc,1,58-LEN(_str1))
	_str = _str1 + _str2
	SELECT doc
ENDIF
RETURN(_str)

