* Program.: CCCdemo.prg
* Author .: Gale Ford
* Edited .: January 1, 1987
* Notice .: Copyright 1986, Clear Creek Computing
*
* Notes...: User defined functions adding extra features to Clipper.
*           Compatible with Autumn 86.
*           We are testing only a few  of the functions found in CCCFUNC.prg
*           Use the examples found here and the functions found in
*           CCCFUNC.PRG as you see fit. The examples and functions
*           are submitted as is without our being reponsible for any
*           damages or loss of data from their use. If you like
*           them or have any comments, please contact ID NA2415.
*           Have fun.
*
*
Set Message to 24

*Just a few variables to use in this demo
MCO_NAME    =  "Clear Creek Computing"
MCO_ADDR    =  "303 East Walker"
MCO_CITY    =  "League City"
MCO_PHONE   =  "(713)332-3302"
MCO_STATE   =  "TX"
MCO_ZIP     =  "77573"

*Setup some variable for color selection
if iscolor()
    MBORD_CLR   =  "GR/N"
    MNORM_CLR   =  "GR+/N"
    MGETS_CLR   =  "GR+/GR"
    MGETU_CLR   =  "GR+/R"
else
    MBORD_CLR   =  "W/N"
    MNORM_CLR   =  "W+/N"
    MGETS_CLR   =  "N/W"
    MGETU_CLR   =  "N/U"
endif

*Default options
XSTATECHK1 = substr("Texas"+SPACE(20),1,20)
XSTATECHK2 = "TX"
XSTATECHK3 = substr("TX"+SPACE(20),1,20)
XAGECHK1 = CTOD("06/20/57")
XAGECHK2 = CTOD("06/20/57")
XAGECHK3 = DATE()
XDATECHK1 = DATE()
XDATECHK2 = DATE()

*default menu choice
Option = 1

* set heading colors, also the selected and unselected gets colors
Set Color to &mBORD_clr.,&mGETS_clr.,,,&mGETU_clr

clear
@ 1,2 Say "ͻ"
@ 2,2 Say "                                                                       "
@ 3,2 Say "                                                                       "
@ 4,2 Say "                                                                       "
@ 5,2 Say "ͼ"
@ 6,5 Say "Function and Usage"
@ 6,39 Say  "Type     Value"
@ 7,38 Say "Output    Output"
@ 09,40 Say [C]
@ 10,40 Say [C]
@ 11,40 Say [L]
@ 13,40 Say [N]
@ 16,40 Say [C]
@ 17,40 Say [C]

**** disp name and address variables IN NORMAL COLOR
Set Color to &mNORM_clr
@ 2,35 Say MCO_NAME
@ 3,10 Say DtoE(DATE())
@ 3,35 Say MCO_ADDR
@ 4,35 Say TRIM(MCO_CITY)+', '+MCO_STATE+'  '+MCO_ZIP+'  '+MCO_PHONE

*** display results of functions for first time through
@ 09,48 say state(XSTATECHK1) Pict "!!"
@ 10,48 say state(XSTATECHK2) Pict "!XXXXXXXXXXXXXXXXXXX"
@ 11,48 say state(XSTATECHK3,.T.)
@ 13,48 say age(XAGECHK1) Pict "999"
@ 14,48 say age(XAGECHK2,XAGECHK3) Pict "999"
@ 16,48 say dtoe(XDATECHK1)
@ 17,48 say dtol(XDATECHK2)

***************** Main loop while option <> Quit or Escape ************
do while Option <> 8

*** Note the SayCenter use on One Line by Itself
        Set Color to &mBORD_clr
        SayCenter(21,79,"Use the ARROW keys to HIGHLIGHT FUNCTION and then Press ENTER.")
        SayCenter(22,79,"F1 = Help, Q or Esc = Quit.")

*** Note the spcenter() function on the message
        Set Color to &mNORM_clr.,&mGETS_clr
        @ 09,0 prompt 'STATE("'+substr(trim(XSTATECHK1)+'")'+space(22),1,22) Message spcenter("FULL State Name converted to its Abbreviated form. (2 Blanks if invalid)")
        @ 10,0 prompt 'STATE("'+XSTATECHK2+'")' Message spcenter("ABBREVIATED State converted to its Full Name. (20 Blanks if invalid)")
        @ 11,0 prompt 'STATE("'+substr(trim(XSTATECHK3)+'",.T.)'+space(26),1,26) Message spcenter("ABBREVIATED or FULL State Name Validated only. (Used for Valid function)")
        @ 13,0 prompt 'AGE(ctod("'+dtoc(XAGECHK1)+'"))' Message spcenter("Date converted to the age in years as of system date.")
        @ 14,0 prompt 'AGE(ctod("'+dtoc(XAGECHK2)+'"),ctod("'+dtoc(XAGECHK3)+'"))' Message spcenter("Differance between 2 Dates converted to the Age in Years Between them.")
        @ 16,0 prompt 'DTOE(ctod("'+dtoc(XDATECHK1)+'"))' Message spcenter("Date converted to an expanded form.")
        @ 17,0 prompt 'DTOL(ctod("'+dtoc(XDATECHK2)+'"))' Message spcenter("Date converted to a legal form.")
        @ 19,0 Prompt "Quit" Message spcenter("QUIT this demo.")
        Menu to Option
        Set Color to ,&mGETU_clr
    Do Case

    Case Option = 8 .or. Lastkey() = 27
        Option = 8
        loop

*** State name to abbr.
    Case Option = 1
        @ 09,0 Say [STATE("]+XSTATECHK1+[")]
        @ 09,7 Get XSTATECHK1 Pict "!XXXXXXXXXXXXXXXXXXX"
        Read
        XSTATEOUT1 = state(XSTATECHK1)
        @ 09,48 say XSTATEOUT1 Pict "!!"

*** Abbr. to State name
    Case Option = 2
        @ 10,0 Say [STATE("]+XSTATECHK2+[")]
        @ 10,7 Get XSTATECHK2 Pict "!!"
        Read
        XSTATEOUT2 = state(XSTATECHK2)
        @ 10,48 say XSTATEOUT2 Pict "!XXXXXXXXXXXXXXXXXXX"

*** Check valid
    Case Option = 3
        @ 11,0 Say [STATE("]+XSTATECHK3+[",.T.)]
        @ 11,7 get XSTATECHK3 Pict "!XXXXXXXXXXXXXXXXXXX"
        Read
        XSTATEOUT3 = state(XSTATECHK3,.T.)
        @ 11,48 say XSTATEOUT3

*** Age from a Date to System (Default)
    Case Option = 4
        @ 13,0 Say [AGE(ctod("]+dtoc(XAGECHK1)+["))]
        @ 13,10 Get XAGECHK1
        Read
        XAGEOUT1 = age(XAGECHK1)
        @ 13,48 Say XAGEOUT1 Pict "999"

*** Age Between 2 Dates
    Case Option = 5
        @ 14,0 Say [AGE(ctod("]+dtoc(XAGECHK2)+["),ctod("]+dtoc(XAGECHK3)+["))  N]
        @ 14,10 Get XAGECHK2
        @ 14,27 Get XAGECHK3
        Read
        XAGEOUT2 = age(XAGECHK2,XAGECHK3)
        @ 14,48 Say XAGEOUT2 Pict "999"

*** Date in Expanded form
    Case Option = 6
        @ 16,0 Say [DTOE(ctod("]+dtoc(XDATECHK1)+["))]
        @ 16,11 Get XDATECHK1
        Read
        XDATEOUT1 = dtoe(XDATECHK1)
        @ 16,48
        @ 16,48 Say XDATEOUT1

*** Date in Legal form
    Case Option = 7
        @ 17,0 Say [DTOL(ctod("]+dtoc(XDATECHK2)+["))]
        @ 17,11 Get XDATECHK2
        Read
        XDATEOUT2 = dtol(XDATECHK2)
        @ 17,48
        @ 17,48 Say XDATEOUT2

    Endcase
Enddo

*****************************************************************
*************************** EOF: CCCdemo.prg ********************
*****************************************************************

procedure HELP
parameter PN,PL,PF
save screen
@ 0,0 clear
wait "Do you want a HARD COPY of this help (y/N)? " to temp
if upper(temp) <> "Y"
    HARDCOPY = .F.
else
    HARDCOPY = .T.
endif
if hardcopy
   set print on
endif
? [*]
? [* This Demo uses the functions found in CCCFUNC.PRG]
? [*]
? [* These functions are provided to add extra features to Clippers]
? [* programming language. Please feel free to use them.]
? [*]
? [* Below is a list of functions found in CCCFUNC.PRG and their syntax]
? [*]
? [*   Report form and list help:]
? [*      Eschk()     ::= Escape check to stop report.]
? [*]
? [*   Display help:]
? [*      SayCenter() ::= Display text centered on screen or printer]
? [*      SpCenter()  ::= Insert Spaces to center text on the screen.]
? [*]
? [*   Date functions:]
? [*      DtoW()      ::= Char string WORD of day from a date]
? [*      DtoL()      ::= Char string in LEGAL form from date]
? [*      DtoE()      ::= Char string EXPANDED from a date]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*    Convertions:]
? [*      State()     ::= String with full state name from 2 letter abbr.]
? [*      Age()       ::= Numeric years old between 2 dates]
? [*]
? [*  Business Formulas:]
? [*      Fv()        ::= Future value]
? [*      Pmt()       ::= Payment on Loan]
? [*      Pv()        ::= Present value of an annuity]
? [*]
? [*****************************************************************************]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [***********************************************]
? [*  Eschk()         Escape from a report form]
? [***********************************************]
? [* Syntax ..... ESCHK()]
? [* Return ..... Used in report forms, pressing the ESC key aborts report in]
? [*              progress. If the esc key is pressed EOF() set true to stop]
? [*              report.]
? [*  Examp ..... Field Definition area in report generator. or]
? [*              List Last_name,First_name,ESCHK() or]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* SayCenter()         Say this text at Center]
? [*********************************************]
? [* Syntax ..... SAYCENTER( <expN1> , <expN2> , <expC1> )]
? [*                 expN1 = Row]
? [*                 expN2 = Width of Line]
? [*                 expC  = Character String to center.]
? [*]
? [* Performs.... @ say on expN1, Centered between 0 and expN2, the String ExpC.]
? [*]
? [*   Note ..... This Function can be use on a line by itself.]
? [*  Examp ..... SAYCENTER(10,79,"test") will display on line 10,]
? [*                          centered between 0 and 79 the word "test"]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
    eject
endif
? [*]
? [*********************************************]
? [* SpCenter()        Space this text to Center]
? [*********************************************]
? [* Syntax ..... SPCENTER( <expC> )]
? [*                  expC = Character String to add spaces in front of.]
? [*]
? [* Returns..... <expC> With spaces added to front in order to center.]
? [*  Examp ..... ? SPCENTER("test") or Wait SPCENTER("Hold Your Horses")]
? [*              also using with the Message part of the prompt command like]
? [*              @ 20,0 prompt "ABD" message SPCENTER("test") will center]
? [*              your messages.]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* DtoW()          Date to Word]
? [*********************************************]
? [* Syntax ..... DTOW( <expD> )]
? [*                 expD = Date]
? [*]
? [* Returns .... Returns a character string cooresponding to the date]
? [*                that is passed.]
? [* Examp ...... For example, on days like 1,2,21, the function will return]
? [*                "1st", "2nd", and "31st".]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* DtoL()          Date to Legal]
? [*********************************************]
? [* Syntax ..... DTOL( <expD> )]
? [*                 expD = date]
? [*]
? [* Returns .... Returns a character string of a date in a Legal format]
? [*]
? [* Examp ...... ? DtoL(ctod("10/10/86")) will return]
? [*                                       "10th day of October, 1986"]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* DtoE()          Date to Expanded]
? [*********************************************]
? [* Syntax ..... DTOE( <expD> )]
? [*                  expD = date]
? [*]
? [* Returns .... Returns a character string of a date in an Expanded format]
? [*]
? [* Examp ...... ? DtoE(ctod("10/10/86")) will return]
? [*                                          "October 10th, 1986"]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
    eject
endif
? [*]
? [*********************************************]
? [* State()          State check or conversion]
? [*********************************************]
? "* Syntax...... STATE( <expC> [,<expL>] )"
? [*                     expC = String containing State Abbr. or Full Name]
? [*                     expL = Logic to Determin if Valid check only.]
? [*]
? [* Returns..... If Option = .T. (Validate) Returns .T. if valid State or Abbr.]
? [*              If Option = .F. or no option]
? [*                     FULL STATE returns ---> ABBR.  if LEN(<expC>) > 2 or]
? [*                     ABBR STATE returns ---> FULL name if LEN(<expC>) = 2]
? [*]
? [* Notes....... This function will take a 2 place string like "CA"]
? [*              and convert it to a string like "California" or it will]
? [*              take a string containing a state like "California" and]
? [*              convert it to a string like "CA"]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [* Examp ...... ? STATE("CA")                Will return -> "California"]
? [*              ? STATE("California")        Will return -> "CA"]
? [*              ? STATE("California",.T.)    Will return -> .T.]
? [*              ? STATE("CA",.T.)            Will return -> .T.]
? [*              ? STATE("Cabifornia",.T.)    WILL Return -> .F.]
? [*              ? STATE("CC",.T.)            WILL Return -> .F.]
? [*]
? [*              @ 10,10 get Xstate picture "!!" valid State(Xstate,.t.)]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* Age()          Age Calculation]
? [*********************************************]
? "* Syntax ..... AGE( <ExpD1> [, <ExpD2>] )"
? [*                  expD1 = Date Born]
? [*                  expD2 = More Recent Date to compare]
? [*]
? [* Return ..... The age in years difference.]
? [*]
? [*   Note ..... If No second date is given then the system date is assumed.]
? [*]
? [*  Examp ..... AGE( ctod("06/20/57"),date())  If date() = 06/21/86]
? [*               then the returned age = 29]
? [*    same as . AGE( ctod("06/20/57"))  If system date Date() = 06/21/86]
? [*               then the returned age = 29]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* Fv()          Calculate Future Value]
? [*********************************************]
? [* Syntax ..... FV( <expN1>, <expN2>, <expN3> )]
? [*                 expN1 = Payments]
? [*                 expN2 = Interest]
? [*                 expN3 = Terms]
? [*]
? [* Returns..... Numeric amount = to future value]
? [*]
? [* Notes....... This function will take 3 numeric amounts]
? [*              and calculate to future value.]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
    eject
endif
? [*]
? [*********************************************]
? [* Pmt()          Calculate Payment on Loan]
? [*********************************************]
? [* Syntax ..... PMT( <expN1>, <expN2>, <expN3> )]
? [*                 expN1 = Principal]
? [*                 expN2 = Interest]
? [*                 expN3 = Terms]
? [*]
? [* Returns..... Numeric amount = to payment on loan]
? [*]
? [* Notes....... This function will take 3 numeric amounts]
? [*              and calculate payments on loan.]
? [*]
if .not. HARDCOPY
    wait "Press any key to continue (Esc = Return to Demo)"
    if lastkey() = 27
        restore screen
        return
    endif
else
    temp = inkey()
    if temp = 27
        restore screen
        return
    endif
endif
? [*]
? [*********************************************]
? [* Pv()          Calculate Present Value]
? [*********************************************]
? [* Syntax ..... PV( <expN1>, <expN2>, <expN3> )]
? [*                 expN1 = Payment]
? [*                 expN2 = Interest]
? [*                 expN3 = Terms]
? [*]
? [* Returns..... Numeric amount = to present value of annuity]
? [*]
? [* Notes....... This function will take 3 numeric amounts]
? [*              and calculate present value of annuity.]
? [*]
? [*]
? [*********************************************]
? [*    End of Help]
? [*********************************************]
? [*]
if HARDCOPY
    set print off
    eject
endif
wait "Press any key to return to demo"
restore screen
return