* Program.: CCCfunc.prg
* Author .: Gale Ford
* Edited .: January 1, 1987
* Revised.: March 18, 1987 by Harry F. Gilbert
*           Initialize Clw_posit in DTOW()
*           Correct spelling of "Delaware"  
* Notice .: Copyright 1986, Clear Creek Computing
*
* Notes...: User defined functions adding extra features to Clipper.
*           Compatible with Autumn 86.
*           Use the functions found in CCCFUNC.PRG as you see fit.
*           The functions are submitted as is without our being reponsible
*           for any damages or loss of data from their use. If you like
*           them or have any comments, please contact SOURCE ID NA2415.
*           Have fun.
*
*
*   Report form and list help:
*      Eschk()     ::= Escape check to stop report.
*
*   Display help:
*      SayCenter() ::= Display text centered on screen or printer
*      SpCenter()  ::= Insert Spaces to center text on the screen.
*
*   Date functions:
*      DtoW()      ::= Char string WORD of day from a date
*                         eg. 10/10/86 -> 10th.
*      DtoL()      ::= Char string in LEGAL form from date
*                         eg. 10/10/86 -> 10th day of October, 1986.
*      DtoE()      ::= Char string EXPANDED from a date
*                         eg. 10/10/86 -> October 10, 1986
*
*    Convertions:
*      State()     ::= String with full state name from 2 letter abbr.
*      Age()       ::= Numeric years old between 2 dates
*
*  Business Formulas:
*      Fv()        ::= Future value
*      Pmt()       ::= Payment on Loan
*      Pv()        ::= Present value of an annuity
*
*****************************************************************************


***********************************************
*  Eschk()         Escape from this report form
***********************************************
FUNCTION ESCHK
* Syntax ..... ESCHK()
* Return ..... Used in report forms, pressing the ESC key aborts report in
*              progress. If the esc key is pressed EOF() set true to stop
*              report.
*  Examp ..... Field Definition area in report generator. or
*              List Last_name,First_name,ESCHK() or
*
if pcount = 1
    parameter cl_return
else
    cl_return = .t.
endif
temp = INKEY()
if temp = 27 .or. LASTKEY() = 27
    GO bottom
    SKIP
Endif
Return cl_return


*********************************************
* SayCenter()         Say this text at Center
*********************************************
FUNCTION SAYCENTER
* Syntax ..... SAYCENTER( <expN1> , <expN2> , <expC1> )
*                 expN1 = Row
*                 expN2 = Width of Line
*                 expC  = Character String to center.
*
* Performs.... @ say on expN1, Centered between 0 and expN2, the String ExpC.
*
*   Note ..... This Function can be use on a line by itself.
*  Examp ..... SAYCENTER(10,79,"test") will display on line 10,
*                          centered between 0 and 79 the word "test"
*
PARAMETERS cl_line,cl_len,cl_string
@ cl_line,IF(len(cl_string)<cl_len,(cl_len-len(cl_string))/2,0) say cl_string
return .T.

*********************************************
* SpCenter()        Space this text to Center
********************************************
FUNCTION SPCENTER
* Syntax ..... SPCENTER( <expC> )
*                  expC = Character String to add spaces in front of.
*
* Returns..... <expC> With spaces added to front in order to center.
*  Examp ..... ? SPCENTER("test") or Wait SPCENTER("Hold Your Horses")
*              also using with the Message part of the prompt command like
*              @ 20,0 prompt "ABD" message SPCENTER("test") will center
*              your messages.
*
PARAMETERS cl_string
Return IF(len(cl_string)<80,space((80-len(cl_string))/2)+cl_string,cl_string)

*********************************************
* DtoW()          Date to Word
*********************************************
FUNCTION DtoW
* Syntax ..... DTOW( <expD> )
*                 expD = Date
*
* Returns .... Returns a character string cooresponding to the date
*                that is passed.
* Examp ...... For example, on days like 1,2,21, the function will return
*                "1st", "2nd", and "31st".
*
PARAMETERS clw_date
clw_posit = 1
if day(clw_date) > 10 .and. day(clw_date) < 20
    clw_str = "th"
else
    clw_posit = at(substr(str(day(clw_date),2),2,1),"0 1 2 3 4 5 6 7 8 9")
endif
return(str(day(clw_date),2) + SUBSTR("thstndrdthththththth",clw_posit, 2))

*********************************************
* DtoL()          Date to Legal
*********************************************
FUNCTION DtoL
* Syntax ..... DTOL( <expD> )
*                 expD = date
*
* Returns .... Returns a character string of a date in a Legal format
*
* Examp ...... ? DtoL(ctod("10/10/86")) will return
*                                       "10th day of October, 1986"
*
PARAMETERS cll_date
return(DTOW(cll_date)+" day of "+CMONTH(cll_date)+","+STR(YEAR(cll_date)))

*********************************************
* DtoE()          Date to Expanded
*********************************************
FUNCTION DtoE
* Syntax ..... DTOE( <expD> )
*                  expD = date
*
* Returns .... Returns a character string of a date in an Expanded format
*
* Examp ...... ? DtoE(ctod("10/10/86")) will return
*                                          "October 10th, 1986"
*
PARAMETERS cle_date
return(CMONTH(cle_date)+" "+DTOW(cle_date)+","+STR(YEAR(cle_date)))

*********************************************
* State()          State check or conversion
*********************************************
FUNCTION STATE
* Syntax...... STATE( <expC> [,<expL>] )
*                     expC = String containing State Abbr. or Full Name
*                     expL = Logic to Determin if Valid check only.
*
* Returns..... If Option = .T. (Validate) Returns .T. if valid State or Abbr.
*              If Option = .F. or no option
*                     FULL STATE returns ---> ABBR.  if LEN(<expC>) > 2 or
*                     ABBR STATE returns ---> FULL name if LEN(<expC>) = 2
*
* Notes....... This function will take a 2 place string like "CA"
*              and convert it to a string like "California" or it will
*              take a string containing a state like "California" and
*              convert it to a string like "CA"
*
* Examp ...... ? STATE("CA")                Will return -> "California"
*              ? STATE("California")        Will return -> "CA"
*              ? STATE("California",.T.)    Will return -> .T.
*              ? STATE("CA",.T.)            Will return -> .T.
*              ? STATE("Cabifornia",.T.)    WILL Return -> .F.
*              ? STATE("CC",.T.)            WILL Return -> .F.
*
*              @ 10,10 get Xstate picture "!!" valid State(Xstate,.t.)
*
if pcount() = 2
   parameter cl_NAME,cl_OPTION
else
   if pcount() = 1
      parameter cl_NAME
      cl_OPTION = .f.
   else
      return 0
   endif
endif
cl_NAME = upper(ltrim(trim(cl_NAME)))
if len(cl_NAME) > 2
   cl_full = .t.
else
if len(cl_NAME) = 2
   cl_full = .f.
else
   return if(cl_option,.f.,"")
endif
endif
cl_abbr = "AK  AL  AR  AZ  CA  CO  CT  DC  DE  FL  GA  HI  IA  ID  IL  IN  KS  KY  LA  "+;
          "MA  MD  ME  MI  MN  MO  MS  MT  NC  ND  NB  NH  NJ  NM  NV  NY  OH  OK  OR  "+;
          "PA  PR  RI  SC  SD  TN  TX  UT  VT  VA  VI  WA  WV  WI  WY"
CL_STATE  =  "Alaska              "+"Alabama             "+"Arkansas            "+"Arizona             "+;
             "California          "+"Colorado            "+"Connecticut         "+"District of Columbia"+;
             "Delaware            "+"Florida             "+"Georgia             "+"Hawaii              "+;
             "Iowa                "+"Idaho               "+"Illinois            "+"Indiana             "+;
             "Kansas              "+"Kentucky            "+"Louisiana           "+"Massachusetts       "+;
             "Maryland            "+"Maine               "+"Michigan            "+"Minnesota           "+;
             "Missouri            "+"Mississippi         "+"Montana             "+"North Carolina      "+;
             "North Dakota        "+"Nebraska            "+"New Hampshire       "+"New Jersey          "+;
             "New Mexico          "+"Nevada              "+"New York            "+"Ohio                "+;
             "Oklahoma            "+"Oregon              "+"Pennsylvania        "+"Puerto Rico         "+;
             "Rhode Island        "+"South Carolina      "+"South Dakota        "+"Tennessee           "+;
             "Texas               "+"Utah                "+"Vermont             "+"Virginia            "+;
             "Virgin Islands      "+"Washington          "+"West Virginia       "+"Wisconsin           "+;
             "Wyoming             "
if CL_OPTION
    if CL_FULL
        Return CL_NAME $ upper(CL_STATE)
    ELSE
        Return CL_NAME $ CL_ABBR
    Endif
Endif
if CL_FULL
    CL_POSIT = (AT(CL_NAME,Upper(CL_STATE))-1)/20
    Return IF(CL_POSIT>=0,SUBSTR(CL_ABBR,(CL_POSIT*4)+1,2),SPACE(2))
ELSE
    CL_POSIT = (AT(CL_NAME,CL_ABBR)-1)/4
    Return IF(CL_POSIT>=0,SUBSTR(CL_STATE,(CL_POSIT*20)+1,20),SPACE(20))
Endif

*********************************************
* Age()          Age Calculation
*********************************************
FUNCTION AGE
* Syntax ..... AGE( <ExpD1> [, <ExpD2>] )
*                  expD1 = Date Born
*                  expD2 = More Recent Date to compare
*
* Return ..... The age in years difference.
*
*   Note ..... If No second date is given then the system date is assumed.
*
*  Examp ..... AGE( ctod("06/20/57"),date())  If date() = 06/21/86
*               then the returned age = 29
*    same as . AGE( ctod("06/20/57"))  If system date Date() = 06/21/86
*               then the returned age = 29
*
if pcount() = 2
   parameter CL_BORN,CL_DATE
else
   if pcount() = 1
       parameter CL_BORN
       CL_DATE = date()
   else
       return 0
   endif
endif
if cl_date <= cl_born
    return 0
endif
born_year = year(cl_born)
born_month = month(cl_born)
born_day = day(cl_born)
tod_year = year(CL_DATE)
tod_month = month(CL_DATE)
tod_day = day(CL_DATE)
cl_years = tod_year-born_year-IF(tod_month < born_month,1,0)
if tod_month = born_month
    cl_years = cl_years-IF(tod_day < born_day,1,0)
Endif
Return CL_YEARS


*********************************************
* Fv()          Calculate Future Value
*********************************************
FUNCTION FV
* Syntax ..... FV( <expN1>, <expN2>, <expN3> )
*                 expN1 = Payments
*                 expN2 = Interest
*                 expN3 = Terms
*
* Returns..... Numeric amount = to future value
*
* Notes....... This function will take 3 numeric amounts
*              and calculate to future value.
*
if pcount() = 3
    PARAMETERS cl_pay,cl_intr,cl_term
else
    return 0
endif
Return cl_pay*((1+cl_intr)^cl_term-1)/cl_intr

*********************************************
* Pmt()          Calculate Payment on Loan
*********************************************
FUNCTION PMT
* Syntax ..... PMT( <expN1>, <expN2>, <expN3> )
*                 expN1 = Principal
*                 expN2 = Interest
*                 expN3 = Terms
*
* Returns..... Numeric amount = to payment on loan
*
* Notes....... This function will take 3 numeric amounts
*              and calculate payments on loan.
*
if pcount() = 3
    PARAMETERS cl_princ,cl_intr,cl_term
else
    return 0
endif
Return cl_princ*cl_intr/(1-1/(1+cl_intr)^cl_term)

*********************************************
* Pv()          Calculate Present Value
*********************************************
FUNCTION PV
* Syntax ..... PV( <expN1>, <expN2>, <expN3> )
*                 expN1 = Payment
*                 expN2 = Interest
*                 expN3 = Terms
*
* Returns..... Numeric amount = to present value of annuity
*
* Notes....... This function will take 3 numeric amounts
*              and calculate present value of annuity.
*
if pcount() = 3
    PARAMETERS cl_pay,cl_intr,cl_term
else
    return 0
endif
Return cl_pay*(1-1/(1+cl_intr)^cl_term)/cl_intr

*************************
*
*
*************************** EOF: CCCfunc.prg ********************

