* testint.prg
* tests inter.prg, inter.bin, bit.bin
* Andrew Schulman 7/5/87, revised 7/15/87, revised 7/17/87
* revised yet again 7/20/87 (added BASE operator to BIT.BIN)
* note that PEEK.BIN bugs were fixed on 7/21/87
* IMPORTANT NOTE!  Matthew Jacob Schulman was born 8 July 1987 at 4:11pm.

if .not. file("inter.prg") .or. .not. file("inter.bin")
	return
endif

set proc to inter.prg
set talk off
load inter
pc=0

if file("peek.bin")
	load peek
	* fixed bugs in peek.bin
	* AT or 386==0xFC, PCjr==0xFD, XT==0xFE, PC==0xFF
	? "MACHINE TYPE"
	pc = "f000 fffe 1"
	call peek with pc
	pc=asc(pc)
	msg = "This machine is a " + iif(pc=255, "PC", iif(pc=254, "XT", ;
			iif(pc=253, "PCjr(?!)", iif(pc=252, "AT or 386", "unknown"))))
	? msg
	* Note that this is available in FoxBase+ 2.0 with sys(17)
	wait
endif

? "CONVENTIONAL MEMORY"
ax = 0
do inter with 18,ax,0,0,0
? ax,"Kbytes conventional memory"
* note that FoxBase+ 2.0 has sys(12) which tells amount of available memory
wait

wait "Do you have LIM expanded memory? (Y/N) " to emm
if (emm $ "yYtT")
    ?
    ? "EXPANDED MEMORY MANAGER"

    ax = 64 * 256
    al = 0          && for return value
    do inter with 103,ax,0,0,0
    ? al,"EMM status"

    ax = 66 * 256
    store 0 to bx,cx,dx
    do inter with 103,ax,bx,cx,dx
    ? bx, "EMM pages free"
    ? dx, "EMM total pages"
    ? bx*16, "EMM Kbytes free"
    ? dx*16, "total EMM Kbytes"

    ax = 70 * 256
    al = 0          && for return value
    do inter with 103,ax,0,0,0
    ? al,"EMM version number"
    wait
	* note that this has been tested with FoxBase+ 2.0, which uses EMM
endif

?
? "CLOCK -- raw number of ticks"
store 0 to cx,dx,al
do inter with 26,ax,0,cx,dx
? iif(al=0, "no clock rollover", "clock did rollover")
? dx+(cx*32768),"ticks"
wait

?
? "PRINTER STATUS"
ax=2*256
store 0 to ah,dx
do inter with 23,ax,0,0,dx
? "using LPT" + chr(dx+1+48)
? ah,"status byte"
if file("bit.bin")
	**** BIT TESTS NOT WORKING IN FOXBASE+ 2.0
    load bit
    ah = trim(str(ah))
    bin = ah + " base 2" + space(5)      && BIT.BIN base operator
    call bit with bin
    * length of binary is variable: no leading zeros: we have to add them:
	* this is a bit tricky in FoxBase+ 2.0 because of memory manager:
	* unfortunately this part doesn't work yet in FoxBase+ 2.0
	* on the other hand, it's not so necessary in FoxBase+ 2.0!
    bin = trim(bin)
    len = len(bin)
    binary = substr("00000000",1,8-len) + bin
    ? binary,"binary representation of printer status"
    * now just pick out individual bits from printer status byte. previous
    * versions of testint.prg used BIT.BIN's AND (&) operator.  But the
    * BASE operator allowed us to convert to base 2 and so makes the repeated
    * calls to BIT.BIN unnecessary.  The alternate form is shown for the
    * timeout bit, however:
    * timeout = ah + " & 1"     && BIT.BIN AND operator
    * call bit with timeout
    timeout = substr(binary,8,1)
    ? timeout,"timeout"
    * bits 1 (ah & 2) and 2 (ah & 4) are unused
    ioerror = substr(binary,5,1)
    ? ioerror,"ioerror"
    selected = substr(binary,4,1)
    ? selected,"selected"
    outofpaper = substr(binary,3,1)
    ? outofpaper,"outofpaper"
    ack = substr(binary,2,1)
    ? ack,"acknowledge"
    notbusy = substr(binary,1,1)
    ? notbusy,"notbusy"
endif
wait

?
? "EQUIPMENT FLAG"
ax = 0
do inter with 17,ax,0,0,0
? ax,"equipment flag"
wait

if file("bit.bin")
    ax = trim(str(ax))
    load bit
    equip = ax + " base 2" + space(16)
    call bit with equip
    * again, we have to add leading zeros:
    equip = trim(equip)
    len = len(equip)
    equip = substr("0000000000000000",1,16-len) + equip
    ? equip,"binary representation of equipment flag"
    diskette = iif(substr(equip,16,1)="1",.T.,.F.)
	if (pc=252)			&& we ran peek.bin and know this is an AT
		at80287 = substr(equip,15,1)
		msg = "This AT has " + iif(at80287="1", "an", "no") + ;
				" 80287 math coprocessor installed"
		? msg
	endif
    * compare the following to previous versions of testint.prg:  much
    * simpler:
    vid = substr(equip,11,2)
    columns = iif(vid="00", 0, iif(vid="01", 40, iif(vid="10", 80, 80)))
    ? columns,"columns initial video mode"
    if (diskette)
        disk = substr(equip,9,2)
        numdisks = iif(disk="00", 1, iif(disk="01", 2, iif(disk="10", 3, 4)))
        ? numdisks,"number of diskette drives installed"
    else
        ? "no diskette installed"
    endif
    dma = substr(equip,8,1)
    ? iif(dma="1", "What is this, a PCjr or Tandy 1000?", "dma present")
    rs232 = substr(equip,5,3)
    rs = iif(rs232="001", 1, iif(rs232="010", 2, iif(rs232="011", 3, ;
         iif(rs232="100", 4, iif(rs232="101", 5, iif(rs232="110", 6, 7))))))
    ? rs, "number of rs232 serial ports installed"
    game = substr(equip,4,1)
    ? game,"game adapter installed"
    pr = substr(equip,1,2)
    printers = iif(pr="00", 0, iif(pr="01", 1, iif(pr="10", 2, 3)))
    ? printers, "printers installed"
endif
wait

?
? "KEYBOARD TEST"
? "doesn't work properly for non-alphanumeric keys!"
? "Press (((almost))) any key"
al = 0
do inter with 33,8*256,0,0,0
? "You pressed key#",al
wait

?
? "SCROLLING TEST"
? "This should blank out screen from (5,5) to (15,15)"
do inter with 16,6*256+10,5*256,5*256+5,15*256+15
wait

?
? "GRAPHICS TEST"
? "This is a paltry graphics test"
? "It probably won't work on a Hercules card..."
wait "Want to do the graphics test? (Y/N) " to graph
if (graph $ "yYtT")
    * set mode to graphics
    set status off
    do inter with 16,6,0,0,0
    * draw some dots
    store 0 to row, column
    do while row < 200
        do inter with 16,12*256+1,0,column,row
        column = column + 15
        row = row + 5
    enddo
    * wait for key
    do inter with 33,8*256,0,0,0
    * restore text mode
    do inter with 16,2,0,0,0
endif

? "That's the end of the test -- I'm sure you could do better!"
set proc to
