#include "cbase.h"


class test : public cbase
{
public:
	test ();
};


test::test ()
{
   static FIELD4INFO finfo[] = {
      { "SSN", 'C', 10, 0 },
      { "LNAME", 'C', 10, 0 },
      { "FNAME", 'C', 3, 0 },
      { "SEX", 'C', 5, 0 },
      { "BDATE", 'D',  8, 0 },
      { "INCOME", 'N', 8, 2 },
      { 0,0,0,0 }
   };

   static TAG4INFO tinfo[] = {
      { "NAME", "UPPER(LNAME+FNAME)", 0, 0, 0 },
      { "RICH", "INCOME", "INCOME>30000", 0, 0 },
      { 0,0,0,0,0 }
   };

	// attempt to open on failure create the database
	cbase::open ("TEST.DBF", finfo, tinfo);
	cbase::tag ("NAME");
}


#include <iostream.h>
#include <iomanip.h>

template<class T>
class OManip // output manip class
{
  	typedef ostream& (*OManipFunc) (ostream&, T);
  	OManipFunc manipFunc;    // manip function
  	T          arg;     		// arg of type T
public:
  	OManip (OManipFunc omf, T omf_arg) : manipFunc (omf), arg (omf_arg) { }

	friend ostream& operator << (ostream& os, const OManip<T>& manipClass)
  		{ return (*manipClass.manipFunc) (os, manipClass.arg); }
};

ostream& showMoneyCode (ostream& os, double val)
{
	return os << "$"
	          << setiosflags  (ios::showpoint)
	          << setiosflags  (ios::fixed)
				 << setprecision (2)
				 << val;
}

OManip<double> showMoney (double val)
{
	return OManip<double>(showMoneyCode, val);
}


void main ()
{
	// Set the defaults in cbase.cpp the way you want and a CodeBaseRoot
	// will be automatically created...
	test test;
	for ( test.top(); !test.eof(); test++ )
	{
		if (test.field("LNAME").empty ())
		{
			test.field ("LNAME") = "Doe";
			test.field ("FNAME") = "Jane";
			test.field ("BDATE") = "19930930";
			test.field ("INCOME") = 100;
		}
		cout << "Recno: " << test.recno() << "\t" << test.field ("LNAME") <<
			                  test.field ("FNAME") << endl;
		cout << "\t"      << test.field ("BDATE") << endl;
		cout << "\t"      << showMoney (test.field ("INCOME")) << endl;
	}
}


