* CAPNEG2.PRG  

* EXAMPLES TO DEMONSTRATE USE OF CAPTAIN EVENT AUTHORIZATION FUNCTIONS
*                                        -----
*
* compile and link this program
*
*     clipper capneg2
*     blinker fi capneg2 li capn5
*

* This system name must be the same as the Product ID for the product
* (in the products file in CAPN)

* this program will only work if a product with an ID of 'capncode'
* has already been authorized (see capneg1.prg).

msys = 'capncode'
clear
mevent = 'COUNT1'                                && maximum 8 characters

do while .t.
   y = capncntr(msys,mevent)               && read contents of counter
   if y = -1
      @ 23,10 say 'System '+msys+' has not been authorized!'
      wait
      cancel
   elseif y = -2
      @ 23,10 say 'Network Error!'
      wait
      cancel
   elseif y = -3
      @ 23,10 say 'Event Counter '+mevent+' has been corrupted!'
      wait
      cancel                                               
   endif

   @ 6,10 say 'Available events = ' + str(y)
   mans = ' '
   @ 8,10 say 'Use one up?        ' get mans picture '@!'
   read
   mans = upper(mans)

   if mans = 'E' .or. lastkey() = 27
      exit
   endif

   if !(mans $ 'YNE')
      loop
   endif             

   if mans = 'Y'
      y = capncntw(msys,mevent,y-1)      && write back the counter less 1
      if y = -1
         @ 23,10 say 'System '+msys+' has not been authorized!'
         wait
         cancel
      elseif y = -2
         @ 23,10 say 'Network Error!'
         wait
         cancel
      elseif y = -3
         @ 23,10 say 'Error writing to Event Counter '+mevent+'!'
         wait
         cancel                                               
      endif
   endif                                         

   mans = ' '
   @ 10,10 say 'Ask for more?      ' get mans picture '@!' valid(mans $ 'YN')
   read
   if mans = 'Y'         
      cseed = capnget(mevent)            && get seed number
      cauth = 0

      @ 12,10 say 'Event to be Authorized is  : '
      @ 12,39 say mevent
      @ 13,10 say 'Event serial number is     : '
      @ 13,39 say val(cseed) picture '999 999 999 999'
      @ 14,10 say 'Enter Authorization Number : ' 
      @ 14,39 get cauth picture '999 999 999 999'
      @ 15,10 say '(Phone software dealer)'
      read
      if lastkey() = 27
         cancel
      endif
      cauth = str(cauth,12)

*   determine how many additional events have been authorized
*
      newevents = capncntm(mevent, cseed, cauth)

      y = capncntr(msys,mevent)                && read counter again
      if y = -1
         @ 23,10 say 'System '+msys+' has not been authorized!'
         wait
         cancel
      elseif y = -2
         @ 23,10 say 'Network Error!'
         wait
         cancel
      elseif y = -3
         @ 23,10 say 'Event Counter '+mevent+' has been corrupted!'
         wait
         cancel                                               
      endif
      y = capncntw(msys,mevent,y+newevents)     && update the counter
      if y = -1
         @ 23,10 say 'System '+msys+' has not been authorized!'
         wait
         cancel
      elseif y = -2
         @ 23,10 say 'Network Error!'
         wait
         cancel
      elseif y = -3
         @ 23,10 say 'Error writing to Event Counter '+mevent+'!'
         wait
         cancel                                               
      endif
      @ 12,10 clear to 15,75
   endif       
enddo







