*============================================================================*
* This Calendar UDF for CLIPPER A86 displays a three month calendar on
* which the user can point and shoot.
*
* A specific date is passed to the UDF and a three month calendar is set up
* around the date.  The user then moves the cursor to the day they want and 
* presses Return or Escape to complete the UDF.
*
* The UDF then passes the choosen date back to the original passing routine.
*
* I wrote this UDF over 1 year ago and the re-display of the calendar is 
* somewhat kludgey (especially on 4.77mhz machines).  I'll probably rewrite
* it in C as soon as I get the time.  If someone beats me to it, or can
* improve on my logic, please send me your version.
*
* To reach me, please leave a message on DARWIN BBS or call me via voice
* line at 800 338-6892.
*
* Enjoy.            Thomas Weil
*                   155 East Shaw Avenue #100
*                   Fresno, California  93711
*
*============================================================================*
* Example:
*
* PROCEDURE next_call
* SAVE SCREEN TO scrn_current
* call_date = calendar(date())              && Parameter passed must be date
*                                           && variable.
* RESTORE SCREEN FROM scrn_current
* @ 10,00 SAY "The next call will be on: "+DtoC(call_date)
* RETURN
*
*
*----------------------------------------------------------------------------*
FUNCTION calendar
*----------------------------------------------------------------------------*

PARAMETER c_date
CALL _setctyp WITH word(0)                   && turn cursor off

c_olddate = c_date 
STORE 0 TO c_week_line, c_old_row, c_old_col, show_month

SET COLOR TO B/N
@ 0,24 TO 24,55 DOUBLE

SET COLOR TO W/N

DO cal_display

stay_in_loop = .T.
DO WHILE stay_in_loop

   move_cursor = 0
   c_month = MONTH(c_date)
   c_year = YEAR(c_date)

*============================================================================*
*    days_in_month string tells 
*============================================================================*

   IF (YEAR(c_date)-1980)/4 = INT((YEAR(c_date)-1980)/4)  
      days_in_month = "312931303130313130313031"
   ELSE
      days_in_month = "312831303130313130313031"
   ENDIF

*============================================================================*
*   There are 8 movements:
*
*      UP ARROW     CHR(5)  - Previous Week
*      DOWN ARROW   CHR(24) - Next Week
*      LEFT ARROW   CHR(19  - Previous Day
*      RIGHT ARROW  CHR(4)  - Next Day
*      PAGE UP      CHR(18) - Previous Three Months
*       PAGE DOWN    CHR(3)  - Next Three Months
*       HOME         CHR(6)  - Previous Year to Date
*       END          CHR(1)  - Next Year to Date
*
*       ESC or RETURN        - Quits Calendar, Returns Date
*
*============================================================================*

   DO WHILE move_cursor = 0
      move_cursor = INKEY()
   ENDDO

   IF move_cursor = 27 .OR. move_cursor = 13    && Blow out of Calendar
      stay_in_loop = .F.
      LOOP
   ENDIF

   DO CASE
   CASE move_cursor = 5            && -1 WEEK
      c_date = c_date - 7
      IF MONTH(c_date) <> c_month
         IF MONTH(c_date) < show_month .OR. YEAR(c_date) < c_year
            DO cal_display
         ELSE
            IF DOW(STOD(STR(YEAR(c_date),4)+STR(MONTH(c_date),2)+SUBSTR(days_in_month,(MONTH(c_date)*2)-1,2))) = 7
               c_week_line = c_week_line - 3
            ELSE    
               c_week_line = c_week_line - 4
            ENDIF
         ENDIF  
      ELSE
         c_week_line = c_week_line - 1
      ENDIF

   CASE move_cursor = 24           && +1 WEEK
      c_date = c_date + 7
      IF MONTH(c_date) <> c_month 
         IF MONTH(c_date) > show_month + 2 .OR. YEAR(c_date) > c_year
            DO cal_display
         ELSE
            IF DOW(STOD(STR(YEAR(c_date),4)+STR(MONTH(c_date),2)+"01")) = 1
               c_week_line = c_week_line + 3
            ELSE    
               c_week_line = c_week_line + 4
            ENDIF
         ENDIF  
      ELSE
         c_week_line = c_week_line + 1
      ENDIF

   CASE move_cursor = 19           && -1 DAY
      c_date = c_date - 1
      IF MONTH(c_date) <> c_month
         IF MONTH(c_date) < show_month .OR. YEAR(c_date) < c_year
            DO cal_display
         ELSE
            c_week_line = c_week_line - 3
         ENDIF  
      ELSE
         IF DOW(c_date) = 7
            c_week_line = c_week_line - 1
         ENDIF
      ENDIF

   CASE move_cursor = 4            && +1 DAY
      c_date = c_date + 1
      IF MONTH(c_date) <> c_month 
         IF MONTH(c_date) > show_month + 2 .OR. YEAR(c_date) > c_year
            DO cal_display
         ELSE
            c_week_line = c_week_line + 3
         ENDIF  
      ELSE
         IF DOW(c_date) = 1
            c_week_line = c_week_line + 1
         ENDIF
      ENDIF

   CASE move_cursor = 6            && +1 YEAR
      c_date = c_date + 365
      DO cal_display

   CASE move_cursor = 1            && -1 YEAR
      c_date = c_date - 365
      DO cal_display

   CASE move_cursor = 18           && -3 MONTH
      c_date = c_date - 90
      IF YEAR(c_date) < c_year
         c_year = YEAR(c_date)
      ENDIF
      DO cal_display

   CASE move_cursor = 3            && +3 MONTH
      c_date = c_date + 90
      IF YEAR(c_date) > c_year
         c_year = YEAR(c_date)
      ENDIF
      DO cal_display
   ENDCASE

   SET COLOR TO W/N

   @ c_old_row,c_old_col SAY " "+STR(DAY(c_olddate),2)+" "

   SET COLOR TO W/R
   @ c_week_line,25+(DOW(c_date)*4)-3 SAY " "+STR(DAY(c_date),2)+" "
   c_old_row = c_week_line
   c_old_col = 25+(DOW(c_date)*4)-3
   c_olddate = c_date
   SET COLOR TO W/N

ENDDO
CALL _setctyp WITH word(1)                   && turn cursor on
RETURN c_date

*----------------------------------------------------------------------------*
PROCEDURE cal_display
*----------------------------------------------------------------------------*
show_month = MONTH(c_date)

@ 01,25 clear to 23,54

*============================================================================*
* c_day_count is set to first day in month.
*============================================================================*
c_day_count = STOD(STR(YEAR(c_date),4)+STR(MONTH(c_date),2)+"01")
c_month = MONTH(c_date)
STORE 0 TO c_week_line, c_curr_day

*============================================================================*
* Display Calendar for 3 Months
*============================================================================*
FOR c_xx = 1 TO 3
   c_ms = UPPER(CMONTH(c_day_count))+" "+STR(YEAR(c_day_count),4)
   @ c_week_line+1,27+((27-LEN(c_ms))/2) SAY c_ms
   @ c_week_line+2,27 SAY "SUN MON TUE WED THU FRI SAT"
   c_week_line = c_week_line + 3

*============================================================================*
*   Display All Days in Month
*============================================================================*
   DO WHILE MONTH(c_day_count) = c_month

                                     && Produce Week Line

      @ c_week_line,25+(DOW(c_day_count)*4)-3 SAY " "+;
                        STR(DAY(c_day_count),2)+" "

      IF c_day_count = c_date
         c_curr_day = c_week_line
      ENDIF

      c_day_count = (c_day_count + 1)

      IF DOW(c_day_count) = 1 .AND. MONTH(c_day_count) = c_month
         c_week_line = c_week_line + 1
      ENDIF

   ENDDO
   c_month = MONTH(c_day_count)
NEXT  

c_week_line = c_curr_day

SET COLOR TO W/R

@ c_week_line,25+(DOW(c_date)*4)-3 SAY " "+STR(DAY(c_date),2)+" "

c_old_row = c_week_line
c_old_col = 25+(DOW(c_date)*4)-3
c_olddate = c_date
SET COLOR TO W/N
RETURN

* EOF: CALENDAR UDF
