***************************************
* CAL.prg    written by Al Degutis    *
***************************************
*
* This Clipper program is a "pop-up" calander that can be called from a 
* program or executed from the Dos prompt. IT NEEDS Tom Rettig's public 
* domain libraries (TR.LIB & TR87.LIB) available for several functions.
*
* It was originally created to allow a user to "hot-key" a calander in
* a program where a date field is entered or used.
*
* To execute the program from the Dos prompt:
*
*    CAL    or    CAL 01/01/92     or     CAL 01/01/2000
*
* To execute the program from another program
*
*     DO CAL           or       DO CAL WITH "01/01/92"
*
* Questions or comments to me on CIS -  72700,2430


parameters in_date 

do case
	case pcount()<1
		use_date=date()
		_height=5
		_width=5
	case pcount()=1
		use_date=ctod(in_date)
		_height=5
		_width=5
endcase

set cursor off
set color to w+/i

line0_chr=chr(218)
line1_chr=chr(195)
line2_chr=chr(179)
line3_chr=chr(192)
****** Top bar
for x= 1 to 6
	line0_chr=line0_chr+chr(196)+chr(196)+chr(194)
next
line0_chr=line0_chr+chr(196)+chr(196)+chr(191)
****** horizontal lines with vertical cross
for x= 1 to 6
	line1_chr=line1_chr+chr(196)+chr(196)+chr(197)
next
line1_chr=line1_chr+chr(196)+chr(196)+chr(180)
****** vertical lines
for x= 1 to 7
	line2_chr=line2_chr+'  '+chr(179)
next
****** bottom bar
for x=1 to 6
	line3_chr=line3_chr+chr(196)+chr(196)+chr(193)
next
line3_chr=line3_chr+chr(196)+chr(196)+chr(217)
cur_day=day(date())
exit_cal=.f.


do while exit_cal=.f.

	set color to w+/i
	***** draw calendar
	@ _height,_width-1 clear to _height+16,_width+24
	@ _height,_width to _height+16,_width+23 double    && border
	@ _height+3,_width+1 say line0_chr
	for x= _height+4 to _height+13 step 2
		@ x,_width+1 say line2_chr
		@ x+1,_width+1 say line1_chr
	next
	@ _height+14,_width+1 say line2_chr
	@ _height+15,_width+1 say line3_chr

	****** days of the week
	@ _height+2,_width+2 say "Su Mo Tu We Th Fr Sa"

	****** Month & Year Heading
	month=cmonth(use_date)
	year_num=year(use_date)
	cal_title=month+' '+str(year_num,4)
	@ _height+1,_width+2 say center(@cal_title,20)

	month_num=month(use_date)
	year_1=str(year_num,4)
	day_1=str(month_num,2)+'/01/'+year_1
	month_strt=ctod(day_1)
	start_day=dow(month_strt)
	day_num=0

	declare x[42], y[42]
	******** define X coordinates
	xx=0
	for qaz=_height+4 to _height+14 step 2
		for q=1 to 7
			xx=xx+1
			x[xx]=qaz
		next
	next
	******** define Y coordinates
	yy=0
	for q=1 to 6
		for qaz=_width+2 to _width+20 step 3
			yy=yy+1
			y[yy]=qaz
		next
	next

	for qaz=start_day to 42
		day_num=day_num+1
		day_str=str(day_num,2)
		xx=x[qaz]
		yy=y[qaz]
		if day_num=day(use_date) .and. month(use_date)=month(date())
			set color to w+*/n
			@ xx,yy say day_str
			set color to w+/i
		else
			@ xx,yy say day_str
		endif
		if day_num=lastday(month(use_date),year(use_date))
			exit
		endif
	next
	set color to w+/n
	set cursor off
	@ _height+17,0 say space(78)
	@ _height+18,0 say space(78)
	@ _height+19,0 say space(78)
	@ _height+17,iif(_width>3,_width-4,_width) say "     ESC=Exit : HOME=Current "
	@ _height+18,iif(_width>3,_width-4,_width) say "PG-UP=Prev Month : PG-DWN=Next Month"
	@ _height+19,iif(_width>3,_width-4,_width) say "CTRL+PG-UP=Prev Yr : CTRL+PG-DWN=Next Yr"
	set color to w+/i
	inkey(0)
	do case
		case lastkey()=1            && Home key
			use_date=date()
		CASE LASTKEY()=27           && ESC
			exit_cal=.t.
*			clearlkey()
		case lastkey()=18           && page-up key  - back one month
			month_num=month_num-1
			if month_num<1
				month_num=12
				year_num=year_num-1
			endif
			YEAR_four=STR(YEAR_NUM)
			temp_date=str(month_num,2)+'/'+str(cur_day,2)+'/'+year_four
			use_date=ctod(temp_date)
		case lastkey()=31           && ctrl+page-up - back one year
			year_num=year_num-1
			year_four=str(year_num)
			temp_date=str(month_num,2)+'/'+str(cur_day,2)+'/'+year_four
			use_date=ctod(temp_date)
		case lastkey()=3            && page-down key - ahead one month
			month_num=month_num+1			
			if month_num>12
				month_num=1
				year_num=year_num+1
			endif
			year_four=str(year_num)
			temp_date=str(month_num,2)+'/'+str(cur_day,2)+'/'+year_four
			use_date=ctod(temp_date)
		case lastkey()=30            && ctrl+page-down  - ahead one year
			year_num=year_num+1
			year_four=str(year_num)
			temp_date=str(month_num,2)+'/'+str(cur_day,2)+'/'+year_four
			use_date=ctod(temp_date)
	endcase
*	clearlkey()
	set color to w/n
	@ _height+17,0 say space(78)
	@ _height+18,0 say space(78)
	@ _height+19,0 say space(78)
	set cursor on
enddo
