*:*********************************************************************
*:
*:        Program: CALENDAR.PRG
*:
*:         System: Visual calendar function
*:         Author: John Wright [70534,2330]
*:      Copyright (c) 1993
*:
*:*********************************************************************
* 01/10/93 - Created this Clipper 5.x calendar function
* 01/11/92 - Fixed processing of PgDn/PgUp keys to jump years
* 07/19/93 - Took out proprietary functions for upload to CIS.

#include "INKEY.CH"
#include "SET.CH"

FUNCTION Calendar( dDate, nRow, nCol, cColor )
LOCAL cSaveScrn, cOldColor, cDate, dSaveDate, dPrevDate, cDateFmt
LOCAL nDayRow, nDayCol, nBoxDay, nBoxNum, nMonth, dStart, cHelpScrn
LOCAL nCursRow, nCursCol, nCursType, Getlist := {}, nKeypress := 0

* Check parameters
dDate    := IF( VALTYPE(dDate) <> "D", DATE(), dDate )
nRow     := IF( VALTYPE(nRow) <> "N", ROW() - 5, nRow )
nCol     := IF( VALTYPE(nCol) <> "N", COL() + 10, nCol )
cColor   := IF( VALTYPE(cColor) <> "C", SETCOLOR(), cColor )

* Make sure the calendar fits on the screen
nRow := IF( nRow < 0, 0, nRow )
nRow := IF( nRow + 10 > MAXROW(), MAXROW() - 11, nRow )
nCol := IF( nCol < 0, 0, nCol )
nCol := IF( nCol + 23 > MAXCOL(), MAXCOL() - 24, nCol )

* Save cursor information
nCursRow  := ROW()
nCursCol  := COL()
nCursType := SETCURSOR()

* Change screen color if specified
cOldColor := SETCOLOR( cColor )

* Save screen and draw a box
cSaveScrn := SAVESCREEN( nRow, nCol, nRow + 10, nCol + 23 )
DISPBOX( nRow, nCol, nRow + 10, nCol + 23 , "ͻȺ " )

SET CURSOR OFF

* Set date to handle century too
cDateFmt  := SET( _SET_DATEFORMAT, "mm/dd/yyyy" )
dSaveDate := dDate
dPrevDate := dDate + 1

@ nRow+2, nCol+2 SAY "Su Mo Tu We Th Fr Sa"
@ nRow+3, nCol SAY "Ķ"

DO WHILE nKeypress <> K_ESC

   IF dDate <> dPrevDate
      * display the month and year
      @ nRow+1, nCol+2 SAY SPREAD( CMONTH(dDate), STR(YEAR(dDate),4,0), 20 )

      * get the first date in the month
      nMonth := MONTH( dDate )
      dStart := BMONTH( dDate )

      nDayRow := nRow + 4
      nDayCol := nCol + 2

      nBoxDay := nBoxNum := 0

      DO WHILE nBoxNum < 37
        nBoxNum ++
        nBoxDay ++
        IF DOW(dStart) == nBoxDay .AND. MONTH(dStart) == nMonth
           IF dStart == dDate
              @ nDayRow, nDayCol SAY STR(DAY(dStart),2,0) COLOR SELCOLOR()
           ELSE
              @ nDayRow, nDayCol SAY STR(DAY(dStart),2,0)
           ENDIF
           dStart ++
         ELSE
           @ nDayRow, nDayCol SAY "  "
         ENDIF
         IF nBoxDay == 7
            nBoxDay := 0
            nDayRow += 1
            nDayCol := nCol + 2
         ELSE
            nDayCol += 3
         ENDIF
      ENDDO
      dPrevDate := dDate
   ENDIF

   nKeyPress := INKEY(0)

   DO CASE
   CASE nKeypress = K_ENTER .OR. nKeypress = K_CTRL_RET
      EXIT

   CASE nKeypress = K_ESC
      dDate := dSaveDate
      EXIT

   CASE nKeypress = K_DOWN
      dDate += 7

   CASE nKeypress = K_UP
      dDate -= 7

   CASE nKeypress = K_LEFT
      dDate -= 1

   CASE nKeypress = K_RIGHT
      dDate += 1

   CASE nKeypress = K_HOME
      dDate := BMONTH( dDate )

   CASE nKeypress = K_END
      dDate := EMONTH( dDate )

   CASE nKeypress = K_PGUP
      cDate := DTOC( dDate )
      IF SUBSTR( cDate, 1, 2 ) == "01"
        cDate := "12"+SUBSTR( cDate, 3, 4 )+STR(VAL(RIGHT(cDate,4))-1,4,0)
      ELSE
        cDate := STR(VAL(SUBSTR(cDate,1,2))-1,2,0) + SUBSTR( cDate, 3, 10 )
      ENDIF
      dDate := CTOD( cDate )
      IF EMPTY( dDate )       // hit an invalid date...
         TONE(100,1)
         dDate := BMONTH( dPrevDate ) - 1
      ENDIF

   CASE nKeypress = K_PGDN
      cDate := DTOC( dDate )
      IF SUBSTR( cDate, 1, 2 ) == "12"
        cDate := "01"+SUBSTR( cDate, 3, 4 )+STR(VAL(RIGHT(cDate,4))+1,4,0)
      ELSE
        cDate := STR(VAL(SUBSTR(cDate,1,2))+1,2,0) + SUBSTR( cDate, 3, 10 )
      ENDIF
      dDate := CTOD( cDate )
      IF EMPTY( dDate )       // hit an invalid date...
         TONE(100,1)
         dDate := EMONTH( EMONTH(dPrevDate) + 1 )
      ENDIF

   CASE CHR(nKeypress) = "-" .OR. nKeypress = K_CTRL_PGUP
      cDate := DTOC( dDate )
      IF SUBSTR( cDate, 1, 6 ) == "02/29/"
        cDate := "02/28/"+STR(VAL(RIGHT(cDate,4))-1,4,0)
      ELSE
        cDate := SUBSTR(cDate,1,6)+STR(VAL(RIGHT(cDate,4))-1,4,0)
      ENDIF
      dDate := CTOD( cDate )

   CASE CHR(nKeypress) = "+" .OR. nKeypress = K_CTRL_PGDN
      cDate := DTOC( dDate )
      IF SUBSTR(cDate,1,6) == "02/29/"
        cDate := "02/28/"+STR(VAL(RIGHT(cDate,4))+1,4,0)
      ELSE
        cDate := SUBSTR(cDate,1,6)+STR(VAL(RIGHT(cDate,4))+1,4,0)
      ENDIF
      dDate := CTOD( cDate )

   CASE CHR(nKeypress) = "?"
      @ nRow+9, nCol+12 GET dDate
      SET CURSOR ON
      READ
      SET CURSOR OFF
      IF LASTKEY() == K_ESC .OR. Empty(dDate)
         dDate := dPrevDate
      ENDIF
      @ nRow+9, nCol+12 SAY SPACE(10)

   CASE nKeypress = K_CTRL_HOME
      cDate := DTOC( dDate )
      cDate := "01/01/"+RIGHT(cDate,4)
      dDate := CTOD( cDate )

   CASE nKeypress = K_CTRL_END
      cDate := DTOC( dDate )
      cDate := "12/31/"+RIGHT(cDate,4)
      dDate := CTOD( cDate )

   CASE nKeypress = K_F1
      SETCOLOR( "n/w" )
      cHelpScrn := SAVESCREEN( nRow, nCol, nRow + 10, nCol + 23 )
      DISPBOX( nRow, nCol, nRow + 10, nCol + 23, "         " )
      @ nRow+1, nCol+2 SAY "[]  = accept date"
      @ nRow+2, nCol+2 SAY "[Esc]  = exit"
      @ nRow+3, nCol+2 SAY "[Home] = first day"
      @ nRow+4, nCol+2 SAY "[End]  = last day"
      @ nRow+5, nCol+2 SAY "[PgDn] = next month"
      @ nRow+6, nCol+2 SAY "[PgUp] = prior month"
      @ nRow+7, nCol+2 SAY "[+]    = next year"
      @ nRow+8, nCol+2 SAY "[-]    = prior year"
      @ nRow+9, nCol+2 SAY "[?]    = enter date"
      INKEY(0)
      SETCOLOR( cColor )
      RESTSCREEN( nRow, nCol, nRow + 10, nCol + 23, cHelpScrn )

   ENDCASE

ENDDO

* clean up the screen and put cursor back where it was...
RESTSCREEN( nRow, nCol, nRow + 10, nCol + 23 , cSaveScrn )
SETCOLOR( cOldColor )
SETPOS( nCursRow, nCursCol )   // put the cursor back where it was...
SETCURSOR( nCursType )         // reset the cursor to previous state...

* Set the date format back
SET( _SET_DATEFORMAT, cDateFmt )

* check for [Control + Enter]
IF nKeypress == K_CTRL_RET
   KEYBOARD DTOC( dDate )
ENDIF

RETURN dDate

//////////////////////////////////////////////////////////////////////////////
///                        SUPPORTING FUNCTIONS                            ///
//////////////////////////////////////////////////////////////////////////////

FUNCTION Bmonth( dTheDate )
*****************************************************************************
*  Returns:  Beginning date of the month.  If no date is passed it will
*            use the current system date.
* 05/26/92  Use example from PC Magazine to reduce string manipilation
*****************************************************************************
IF VALTYPE( dTheDate ) <> "D"
   dTheDate = DATE()
ENDIF

RETURN dTheDate - DAY( dTheDate ) + 1


FUNCTION Emonth( dTheDate )
*****************************************************************************
*  Returns:  Ending date of the month.  If no date is passed it will
*            use the current system date.
* 05/26/92  Use example from PC Magazine to reduce string manipilation
*****************************************************************************
LOCAL dBump

IF VALTYPE( dTheDate ) <> "D"
   dTheDate := DATE()
ENDIF

dBump := dTheDate + 35 - DAY( dTheDate )      // somewhere in next month

RETURN dBump - DAY( dBump )


FUNCTION SelColor( cColor )
*****************************************************************************
* Description:  This will return the "selected" color from a color string.
*
*       Usage:  Designed for use in menu functions that need to highlight
*               the current menu bar item.
*
*     Example:  Selcolor("w/b,w/r,b")  =>  "w/r"
*
* 03/02/92  Created by John Wright
* 03/16/92  Fixed a small bug - last AT() looked at cColor not cTemp...
*****************************************************************************
LOCAL cTemp
IF VALTYPE( cColor ) <> "C"
   cColor := SETCOLOR()
ENDIF

cTemp := SUBSTR( cColor, AT( ",", cColor)+1 )

RETURN SUBSTR( cTemp, 1, AT( ",", cTemp)-1 )


FUNCTION Spread( left_str, right_str, line_len )
*****************************************************************************
* Place two character strings flush left and right on a line length
* ? SPREAD("left side","right side",80)
*****************************************************************************
RETURN left_str+SPACE(line_len-LEN(left_str+right_str))+right_str

*: EOF: CALENDAR.PRG
