* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program....: CALLER.PRG                                                   *
* Author.....: Steve Manes   Roxy Recorders, Inc.  NYC                      *
* Date.......: August 5, 1983                                               *
* Notes......: loads a data file from a text file created by BINDEC.BAS     *
*              then POKEs values into memory at entry point selected by     *
*              user.                                                        *
*                                                                           *
*              User must have previously created a DBF file CSTRUCT.DBF     *
*              with the structure:  Poke:val,C,82                           *
*                                                                           *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 
 
SET TALK OFF
SET COLON OFF
ERASE
 
? '                           LOAD MACHINE LANGUAGE SUBROUTINE' 
?
? '       Note:     EXE or COM file must have previously been converted to '
? '                 filename.DTX with BINDEC.BAS'
 
* Get name of converted BINDEC.BAS file to Infile
* Get name of DBF file that will contain POKE instructions to Outfile
STORE '        ' TO Infile
STORE '        ' TO Outfile
@ 7,17 SAY 'Name of converted source file   - '
@ 9,17 SAY 'Name of desired DBF output file - '
 
* Get legal input filename. See if it exists.
STORE T TO Again
DO WHILE Again
   @ 7,51 GET Infile
   READ
   IF @('.',Infile)>0
      STORE $(Infile,1,@('.',Infile)-1) TO Infile
   ENDIF
   STORE TRIM(Infile) TO Infile
   STORE !(Infile)+'.DTX' TO Infile
 
   IF FILE('&Infile')
      STORE F TO Again
      @ 7,51 SAY Infile+'       '
   ELSE
      ? CHR(7)
      @ 22,20 SAY '* * * FILE '+Infile+' NOT FOUND * * *'
      STORE '        ' TO Infile
      STORE 1 TO X
      DO WHILE X<30
         STORE X+1 TO X
      ENDDO
      @ 22,20
   ENDIF [FILE('&Infile')
ENDDO [Again]
 
* Get output filename. Warn user that if the DBF file already exists,
* it will be overwritten.
STORE T TO Again
DO WHILE Again
   @ 9,51 GET Outfile
   READ
   IF @('.',Outfile)>0
      STORE $(Outfile,1,@('.',Outfile)-1) TO Outfile
   ENDIF
   STORE TRIM(Outfile) TO Outfile
   STORE !(Outfile)+'.DBF' TO Outfile
 
   IF FILE('&Outfile')
      @ 22,20 SAY '  * * * DBF FILE '+Outfile+' ALREADY EXISTS * * *'
      @ 23,20 SAY 'O = overwrite      X = enter another filename'
      SET CONSOLE OFF
      WAIT TO Option
           DO WHILE !(Option)<>'O' .AND. !(Option)<>'X'
              WAIT TO Option
           ENDDO
      SET CONSOLE ON
      @ 22,20
      @ 23,20
        IF !(Option)='O'
           STORE F TO Again
        ELSE
           STORE '        ' TO Outfile
        ENDIF [!(Option)]
   ELSE
      STORE F TO Again
   ENDIF [FILE('&Outfile')]
 
ENDDO [Again]
@ 9,51 SAY Outfile+'       '
 
* Get SET CALL TO entry point. Make sure that it is in a free memory area.
* Although the dBASE work area ends around 42000 decimal, I have had
* problems with erasure of subroutines below 50000 when executing certain
* dBASE commands. 
STORE 50000 TO Lowlimit
STORE 65000 TO Hilimit
STORE '     ' TO Setcall
@ 11,17 SAY 'Entry address for CALL -          (decimal)' 
 
STORE T TO Again
DO WHILE Again
   @ 11,42 GET Setcall PICTURE '#####'
   READ
   IF VAL(Setcall)<Lowlimit .OR. VAL(Setcall)>Hilimit
      ? CHR(7)
      @ 22,20 SAY '* * * ADDRESS OUT OF RANGE * * *'
      STORE 1 TO X
      DO WHILE X<30
         STORE X+1 TO X
      ENDDO
      @ 22,20
      STORE '     ' TO Setcall
   ELSE
      STORE F TO Again
   ENDIF [VAL(Setcall)<...]
ENDDO [Again]
 
* Create new DBF file (filename=Outfile) that will contain the 
* dBASE POKE statements, 16 instruction bytes per record.
@ 14,0 SAY 'Converting file...'
USE CStruct
COPY STRUCTURE TO &Outfile
USE &Outfile
APPEND FROM &Infile SDF
GO TOP
SET CALL TO &Setcall
 
* Poke the instructions into memory at beginning at address Setcall
@ 14,0 SAY 'POKEing instructions into memory at '+Setcall
DO WHILE .NOT. EOF
   STORE Poke:val TO MPoke
   POKE &Setcall,&MPoke
   SKIP   
   STORE STR(16+VAL(Setcall),5) TO Setcall
ENDDO
 
ERASE
? 'File loaded into memory and ready to CALL.'
?
? 'POKE sequence loaded to: '+Outfile
?
? 'Important!  If subroutine operates on a variable, be sure that'
? '            the variable has been initialized before CALLing.'
?
?
 
USE
RELEASE ALL
RETURN
variable, be sure that'
? '            the variable has been initialized before CALLing.'
?
?
 
USE
RELEA                                                                                                                                                                                                                                                                                                                                                                                                