*:*********************************************************************
*:
*:        Program: CALENDAR.PRG
*:
*:         System: Visual calendar
*:         Author: John Wright
*:      Copyright (c) 1987-1993, John Wright
*:
*:*********************************************************************
* 04/17/87 - Show a visual calendar on the screen.
* 10/30/88 - adapted to compile by DBX and run as a C program
* 11/12/88 - put hidden copyright notice on screen at start-up time
* 12/26/89 - modified to work with the FORCE compiler
* 01/16/90 - Had to use SCRN_DOS in order to display in BANKER.
* 08/07/90 - Use the new TSR feature of FORCE 2.1.
* 11/21/91 - Put the number of days in the year at bottom of screen.
*            Toggle date using arrow keys - added help screen.
*            Took the TSR feature out since it took 94k to load!
* 11/22/91 - Support monochrome (no color) with command line parameter.
* 01/24/93 - Modified copyright notice and changed keys to work like the
*            Clipper 5 calendar function.  (Inspired by this program.)

#INCLUDE date.hdr
#INCLUDE io.hdr
#INCLUDE jddat.hdr       && Jeff Davis library for Force
#INCLUDE keys.hdr
#INCLUDE string.hdr
#INCLUDE system.hdr

VARDEF  EXTERN
    BYTE     __color_std
ENDDEF

VARDEF
  DATE        maindate, dodate, first_date, last_date, old_date
  CHAR(2)     fmon
  INT(3)      tmon, boxnum, boxday, jrow, jcol, oldrow, oldcol
  INT(3)      normal, boxit, liteit
ENDDEF

*!*********************************************************************
*!
*!      Function: CHECK_KEY
*!
*!*********************************************************************
FUNCTION INT check_key
* check the keys pressed and act on specific keys
VARDEF
  CHAR(10)    _date
  CHAR(2)     _month
  CHAR(2)     _day
  CHAR(4)     _year
  INT(2)      _irow,_icol
  INT         _return_key
  LOGICAL     _end_of_month
  LOGICAL     _stuff_it
ENDDEF
* shut off the key handler...
ON KEY DO
_return_key = 0
_end_of_month = .F.
_stuff_it = .F.
DO CASE
CASE LASTKEY() = &K_F1                                && [Help] key
  STORE ROW() TO _irow
  STORE COL() TO _icol
  cursor_off()
  Save_area(5,3,22,25)
  Fill(5,3,22,25,"        "," ",112,112,0)
  __color_std = boxit
  @ 06,06 SAY " CALENDAR  v 3.1 "
  @ 07,04 SAY ""
  @ 09,05 SAY "[/]  = change day"
  @ 10,05 SAY "[/]  = change week"
  @ 11,05 SAY "[Home] = first day"
  @ 12,05 SAY "[End]  = last day"
  @ 13,05 SAY "[PgDn] = next month"
  @ 14,05 SAY "[PgUp] = prior month"
  @ 15,05 SAY "[+]    = next year"
  @ 16,05 SAY "[-]    = prior year"
  @ 17,05 SAY "[Esc]  = exit"
  @ 19,04 SAY ""
  @ 20,04 SAY "Freeware by J.Wright"
  @ 21,04 SAY "Copyright  1987-1993"
  Get_key()
  restore_area()
  __color_std = normal
  cursor_on()
  @ _irow,_icol
  IF LASTKEY() <> &K_ESC
    _return_key = LASTKEY()
  ENDIF

CASE LASTKEY() = &K_RIGHT                             && [] key
  _date=DTOC(DAYS_FROM(old_date,1))
  _stuff_it = .T.

CASE LASTKEY() = &K_LEFT                              && [] key
  _date=DTOC(DAYS_FROM(old_date,-1))
  _stuff_it = .T.

CASE LASTKEY() = &K_DOWN                              && next week
  _date=DTOC(DAYS_FROM(old_date,+7))
  _stuff_it = .T.

CASE LASTKEY() = &K_UP                                && previous week
  _date=DTOC(DAYS_FROM(old_date,-7))
  _stuff_it = .T.

CASE LASTKEY() = &K_PG_DOWN                           && next month
  _end_of_month = IsLastDay(old_date)
  _date=DTOC(AddMonth(old_date,1))
  _stuff_it = .T.

CASE LASTKEY() = &K_PG_UP                             && previous month
  _end_of_month = IsLastDay(old_date)
  _date=DTOC(AddMonth(old_date,-1))
  _stuff_it = .T.

CASE LASTKEY() = 45 .OR. LASTKEY() = &K_C_PG_UP       && [-] key
  _date=DTOC(old_date)
  IF SUBSTR(_date,1,6) = "02/29/"
    _date="02/28/"+STR(VAL(RIGHT(_date,4))-1,4,0)
  ELSE
    _date=SUBSTR(_date,1,6)+STR(VAL(RIGHT(_date,4))-1,4,0)
  ENDIF
  _stuff_it = .T.

CASE LASTKEY() = 43 .OR. LASTKEY() = &K_C_PG_DOWN     && [+] key
  _end_of_month = IsLastDay(old_date)
  _date=DTOC(old_date)
  IF SUBSTR(_date,1,6) = "02/29/"
    _date="02/28/"+STR(VAL(RIGHT(_date,4))+1,4,0)
  ELSE
    _date=SUBSTR(_date,1,6)+STR(VAL(RIGHT(_date,4))+1,4,0)
  ENDIF
  _stuff_it = .T.

CASE LASTKEY() = &K_HOME                              && start on month
  _date=DTOC(FirstDay(old_date))
  _stuff_it = .T.

CASE LASTKEY() = &K_END                               && end of month
  _date=DTOC(LastDay(old_date))
  _stuff_it = .T.

CASE LASTKEY() = &K_C_HOME
  _date="01/01/"+RIGHT(DTOC(old_date),4)
  _stuff_it = .T.

CASE LASTKEY() = &K_C_END
  _end_of_month = IsLastDay(old_date)
  _date="12/31/"+RIGHT(DTOC(old_date),4)
  _stuff_it = .T.

OTHERWISE
  _return_key = LASTKEY()
ENDCASE

IF _stuff_it
  IF _end_of_month     && make sure months with 28 - 30 days display correctly
     _date=DTOC(LastDay(CTOD(_date)))
  ENDIF
  _month=SUBSTR(_date,1,2)
  _day=SUBSTR(_date,4,2)
  _year=RIGHT(_date,4)
  KEYBOARD(_month+_day+_year)
  KEY_INT(&K_ENTER)                              && press enter
ENDIF

* Turn key handler back on...
ON KEY DO check_key

RETURN _return_key

ENDPRO

*!*********************************************************************
*!
*!      Procedure: FORCE_MAIN
*!
*!*********************************************************************
PROCEDURE force_main
PARAMETERS CHAR cmd_line

DO scrn_direct       && This forces the runtime engine
                     && to read the BIOS row/col positions.
oldrow = row()       && Get current row/col information from the
oldcol = col()       && SCRN_DIRECT screen driver.

DO Scrn_dos

* main program code for CALENDAR
SET CONFIRM ON
SET SCOREBOARD OFF
SET CENTURY ON
Save_area(4,1,23,26)

IF .NOT. ISCOLOR() .OR. "BW" $ UPPER(cmd_line) .OR. "MONO" $ UPPER(cmd_line)
  normal=007
  boxit=112
  liteit=112
ELSE
  normal=023
  boxit=112
  liteit=116
ENDIF

* set up the basic calendar
fill(04,01,23,26,&DOUBLE_BOX," ",normal,normal,0)

__color_std = normal
@ 08,3 SAY " S  M  T  W  T  F  S"
@ 09,3 SAY "Ŀ"
@ 10,3 SAY "              "
@ 11,3 SAY "Ĵ"
@ 12,3 SAY "              "
@ 13,3 SAY "Ĵ"
@ 14,3 SAY "              "
@ 15,3 SAY "Ĵ"
@ 16,3 SAY "              "
@ 17,3 SAY "Ĵ"
@ 18,3 SAY "              "
@ 19,3 SAY "Ĵ"
@ 20,3 SAY "              "
@ 21,3 SAY ""
@ 22,3 SAY "       [F1]=help      "

STORE Today() TO maindate,old_date

ON KEY DO check_key

REPEAT        && loop to process dates - do current date first...

  IF TESTDATE(maindate)
    * display the month and year
    @ 07,03 SAY CMONTH(maindate)+SPACE(18-LEN(CMONTH(maindate)))
    @ 07,21 SAY STR(YEAR(maindate),4,0)

    * Figure out the number of days left in the year.
    STORE CTOD("01/01/"+STR(YEAR(maindate),4,0)) TO first_date
    STORE CTOD("12/31/"+STR(YEAR(maindate),4,0)) TO last_date
    @ 22,03 SAY RIGHT("000"+LTRIM(STR(DAYS_BTW_DATEs(first_date,maindate)+1,3,0)),3)
    @ 22,22 SAY RIGHT("000"+LTRIM(STR(DAYS_BTW_DATEs(maindate,last_date),3,0)),3)

    * get the first date in the month
    STORE MONTH(maindate) TO tmon
    IF tmon < 10
      STORE "0"+STR(tmon,1,0) TO fmon
    ELSE
      STORE STR(tmon,2,0) TO fmon
    ENDIF
    STORE CTOD(fmon+"/01/"+STR(YEAR(maindate),4,0)) TO dodate

    STORE 10 TO jrow
    STORE 4 TO jcol
    STORE 0 TO boxday
    STORE 0 TO boxnum

    DO WHILE boxnum < 37
      STORE boxnum+1 TO boxnum
      STORE boxday+1 TO boxday
      IF DOW(dodate) = boxday .AND. MONTH(dodate) = tmon
        IF dodate = maindate
          __color_std = liteit
          @ jrow,jcol SAY STR(DAY(dodate),2,0)
          __color_std = normal
        ELSE
          @ jrow,jcol SAY STR(DAY(dodate),2,0)
        ENDIF
        STORE Days_from(dodate,1) TO dodate
      ELSE
        @ jrow,jcol SAY "  "
      ENDIF
      IF boxday=7
        STORE 0 TO boxday
      ENDIF
      STORE jcol+3 TO jcol
      IF jcol > 23
        STORE jrow+2 TO jrow
        STORE 4 TO jcol
      ENDIF
    ENDDO

    old_date = maindate

  ELSE
    SOUND(100,5)
  ENDIF

  * get the date to display
  @ 05,03 SAY "Enter date: "
  @ 05,15 GET maindate
  READ

UNTIL LASTKEY() = &K_ESC

ON KEY DO

* clean up the screen and return to DOS
Restore_area()
* put cursor back where it was...
@ oldrow, oldcol

QUIT

ENDPRO

*: EOF: CALENDAR.PRG
