** File: CALDEMO.PRG   System: Calendar      Version: 1.00  Date: 05-01-90 **
 
**********
* Demo of hot key calendar during date GETs for Clipper Summer '87 programs.
*
* Adding feature to most programs requires only SET KEY in start-up module and
* PIKDATE/POPCAL() in procedure module.  See PIKDATE notes below.
*
* Craig Hessel/ER Support/DOE
**********
SET KEY -1 TO PIKDATE                        && F2 here--adjust as needed
 
IF iscolor()
  SET COLOR TO W+/B,R/W
ENDIF
CLEAR
 
chars = space(8)
date1 = ctod("")
date2 = date()
date3 = ctod("07/04/1776")
 
@  6,29 SAY "Clipper Calendar Demo"
 
@ 17, 9 SAY "Hot key F2 pops ups calendar during date GETs--hilite desired"
@ 18, 9 SAY "date then press Return, else press Esc for no change to field"
 
@ 11, 7 SAY "Blank date:" GET date1
@ 11,30 SAY "Character data:" GET chars
@ 11,57 SAY "Today:" GET date2
READ
 
SET DATE ANSI
SET CENTURY ON
@ 13,22 SAY "ANSI date with century:" GET date3
READ
 
**********
* PIKDATE is SET KEY procedure to display calendar during date GETs and to
* stuff returned date to keyboard.  A non-date GET or MENU TO is ignored.
* In addition, returned date from calendar is ignored if Esc was pressed to
* exit calendar or if CENTURY OFF and date was not twentieth century.
*
* This procedure assumes you do NOT do any of the following:
*
*   1. Remap Home key.  Home key is needed to force cursor to start of GET.
*   2. Use a date picture out of synch with global SET DATE format (e.g.,
*      @E picture with American date format).  Adjust global setting instead.
*      Otherwise, digits stuffed to keyboard will be in wrong order.
*   3. Do a GET on a date field when a date memory variable of same name
*      exists.  Popup calendar uses the memory variable date for its starting
*      point when both exist.  You may, however, do GETs on date fields.
*   4. Use dates like date()+365*135000.  Dates far in future tend to make
*      Clipper date functions spit out strange results.
*
**********
PROC PIKDATE
PARA p, l, v
 
IF type(v) = "D"                             && Do nothing if not date GET
  SET CURSOR OFF
  p =popcal(iif(type("M->&v") = "D", M->&v, &v))
  SET CURSOR ON
 
  IF lastkey() <> 27                         && Do nothing if Esc
    IF len(dtoc(ctod(""))) = 8 .AND. (year(M->p) < 1900 .OR. year(M->p) > 1999)
      tone(100,1)                            && Beep if century off and wrong
    ELSE                                     &&   century returned
      KEYBOARD chr(1) + dtoc(M->p)           && Else stuff Home, then date
    ENDIF
  ENDIF
ENDIF
RETURN
 
**********
* POPCAL function pops up calendar.  If no starting date supplied, DOS date is
* used.  Output is selected date if Return exit or starting date if Esc exit.
*
* Note that Gregorian calendar dates back to 1582, so earlier displays will be
* inaccurate.  All Clipper date functions behave similarly.
**********
FUNC POPCAL
PRIV indt, outdt, top, lft, svclr, svbox, c1, c2, fom, dim, offset, line, i
 
indt = date()                                && Default starting date
PARA indt
 
top   = 1                                    && Adjust window left/right,
lft   = iif(col() < 37, 46, 3)               &&   depending on cursor location
 
svclr = setcolor()
svbox = savescreen(M->top, M->lft, M->top+13, M->lft+32)
 
STORE "W/N" TO c1, c2                        && In case mono...
IF iscolor()
  c1 = "W+/G"                                && Adjust colors to taste
  c2 = "GR+/G"
 
  SET COLOR TO N/N                           && Draw shadow if not mono
  @ M->top+1, M->lft+2 CLEAR TO M->top+13, M->lft+32
ENDIF
 
SET COLOR TO &c2                             && Draw border and filler data
@ M->top, M->lft, M->top+12, M->lft+30 BOX "Ŀ "
@ M->top+ 2, M->lft+2 SAY "Sun Mon Tue Wed Thu Fri Sat"
@ M->top+ 3, M->lft   SAY "" + repl("",29) + ""
@ M->top+10, M->lft   SAY "" + repl("",29) + ""
@ M->top+11, M->lft+2 SAY " "+chr(27)+chr(26)+"  PgUp  PgDn  Ret  Esc"
 
outdt = iif(empty(M->indt), date(), M->indt) && Changes as user navigates
 
DO WHILE .T.
  IF year(M->outdt) < 1 .OR. year(M->outdt) > 9999
    outdt = date()                           && Range check, mainly guarding
  ENDIF                                      &&   against PgUp to year 0
 
  SET COLOR TO &c1                           && Display month name and year
  line = cmonth(M->outdt) + space(22)
  @ M->top+1, M->lft+2 SAY left(line, 22) + str(year(M->outdt))
 
  fom    = M->outdt - day(M->outdt) + 1      && First of month
  dim    = 32 - day(M->fom+31)               && Days in month
  offset = dow(M->fom) - 1                   && Slots to skip initially
 
  @ M->top+3, 0 SAY ""                       && Position cursor row
  line = space(4 * M->offset)                && Blank initial slots
  FOR i = 1 TO 42 - M->offset                && Draw 42 slots over 6 lines
    line = M->line + iif(M->i > M->dim, space(4), str(M->i, 4))
    IF len(M->line) = 28
      @ row()+1, M->lft+2 SAY right(M->line, 26)
      line = ""
    ENDIF
  NEXT
 
  SET COLOR TO N/W                           && Hilite current date
  i = M->outdt - M->fom + M->offset
  @ M->top+4 + M->i/7, M->lft+2 + 4 * (M->i%7) SAY str(day(M->outdt), 2)
 
  DO WHILE .T.                               && Adjust date according to
    i = inkey(0)                             &&   keypress, or quit
    DO CASE
      CASE M->i = 13 .OR. M->i = 27          && Ret/Esc?  Done
        restscreen(M->top, M->lft, M->top+13, M->lft+32, M->svbox)
        SET COLOR TO &svclr
        RETURN iif(M->i = 27, M->indt, M->outdt)
      CASE M->i = 19                         && Left?  Back day
        outdt = M->outdt-1
      CASE M->i = 4                          && Right?  Ahead day
        outdt = M->outdt+1
      CASE M->i = 24                         && Down?  Ahead week
        outdt = M->outdt+7
      CASE M->i = 5                          && Up?  Back week
        outdt = M->outdt-7
      CASE M->i = 3                          && PgDn?  Ahead year
        outdt = M->fom+366 - day(M->fom+366) + day(M->outdt)
      CASE M->i = 18                         && PgUp?  Back year
        outdt = M->fom-365 - day(M->fom-365) + day(M->outdt)
      OTHERWISE                              && Bad key?  Ignore
        LOOP
    ENDCASE
 
    EXIT                                     && New date, so exit and display
  ENDDO
ENDDO
 
* Function return is inside loop
 
