//
//   Program Name: KENCALC.PRG       Copyright: Ken Klein, 76655,2026
//   Date Created: 10/03/91           Language: Clipper 5.0
//   Time Created: 14:21:34             Author: Ken Klein
//   /brief/library.src
//.............................................................................
#include "inkey.ch"							  // Nantucket supplied
#include "GetExit.ch"							  // Nantucket supplied

#define 	CALC_TOP			1				  // Create (simulated) instance
#define 	CALC_LEFT			2				  // variable structure
#define 	CALC_COL_UPKEY		3
#define 	CALC_COL_DNKEY		4
#define 	CALC_COL_SCREEN		5
#define 	CALC_COL_CALC		6
#define 	CALC_READER			7
#define 	CALC_CARGO			8
#define 	CALC_DECIMALS		9
#define 	CALC_EXIT			10
#define 	CALC_DEPRESS		11
#define 	CALC_BUFFER			12
#define 	CALC_LASTKEY		13
#define 	CALC_KEYS			14
#define 	CALC_UDF_KEYS		15
#define 	CALC_TAPE			16

STATIC oCalc									  // this is the main object

*
*	Calculator(<nRow>, <nCol>, <cColor>, <aUdf> )
*
*		<nRow>		- Numeric, Top row of calculator, defaults to 5
*		<nCol>		- Numeric, Top column of calculator, defaults to 5
*		<cColor>	- Charactor, Calculator color string: "col1,col2,,,col3"
*		   col1 is the color of the calculator
*		   col2 is the color of unpressed keys and the input screen
*		   col3 is the color of a depressed key
*		<aUdf>		- Array, This is a biggee!  A two dimensional array of 
*					  inkey codes and blocks to execute.   For Example:
*
*		   aUdf := 	{	;
*		   				{ K_F1, 	{||CalcHelp()} 				},;
*						{ K_ALT_S, 	{||CalcSave(GetCalc())} 	} ;
*					}
*

FUNCTION Calculator(r,c,cColor,aUdf)

	// insert function to push getlist, video, and database settings onto stack

	SET SCOREBOARD OFF
	SETCURSOR(0)

	// set up parameter defaults
	r		:= IF(r==NIL,5,IF(r>MAXROW()-16,MAXROW()-16,r))	 // must fit on screen
	c		:= IF(c==NIL,5,IF(c>MAXCOL()-27,MAXCOL()-27,c))
	cColor	:= IF(cColor==NIL,SETCOLOR(),cColor)
	aUDF	:= IF(aUdf==NIL,{},aUdf)

	oCalc := CreateCalc(r,c,cColor)				  // create calc object

	oCalc[ CALC_DEPRESS ] := .F.				  // togle to draw mode

	oCalc[ CALC_UDF_KEYS ] := aUdf				  // assign User defined functions array
	DrawCalc(0)									  // draw calculator set cursor to 0
	oCalc[ CALC_DEPRESS ] := .T.				  // togle to keypress mode

	DO WHILE oCalc[CALC_EXIT] == .F.			  // Main loop of program
	   GetCalcInput()
	   EvalCalc()
	ENDDO

	// insert function to pop getlist, video, and database settings off stack

RETURN oCalc[ CALC_BUFFER ]

*
*	This function gets the character expression from the (simulated) calc
*	object then adds the expression to the tape array, and converts the
*	expression to a code block.  If an error occurs, it loops through the
* 	process until the user fixes the error or request to quit or clear.
*
*
FUNCTION EvalCalc()
	LOCAL cExp, nAns := 0, nTry := 0
	LOCAL OldError := ERRORBLOCK()

	IF CHR(oCalc[ CALC_LASTKEY ]) <> "Q" .AND. 	;  // check that user didn't just quit
	   oCalc[ CALC_LASTKEY ] <> K_ESC .AND.	;
	   LEN(TRIM(oCalc[ CALC_BUFFER ])) > 2		  // check to be sure value not empty

	   AADD(oCalc[ CALC_TAPE ],TRIM(oCalc[ CALC_BUFFER ]) )	 // add to tape

	   cExp := oCalc[ CALC_BUFFER ]
	   cExp := "{||"+ALLTRIM(cExp)+"}"

	   ERRORBLOCK({|e| InvalExp(e,OldError) } )
	   DO WHILE nAns == 0 ;						 // perform local error handling until correct
		  .AND. LASTKEY() <> K_ESC ;			 // allow escape
		  .AND. UPPER(CHR(LASTKEY())) <> "Q" ;	 //	allow quit			  
		  .AND. UPPER(CHR(LASTKEY())) <> "C"	 //	allow clear			  
		  BEGIN SEQUENCE
			 cExp := &cExp
			 nAns := EVAL(cExp)
			 oCalc[ CALC_BUFFER ] := PADR(ALLTRIM(STR(nAns)),60)
		  RECOVER 								  
			 // for some reason it takes two loops to correct an error
			 // the following statement only gets input after two tries
				IF nTry == 0
				   TONE(300,1)
				   GetCalcInput()				  // let user fix expression
				   nTry++
				ELSEIF nTry == 1
				   nTry := 0	
				ENDIF
	   		 cExp := oCalc[ CALC_BUFFER ]		  // reformat expression to 
			 cExp := "{||"+ALLTRIM(cExp)+"}"	  // block format
			 LOOP								  // then return to evaluate
		  END SEQUENCE
	   ENDDO
	   ERRORBLOCK(OldError)
	ENDIF
RETURN NIL

*
*	This function is really two functions combined.  To determine which 
*	part it is going to exicute, it checks the calculator's (simulated)
*	instance variable "CALC_DEPRESS".  If "CALC_DEPRESS" == .t. it waits 
*  for a keystroke then displays the keypress.  If "CALC_DEPRESS" == .f.
*	it draws the entire calculator and returns without waiting for keypress.
*
FUNCTION DrawCalc(nCursor)
	LOCAL OldCursor := SETCURSOR(IF(nCursor==NIL,0,nCursor))  // default to no cursor shown
	LOCAL OldColor := SETCOLOR()
	LOCAL i, nKey := 0, x, y


	IF oCalc[ CALC_DEPRESS ] == .F.				  // just draw no inkey()
	   DISPBEGIN()
	   SETCOLOR(oCalc[ CALC_COL_CALC ])
	   @ oCalc[ CALC_TOP ],oCalc[ CALC_LEFT ],;
	     oCalc[ CALC_TOP ]+15,oCalc[ CALC_LEFT ]+26 BOX "Ŀ "
	   SETCOLOR(oCalc[ CALC_COL_SCREEN ])
	   @oCalc[ CALC_TOP ]+1  ,oCalc[ CALC_LEFT ]+2, ;
	    oCalc[ CALC_TOP ]+3,oCalc[ CALC_LEFT ]+24 BOX "Ŀ "
	   FOR i := 1 TO LEN(oCalc[ CALC_KEYS ])
		  @oCalc[ CALC_KEYS ][i,3],oCalc[ CALC_KEYS ][i,4] SAY oCalc[ CALC_KEYS ][i,5]
	   NEXT
	   DISPEND()
	ELSE										  // wait for key then display
	   oCalc[ CALC_LASTKEY ] := ASC(UPPER(CHR(INKEY(0))))
	   SETCURSOR(0)
	   SETCOLOR(oCalc[ CALC_COL_DNKEY ])
	   i := ASCAN(oCalc[ CALC_KEYS ],{|elem|oCalc[ CALC_LASTKEY ]==elem[2]})
	   IF i > 0	   
		  x := SECONDS()
		  y := SECONDS()
		  DO WHILE x+.1 > y 			// delay 10/100 of a second
		     y := SECONDS()
			 @oCalc[ CALC_KEYS ][i,3],oCalc[ CALC_KEYS ][i,4] SAY oCalc[ CALC_KEYS ][i,5]
		  ENDDO
		  SETCOLOR(oCalc[ CALC_COL_SCREEN ])
		  @oCalc[ CALC_KEYS ][i,3],oCalc[ CALC_KEYS ][i,4] SAY oCalc[ CALC_KEYS ][i,5]
	   ENDIF
	ENDIF
	SETCOLOR(OldColor)
	SETCURSOR(OldCursor)
RETURN NIL

*
*	This function creates a get object, assigns a reader to handle the 
*	the keystrokes, then checks to see if the lastkey was an exit key.
*	If the lastkey was an exit key it changes the (simulated) calulator
*	object's (simulated) instance variable "CALC_EXIT" to .T..
*
FUNCTION GetCalcInput()
	LOCAL cExp := oCalc[ CALC_BUFFER ], GetList := {}

	@ oCalc[ CALC_TOP ]+2,oCalc[ CALC_LEFT ]+3 GET cExp PICTURE "@s21K"
	GetList[1]:Reader := oCalc[ CALC_READER ]
	READ
	IF LASTKEY() <> K_ESC .AND. UPPER(CHR(LASTKEY())) <> "Q"
	   oCalc[ CALC_BUFFER ] := cExp				  // assign expression to buffer
	ELSE
	   oCalc[ CALC_EXIT ] := .T.				  // to exit loop
	ENDIF
RETURN NIL

*	
*	This is the guts of the system.  This function calls DrawCalc which
*	waits for a keypress and displays it.  It then checks the lastkey 
*	in the case statement to check for valid keys, operators, and
* 	buttons.  After checking those keys it scans the aUdf array to see if
*  the lastkey was a call to a udf.
*
FUNCTION CalcReader(oGet)
	LOCAL nKey, i, StdGetKeys, nTape := LEN(oCalc[ CALC_TAPE ])
	LOCAL OldCursor := SETCURSOR( 1 ), nLastkey, nCurs := 1, nLkey

	StdGetKeys := {  ;							  // These are the standard
	K_END,	;									  // get keys.  they are
	K_HOME, ;									  // specified only to 
	K_LEFT, ;									  // restrict movement.
	K_RIGHT,;
	K_BS,	;
	K_DEL,	;
	K_INS,	;
	K_ESC	;
	}

	IF GetPreValidate(oGet)
	   oGet:SetFocus()
	   DO WHILE oGet:exitState == GE_NOEXIT
		  IF oGet:TypeOut
			 oGet:exitState := GE_ENTER
		  ENDIF
		  nCurs := IF(READINSERT()==.T.,3,1)
		  DrawCalc(nCurs)							  // calls inkey and displays keypress
		  nLastKey := IF(nLastKey==NIL,oCalc[ CALC_LASTKEY ],nLastKey)
		  DO CASE
		  CASE CHR(oCalc[ CALC_LASTKEY ]) $ ".0123456789*/+-^()"
			 GetApplyKey(oGet,oCalc[ CALC_LASTKEY ])
			 nLastKey := oCalc[ CALC_LASTKEY ]
		  CASE CHR(oCalc[ CALC_LASTKEY ]) $ "E"
			 oGet:delLeft()
			 oGet:display()
		  CASE CHR(oCalc[ CALC_LASTKEY ]) == "C"
			 oGet:buffer := SPACE(60)
			 oGet:pos := 0
			 oGet:display()
		  CASE CHR(oCalc[ CALC_LASTKEY ]) == "Q"
			 oGet:buffer := SPACE(60)
			 oGet:pos := 0
			 oGet:display()
			 oGet:exitstate := GE_ESCAPE
		  CASE oCalc[ CALC_LASTKEY ] == K_ENTER .OR. CHR(oCalc[ CALC_LASTKEY ]) = "="
			 oGet:display()
			 oGet:exitstate := GE_WRITE
		  CASE oCalc[ CALC_LASTKEY ] == K_UP
				DO CASE
				CASE nTape > 0 .AND. nTape <= LEN(oCalc[ CALC_TAPE ])
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape--],60)
				   oGet:display()
				CASE nTape == 0 .AND. LEN(oCalc[ CALC_TAPE ]) > 0
				   nTape := LEN(oCalc[ CALC_TAPE ])
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape--],60)
				   oGet:display()
				CASE nTape > LEN(oCalc[ CALC_TAPE ])
				   nTape := LEN(oCalc[ CALC_TAPE ])
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape--],60)
				   oGet:display()
				ENDCASE
		  CASE oCalc[ CALC_LASTKEY ] == K_DOWN
				DO CASE
				CASE nTape > 0 .AND. nTape <= LEN(oCalc[ CALC_TAPE ])
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape++],60)
				   oGet:display()
				CASE nTape > LEN(oCalc[ CALC_TAPE ]) 
				   nTape := 1
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape++],60)
				   oGet:display()
				CASE nTape == 0 .AND. LEN(oCalc[ CALC_TAPE ]) > 0
				   nTape := 1
				   oGet:buffer := PADR(oCalc[ CALC_TAPE,nTape++],60)
				   oGet:display()
				ENDCASE
		  CASE ( i := ASCAN(StdGetKeys,{|elem|elem==oCalc[ CALC_LASTKEY ]}) ) > 0
			 GetApplyKey(oGet,oCalc[ CALC_LASTKEY ])
			 oGet:display()
		  CASE ( i := ASCAN(oCalc[ CALC_UDF_KEYS ],{|elem|elem[1]==LASTKEY()}) ) > 0  // use lastkey to use normal inkey codes
			 EVAL(oCalc[ CALC_UDF_KEYS,i,2])
			 oGet:display()
		  ENDCASE
	   ENDDO
	ENDIF
	oGet:Assign()
	IF !GetPostValidate(oGet)
	   oGet:exitState := GE_NOEXIT
	ENDIF
	SETCURSOR(OldCursor)
RETURN NIL

*
*	Creates oCalc (simulated object) array.
*			
*			It must be passed t&l paramaters they do not default.
*			
*
FUNCTION CreateCalc(t,l,cColor)

	LOCAL aColors := Col_Split(cColor), aKeys, oNewCalc

	aColors[5] := IF(aColors[5]==aColors[2],aColors[1],aColors[5])

	aKeys := {  ;
	{  1   ,  ASC(".")  ,  t+13 ,l+8   ,  "  .  " },;
	{  2   ,  ASC("0")  ,  t+13 ,l+2   ,  "  0  " },;
	{  3   ,  ASC("1")  ,  t+11 ,l+2   ,  "  1  " },;
	{  4   ,  ASC("2")  ,  t+11 ,l+8   ,  "  2  " },;
	{  5   ,  ASC("3")  ,  t+11 ,l+14  ,  "  3  " },;
	{  6   ,  ASC("4")  ,  t+9  ,l+2   ,  "  4  " },;
	{  7   ,  ASC("5")  ,  t+9  ,l+8   ,  "  5  " },;
	{  8   ,  ASC("6")  ,  t+9  ,l+14  ,  "  6  " },;
	{  9   ,  ASC("7")  ,  t+7  ,l+2   ,  "  7  " },;
	{ 10   ,  ASC("8")  ,  t+7  ,l+8   ,  "  8  " },;
	{ 11   ,  ASC("9")  ,  t+7  ,l+14  ,  "  9  " },;
	{ 12   ,  ASC("/")  ,  t+5  ,l+2   ,  "  /  " },;
	{ 13   ,  ASC("*")  ,  t+5  ,l+8   ,  "  *  " },;
	{ 14   ,  ASC("+")  ,  t+5  ,l+14  ,  "  +  " },;
	{ 15   ,  ASC("-")  ,  t+5  ,l+20  ,  "  -  " },;
	{ 17   ,  K_ENTER   ,  t+13 ,l+14  ,  "  =  " },;
	{ 18   ,  ASC("=")  ,  t+13 ,l+14  ,  "  =  " },;
	{  7   ,  ASC("E")  ,  t+9  ,l+20  ,  " CE  " },;
	{ 19   ,  ASC("C")  ,  t+11 ,l+20  ,  "  C  " },;
	{ 19   ,  ASC("^")  ,  t+7  ,l+20  ,  "  ^  " },;
	{ 20   ,  ASC("Q")  ,  t+13 ,l+20  ,  "  Q  " };
	}
	oNewCalc := {	;
	t		 					,;				  // CALC_TOP
	l							,;				  // CALC_LEFT
	aColors[2]					,;				  // CALC_COL_UPKEY
	aColors[5]					,;				  // CALC_COL_DNKEY
	aColors[2]					,;				  // CALC_COL_SCREEN
	aColors[1]					,;				  // CALC_COL_CALC
	{|oGet|CalcReader(oGet)}	,;				  // CALC_READER
	NIL							,;				  // CALC_CARGO
	12							,;				  // CALC_DECIMALS
	.F.							,;				  // CALC_EXIT
	.T.							,;				  // CALC_DEPRESS
	SPACE(60)					,;				  // CALC_BUFFER
	0							,;				  // CALC_LASTKEY
	aKeys						,;				  // CALC_KEYS
	{}		 					,;				  // CALC_UDF_KEYS
	{}		 					 ;				  // CALC_TAPE
	}

RETURN oNewCalc

*
*	error handling function returns to enter a loop that lets 
*	the user correct the error
*
FUNCTION InvalExp(e,OldError)

	IF e:operation == "&"
	   BREAK
	ELSE
	   ERRORBLOCK(OldError)
	ENDIF

RETURN NIL

*
*	returns calculator object to read its (simulated instance) variables 
*
FUNCTION GetCalc()
RETURN oCalc

*
*	THIS IS RICK SPENCE'S COLOR SPLITTING ROUTINE UNCHANGED
*
FUNCTION col_split(color_to_split)				  

	LOCAL color_num, next_comma, colors[5]

	 color_to_split := IF(color_to_split==NIL, setcolor(),color_to_split)

    FOR color_num = 1 TO 4
        next_comma = at(",", color_to_split)
        colors[color_num] = substr(color_to_split, 1, next_comma - 1)
        color_to_split = substr(color_to_split, next_comma + 1)
    NEXT

    colors[5] = color_to_split

RETURN colors

