//.............................................................................
//
//   Program Name: CALCDEMO.PRG      Copyright: Ken Klein, 76655,2026
//   Date Created: 10/11/91           Language: Clipper 5.0                                         
//   Time Created: 17:32:43             Author: Ken Klein                                 
//   /brief/library.src
//.............................................................................
/*
Ŀ
                                                                           
  This is an untraditional calculator.  It works more like a spread-       
  sheet than a calculator, since the user has full expression editing      
  capabilities, unlimited recall of past expressions, and saving           
  calculator sessions to a disk file.                                      
                                                                           
  Any user with a spreadsheet background will like this calculator         
  immediately.  Anyone else will love it quickly after.                    
                                                                           
  Let me know what you think.                                              
                                                                           
  FEATURES:                                                                
                                                                           
        Expression editing.  Up to 60 charactors per expression.          
                                                                           
        Expression recall, Up to 4096 expressions (if memory is           
         available)  can be stored in memory.                              
                                                                           
        User code blocks, an unlimited number of code blocks and hot      
         keys can be passed to the calculator to be evaluated, with        
         no modifications to the calculators source code.                                   
                                                                           
  DEMO                                                                     
                                                                           
      TO INSTALL TYPE THE FOLLOWING FROM THE SUBDIRECTORY THAT CONTAINS    
              CALCDEMO.PRG                                                 
              CALC_OBJ.PRG                                                 
                                                                           
      THE FOLLOWING ASSUMES CLIPPER AND RTLINK ARE IN THE PATH             
                                                                           
      C> CLIPPER CALCDEMO /W/N/M/A/B                                       
      C> CLIPPER CALC_OBJ /W/N/M/A/B                                       
      C> RTLINK FI CALCDEMO, CALC_OBJ                                      
      C> CALCDEMO                                                          
                                                                           
                                                                           
                                                      Ken Klein            
                                                      76655,2026           
                                                                           


*/

       
#include "inkey.ch"                              // Nantucket supplied header
#define    CALC_TAPE           16                // for save udf

*
*  I tried to keep this as simple as possible to show how easy it is.
*

FUNCTION Demo()
   LOCAL aUdf, cColor, nAns 

   aUdf :=     {   ;                             // udf array
                   { K_F1,     {||CalcHelp()}  }, ;            
                   { K_ALT_S,  {||CalcSave(GetCalc())}     } ;
               }                                             

   CLEAR SCREEN                                       
   IF ISCOLOR()
      cColor := "W/R,N/W,,,W/N"
   ENDIF
   nAns := Calculator(5,5,cColor,aUdf) 
RETURN NIL

*
*  Sample user defined function 
*
*
FUNCTION CalcHelp()
   @ 1,2 SAY "This is a sample of a user defined function."
RETURN NIL

*
*  Sample user defined function to save expression array to disk file
*
*  This is pretty exciting.  You could make this fancy, and let the user
*  choose file names.  You could also create a CalcRead function to read
*  a saved expression array from disk.
*
FUNCTION CalcSave(oCalc)
   LOCAL i, nFile

   IF LEN(oCalc[ CALC_TAPE ]) >0
      nFile := FCREATE("CALCTAPE.CAL")
      FOR i := 1 TO LEN(oCalc[ CALC_TAPE ])
         FWRITE(nFile,oCalc[ CALC_TAPE,i]+CHR(13)+CHR(10))
      NEXT
      FCLOSE(nFile)
   ENDIF

RETURN NIL         


