
// DEMO2.prg - Demo of the calculator showing UDFs and setkeys, etc

#include "inkey.ch"

#define F_BLOCKS  " "

Function CalcHard()
Local getlist:={}, nInteger, nDontWork, nFloating, cText, nAnother, aColor

   If IsColor()
      aColor := {"W+/B,W/R,,,W/R","W/R","W/B,W/R,,,W/B"}
   Else
      aColor := {"W/N,N/W,,,W/N"}
   Endif

   Set Scoreboard OFF

   SetColor(aColor[1])
   CLS
   @ 0,0,24,79 Box F_BLOCKS

   CalcReg(00000)                  //insert your reg. no. here
   Set Key K_ALT_O to Calculator

   CalcInit("W+/R")                //try a Red Calculator

   //This will cause F2 to multiply anything by 2
   SetKey(K_F2,{|p,line,var,no| If(p="CALCULATOR", no * 2, NIL)})

   //This will cause F3 to do a square root
   SetKey(K_F3,{|p,line,var,no| If(p="CALCULATOR", Sqrt(no), NIL)})

   //This will cause the $ dollar sign to set fixed decimals to 2
   SetKey(Asc("$"),{|p|If(p="CALCULATOR", "F2", NIL)})

   //This will cause the calc to call CalcProc() when beginning and when
   // ending to display a personalized help screen.
   CalcUDF({|a,b,c,d,e,f,g,h|CalcProc(a,b,c,d,e,f,g,h)})

   nInteger :=7
   nDontWork:=6
   nAnother:=-5
   nFloating:=1.23
   cText    :=Space(8)

   @ 9,5 Get nInteger
   @10,5 Get nDontWork
   @11,5 Get nAnother
   @12,5 Get nFloating
   @13,5 Get cText

   @ 9,20 Say     "< The integer will transfer to the calculator."
   @10,20 Say     "< You can disable the calculator on specific fields."
   @11,20 Say     "< Negative."
   @12,20 Say     "< Floating Point transfer and return (Ctrl-Enter)."
   @13,20 Say     "< Text pasting. (press Ctrl-Enter inside calculator)."

   @15,5 Say "Press ALT-O to access the calculator"

   READ

   CLS
   @ 2,0,24,79 Box F_BLOCKS

   @ 3,2 Say "There are hundreds of users of the calculator including:"

   @ 5,2 Say "UPS"
   @ 6,2 Say "JPL"
   @ 7,2 Say "Statewide Insurance"
   @ 7,2 Say "Transamerica Insurance Group"
   @ 8,2 Say "Marriott Services"
   @ 9,2 Say "Interamerican Development Bank"
   @10,2 Say "First National Bank"
   @11,2 Say " and many more including software development firms"

   @13,2 Say "And we're happy that banks and insurance companies can trust this to be the"
   @14,2 Say "'Best Calculator by far for Clipper.'"

   @16,2 Say "So if you want to put the calculator to use for your users,"
   @17,2 Say "then (1) try it out by linking it to your program, and"
   @18,2 Say "     (2) review REGISTER.DOC for receiving your license"

   @20,2 Say "And... you can even receive your registration number to"
   @21,2 Say "       activate your copy (no copyright message) by phone!"

   @23,2 Say "Touchstone Business Creations (909) 679-3364 voice   (909) 672-2731 fax"

   SetColor("W/N")
   Scroll(0,0,MaxRow(),MaxCol(),1)
   SetCursor(1)
   SetPos(MaxRow(),0)

Return NIL


Function CalcProc(cProc, nVer, cVar, nDisp, cDisp, nMode, cColor, nKey)
* cProc     = Procedure (always "CALCULATOR")
* nVer      = Version number (10 through 21, for ver 1.0 through ver 2.1)
* cVar      = Variable name of GET field called from
* nDisp     = Numeric display of calculator
* cDisp     = Character display of calculator
* nMode     = Either 0 for INIT, 1 for ALLKEYS, or 2 for END
* cColor    = Color when entering calculator
* nKey      = Lastkey pressed

Static cSaveScreen
Local xRetVal

   If nMode = 0 //INIT: called going into the calculator

      //First, if this variable is "nDontWork," then abort (no calculator)
      If cVar = "NDONTWORK"
         Return .T.           // True = ABORT CALC
      Endif

      //Everything ok, change color to W+/B (if color display)
      // Also, NO need to SAVE COLOR, calculator does that.
      If(IsColor(),SetColor("W+/B"),NIL)

      //Everything ok, save screen, popup help screen
      cSaveScreen:=SaveScreen(0,29,7,51)
      @ 0,29 to 7,51 Double
      @ 1,30 Say " F2 = Display x 2    "
      @ 2,30 Say " F3 = Square Root    "
      @ 3,30 Say "  $ = Fix 2 decimals "
      @ 4,30 Say "  H = Calculator Help"
      @ 5,30 Say " F9 = Add Tax to val "
      @ 6,30 Say " F10= Put Tax in Mem "

      xRetVal := "F3" //fix decimals to 3 on INITIAL CALL

   Elseif nMode=3 //TERM: called going out of the calculator

      RestScreen(0,29,7,51,cSaveScreen)

   Elseif nMode=2 //Key Exception

      Do Case
         Case nKey = K_F9   //multiply TAX to current value
            xRetVal := nDisp * 1.0775

         Case nKey = K_F10  //stuff TAX into Memory!
            CalcMemory( 1.0775 )

      Endcase

   Endif

// (On INITIAL call from the calculator, if you return a character string,
//  it will be "keyboarded" into the calculator (remember Set Typeahead)).

Return xRetVal
