*  Program Ŀ
*   Application: Calculator 2.0                                             
*     File Name: dCLmouse.prg    dClip Mouse Interface for Calculator 2.0   
*        Author: Jim Gale                                                   
*  Date created: 10-03-93                                                   
*  Time created: 11:06:04pm                                                 
*     Make File:                                                            
*     Exec File:                                                            
*     Copyright: 1993 by Touchstone Business Creations                      
* 

*  Function Ŀ
*   Description: Determime if a mouse if present in the system.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:00am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_IsMouse()                                               
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: lMouseExists - logical value representing if a mouse is    
*                               present.                                    
*      See Also:                                                            
*                                                                           
* 
Function CM_IsMouse()
Return dc_moupresent()

*  Function Ŀ
*   Description: Report which mouse button is being pressed.                
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:35:52am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Button()                                                
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nButtonPressed - numeric representing which mouse button   
*                                 was pressed:                              
*                                                                           
*                Valid Values are:                                          
*                                                                           
*                   0 = no button pressed (or mouse not present)            
*                   1 = left button pressed                                 
*                   2 = right button pressed                                
*                                                                           
*      See Also:                                                            
*                                                                           
* 
Function CM_Button()
Return dc_moubutton()

*  Function Ŀ
*   Description: Report the mouse cursor row.                               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Row()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseRow - numeric representing text row of mouse.        
*      See Also:                                                            
*                                                                           
* 
Function CM_Row()
Return dc_mourow()

*  Function Ŀ
*   Description: Report the mouse cursor column.                            
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:39:58am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Col()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: nMouseCol - numeric representing text column of mouse.     
*      See Also:                                                            
*                                                                           
* 
Function CM_Col()
Return dc_moucol()

*  Function Ŀ
*   Description: Turn the mouse cursor on.                                  
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:40:26am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_On()                                                    
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_On()
Return dc_moushow()

*  Function Ŀ
*   Description: Turn the mouse cursor off.                                 
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:42:50am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Off()                                                   
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: n/a                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Off()
Return dc_mouhide()

*  Function Ŀ
*   Description: Report the state of the cursor and optionally set it.      
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:29am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Cursor([<lState>])                                      
*                                                                           
*     Arguments: [<lState>] - new state of cursor (on/off) - optional       
*                                                                           
*  Return Value: lOldState - old state of cursor (on/off)                   
*      See Also:                                                            
*                                                                           
* 
Function CM_Cursor(lNew)
Local lRet:=dc_mouvisible()
   If ValType(lNew)="L"
      If(lNew,dc_moushow(),dc_mouhide())
   Endif
Return lRet

*  Function Ŀ
*   Description: Initialize/Reset mouse system for calculator               
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:44:42am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Init()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
Function CM_Init()
   dc_mouinitialize()
Return NIL

*  Function Ŀ
*   Description: Provide any needed exit support for the mouse.             
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 10:23:22am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Exit()                                                  
*                                                                           
*     Arguments: none                                                       
*                                                                           
*  Return Value: NIL                                                        
*      See Also:                                                            
*                                                                           
* 
Function CM_Exit()
Return NIL

*  Function Ŀ
*   Description: Wait .2 seconds for a key or until a button is released.   
*        Author: Jim Gale                                                   
*  Date created: 10-30-93                                                   
*  Time created: 09:47:46am                                                 
*     Copyright: Touchstone Business Creations                              
* Ĵ
*      Function: CM_Wait(<nButton>,<lMousekey>)                             
*                                                                           
*     Arguments: <nButton>   - button state to wait for.                    
*                <lMousekey> - whether to wait until a button is released.  
*                                                                           
*  Return Value: <nKey>      - numeric representing the key pressed.        
*                                                                           
*         Notes: This function is called by the calculator after            
*                highlighting the button on-screen that was pressed/clicked.
*                                                                           
*                When a mouse is present, the purpose is to wait until it   
*                is released so that drifting of the mouse does not cause   
*                unwanted keystrokes.                                       
*                                                                           
*                Without a mouse present, the purpose is to wait .2 seconds 
*                for the highlighting effect (unless a key was pressed).    
*                                                                           
*      See Also:                                                            
* 
Function CM_Wait(n,lMousekey)
Local nKey:=0
   If lMousekey
      While dc_moubutton()#n .and. (nKey:=Inkey())=0
      Enddo
   Else
      nKey:=Inkey(.2)
   Endif
Return nKey
