
/* Simple Demo of Calculator 1.5

   Compile using RT.BAT for RTLINK or
              BLINK.BAT for BLINKER

   Manually:
             Clipper DEMO /n/w

             Blinker fi DEMO lib CALC
          or RTLink  fi DEMO lib CALC

*/

#define F_BLOCKS  " "

#command CLS [with <char>] [color <color>]  ;
      => @ 0,0,MaxRow(),MaxCol() Box If(<.char.>,Repl(<char>,9),"         ") ;
         [Color <color>]


#include "inkey.ch"

#stdout
#stdout Remember to LINK with the appropriate mouse object file:
#stdout  FUNMOUSE for FunckyII, DCLMOUSE for dClip, NANMOUSE for NANFOR,
#stdout  or NOMOUSE for none (this is the LIBRARY default)!
#stdout

Function Demo()
Local aColor, nVar1, nVar2, cVar1, GetList:={}


   CalcReg(00000)                //insert your reg. no. here


   SET KEY K_F5 TO CALCULATOR    //it's as easy as this!


   //Set Environment
   Set Scoreboard OFF
   Set Confirm ON

   //Check Color
   If IsColor()
      aColor := {"W+/B,W/R,,,W/R","W/R","W/B,W/R,,,W/B","+W*/B"}
   Else
      aColor := {"W/N,N/W,,,W/N","N/W","W/N,N/W,,,W/N","N*/W"}
   Endif

   //Setup Screen
   SetMode(25,80)
   SetColor(aColor[1])
   CLS with "" Color "W/N"
   @ 0,0,MaxRow(),52 Box F_BLOCKS

   //Setup Values
   nVar1 := 1
   nVar2 := 1.23

   cVar1 := Space(10)

   @ 9,2 Say "      Integer Test:"
   @ 9,22 Get nVar1 Color aColor[3]

   @10,2 Say "Fixed Decimal Test:"
   @10,22 Get nVar2 Color aColor[3]

   @12,2 Say "    Character Test:"
   @12,22 Get cVar1 Color aColor[3]

   SetColor(aColor[2])
   @ 1,2,7,50 Box F_BLOCKS
   @ 2,3 Say "Adding something as simple as:"
   @ 3,3 Say "SET KEY K_F5 TO CALCULATOR" Color "+"+SetColor()
   @ 4,3 Say "will allow all wait states access to "
   @ 5,3 Say "the Calculator() and will allow *all*"
   @ 6,3 Say "numerics and characters to receive the results:"

   @ 14,2,21,50 Box F_BLOCKS
   @15,3 Say "After you press F5, notice that it holds the"
   @16,3 Say "value of the variable.  After doing"
   @17,3 Say "calculations you can press CTRL-ENTER to paste"
   @18,3 Say "back the result."

   @20,3 Say "(Press H for Help in the Calculator)"

   SetColor(aColor[1])
   Read

   CLS
   @ 0,0,24,79 Box F_BLOCKS
   @ 16,2 Say "Now in SPANISH..." Color aColor[4]
   Inkey(2)
   @ 16,2 Say "Press 'H' to view help" Color aColor[1]
   CalcLanguage("SPA")
   Calculator()

   CLS
   @ 0,0,24,79 Box F_BLOCKS

   @ 3,2 Say "Also, you can take advantage of the Trigonometrical functions"
   @ 4,2 Say "which include Sin(), Cos(), Tan(), ArcSin(), ArcCos(), ArcTan(),"
   @ 5,2 Say "Sec(), Csc(), Cot(), Pi(), and more (24 in all)"

   @ 7,2 Say "They were written in C and are very fast - yet, overlayable also."
   @ 8,2 Say "Of course, if you are going for super-speed, put TRIG in the root"
   @ 9,2 Say "since overlaying any function called many times becomes slow."

   Set Decimals to 10

   @11,2 Say "            RADIAN           DEGREE       RESULTS IN:"
   @12,2 Say "Sine:       SinR(.785398)    Sin(45)      "
   @12,38 Say Sin(45)

   @14,2 Say "---press a key---"
   Inkey(0)

   CLS
   @ 2,0,24,79 Box F_BLOCKS

   @ 3,2 Say "There are hundreds of users of the calculator including:"

   @ 5,2 Say "UPS"
   @ 6,2 Say "JPL"
   @ 7,2 Say "Statewide Insurance"
   @ 7,2 Say "Transamerica Insurance Group"
   @ 8,2 Say "Marriott Services"
   @ 9,2 Say "Interamerican Development Bank"
   @10,2 Say "First National Bank"
   @11,2 Say " and many more including software development firms"

   @13,2 Say "And we're happy that banks and insurance companies can trust this to be the"
   @14,2 Say "'Best Calculator by far for Clipper.'"

   @16,2 Say "So if you want to put the calculator to use for your users,"
   @17,2 Say "then (1) try it out by linking it to your program, and"
   @18,2 Say "     (2) review REGISTER.DOC for receiving your license"

   @20,2 Say "And... you can even receive your registration number to"
   @21,2 Say "       activate your copy (no copyright message) by phone!"

   @23,2 Say "Touchstone Business Creations (909) 679-3364 voice   (909) 672-2731 fax"

   SetColor("W/N")
   Scroll(0,0,MaxRow(),MaxCol(),1)
   SetCursor(1)
   SetPos(MaxRow(),0)

Return NIL
