/*
Ŀ
   Cal50 - A Pop-up calendar system for Clipper 5.0                          
   Written for RMS by Paul H. Earley.                                        
   Loosely Based on  CAL.prg, which was written by Al Degutis                
   Getsys modifications by Paul H. Earley of a previous getsys               
   modification of Lindsay McCann.                                           
                                                                             
 This pop-up calendar can be called three ways:                              
   1. By a direct call to CAL_UDF which will pop-up a calendar               
         with the passed date highlighted. It will appear starting at        
         the row: beg_row, and thew column: beg_col                          
                                                                             
   2. By a SET KEY TO CAL_UDP. This will pop-up a calendar but not allow     
         the user to use the returned value. You may wish to modify this     
         procedure to stuff the keyboard if you chose.                       
                                                                             
   3. By hitting a "C" or "c" while editing a date in a get.                 
         This will work if you recompile with the modified Getsys            
         program contained in this ZIP. This neat routine will pop-up        
         a calendar in a date edit (in a GET) when the user types "C"        
         The calendar will open with the current day, month and year         
         of the GET highlighted. It will then return the date the user       
         selected to the GET itself. (Thanks to Lindsay McCann whose         
         modification of increasing or decreasing the date with the          
         + or - keys I lifted for my further modifications).                 


Several things about this calendar should be noted:

   1. It uses no outside librarys (although commented code points to a place
      to use one of the many shadow routines).

   2. It cleans up the screen after itself, but assumes a 25x80 screen.

   3. It uses three color variables. The are set to mundane values for
      demonstration. Please experiment to visualize other possibilities.

   4. The calendar resizes for different months.

   5. The active keys are as follows:

       Up-arrow: Move to one week previously. If in a different month,
                 move accordingly.

     Down-arrow: Move to one week later. If in a different month, move
                 accordingly.

     Left-arrow: Move one day earlier. If in a different month, move
                 accordingly.

    Right-arrow: Move one day later. If in a different month, move
                 accordingly.

        Page-Up: Move to previous month. If year changes, do that too.

      Page-Down: Move to next month. If year changes, do that too.

Control-Page-Up: Move to previous year.

  Ctrl-PageDown: Move to next year.

           Home: Move calendar to current day, month, and year.

         Escape: Remove calendar and return to the calling program the
                 date that the calendar was called with.

     Return Key: Remove calendar and return the highlighted date.

   6. The system date must be set so Clipper can access it using Date()

   7. If you are on the last day of a month with 31 days, moving to the
      next month will leave the selected date at day 31 or if the month
      has less than 31 days, the calendar will highlight the last day
      of that month.

   8. The current date is always highlighted.

*/
// The DEFAULT command, used by this routine:
#command DEFAULT <var1> TO <value1> ;
   =>       IF ( <var1> == NIL ); <var1> := <value1>; END

// must have inkey.ch in your path
#include "inkey.ch"


FUNCTION Cal_Udf2(Date)
// called from getsys this routine returns the selected date or the same date
// if user exits with Esc
RETURN Cal_Udf(Date,IF(ROW()<8,8,1),IF(COL()<39,52,2))

PROCEDURE CAL_UDP
Cal_Udf(,IF(ROW()<7,6,1),IF(COL()<39,52,2))
RETURN

FUNCTION Cal_udf(use_date,beg_row,beg_col)
LOCAL cC_Bkgrnd := "W/B"   // main color of the calendar, dates, and "Su Mo" string
LOCAL cC_Title  := "GR+/B" // Title color, and color of the day today
LOCAL cC_select := "GR+/GB" // color of the selected date
LOCAL ocursor,t_color,l_key,h_use_date
LOCAL exit_cal:=.f.,l_day,cTitle
LOCAL nF_dow,J:=0,nScrn_loc,day_num,day_str
LOCAL nDay,nMonth,nYear,cYear,nCal_size
LOCAL x[42], y[42],I,day_mark:=.F.
LOCAL scrn:=Savescreen(beg_row,beg_col,beg_row+16,beg_col+23)
LOCAL ocolor:=Setcolor()
LOCAL ChkMonth:={|D,nD|Month(D)==Month(D+nD).AND. Year(D)==Year(D+nD)}
#define line0 "Ŀ"
#define line1 "Ĵ"
#define line2 "              "
#define line3 ""
DEFAULT use_date TO Date()
DEFAULT beg_row TO 8
DEFAULT beg_col TO 28
h_use_date := use_date    // hold the calling date in case user escapes from this routine
ocursor:=Setcursor(0)
// define X coordinates
FOR nScrn_loc = beg_row+3 TO beg_row+13 STEP 2
    FOR I = 1 TO 7
        x[++J] := nScrn_loc
    NEXT
NEXT
// define Y coordinates
J := 0
FOR I = 1 TO 6
   FOR nScrn_loc = beg_col+1 TO beg_col+19 STEP 3
      y[++J] := nScrn_loc
   NEXT
NEXT
 
DO WHILE !exit_cal
   // Day, Month, Year, first day, last day of month data
   nMonth:=Month(use_date)
   nYear:=Year(use_date)
   cYear:=STR(nYear)
   nDay :=Day(use_date)
   l_day := LastDay(nMonth,nYear)  // the day number of the last day in this month
   // get the day of the week (number) of the first day in the month
   nF_dow=dow(ctod(STR(nMonth,2)+'/01/'+cYear))
   IF !day_mark  // only redraw calendar if MORE than a day select occurs.
      // restore screen for successive calendars, in case calendar size changes
      Restscreen(beg_row,beg_col,beg_row+16,beg_col+23,scrn)
      // determine calendar size by days in month and when the first day starts
      DO CASE
      CASE l_day == 31 .AND. nF_dow  > 5
         nCal_size := 14
      CASE l_day == 30 .AND. nF_dow > 6
         nCal_size := 14
      CASE l_day == 28 .AND. nF_dow == 1
         nCal_size := 10
      OTHERWISE
         nCal_size := 12
      ENDCASE
      // begin drawing calendar
      Setcolor(cC_Bkgrnd)
      @ beg_row,beg_col CLEAR TO beg_row+nCal_size,beg_col+22
      @ beg_row+2,beg_col SAY line0
      FOR I = beg_row+3 TO beg_row+nCal_size-3 STEP 2
         @ I,beg_col SAY line2
         @ I+1,beg_col SAY line1
      NEXT
      @ beg_row+nCal_size-1,beg_col SAY line2
      @ beg_row+nCal_size,beg_col SAY line3
      @ beg_row+1,beg_col+1 SAY "Su Mo Tu We Th Fr Sa"   // days of the week
      t_color := Setcolor(cC_Title)
      cTitle := cmonth(use_date)+' '+cYear
      @ beg_row,beg_col+1 SAY SPACE(11-LEN(cTitle)/2)+cTitle
      Setcolor(t_color)
      // create shadow
      // remove comment from this next line if you have a shadow routine
// Shadow(beg_row,beg_col,beg_row+nCal_size,beg_col+22)
      // done constructing calendar
   ENDIF // if only the day marking changes have occured
   day_num := 0
   FOR nScrn_loc=nF_dow TO 42
      day_str=STR(++day_num,2)
      // print day of month in selected color if it is current selected date,
      // highlighted if it is the current date (in real time), or normal otherwise.
      DO CASE
      CASE day_num==Day(use_date)
         t_color:= Setcolor(cC_Select)
         @ x[nScrn_loc],y[nScrn_loc] SAY day_str
         Setcolor(t_color)
      CASE day_num==day(Date()) .AND. nMonth==Month(date());
                                                .AND. nYear==Year(Date())
         t_color := Setcolor(cC_Title)
         @ x[nScrn_loc],y[nScrn_loc] SAY day_str
         Setcolor(t_color)
      OTHERWISE
         @ x[nScrn_loc],y[nScrn_loc] SAY day_str
      ENDCASE
      IF day_num == l_day
         EXIT
      ENDIF
   NEXT
   DO WHILE .T.  // use this loop to prevent nonsense keys from redrawing the calendar
   inkey(0)
   l_key := LASTKEY()
   day_mark := .F.   // assume that user will change calendar month
   DO CASE
   CASE l_key == K_RIGHT            // increase by one day
      day_mark := Eval(ChkMonth,use_date,1)
      use_date++
   CASE l_key == K_LEFT             // decrease by one day
      day_mark := Eval(ChkMonth,use_date,-1)
      use_date--
   CASE l_key == K_UP               // increase by seven days
      day_mark := Eval(ChkMonth,use_date,-7)
      use_date := use_date-7
   CASE l_key == K_DOWN             // decrease by seven days
      day_mark := Eval(ChkMonth,use_date,7)
      use_date := use_date+7
   CASE l_key == K_HOME                // Home key
      use_date := date()
   CASE l_key==K_ESC .OR. l_key==K_ENTER  // User aborted, or selected date
      exit_cal := .T.
   CASE l_key == K_PGUP                // page-up key  - back one month
      nMonth--
      IF nMonth<1
         nMonth := 12
         nYear--
      ENDIF
      use_date := MakDate(nMonth,nDay,nYear)
   CASE l_key == K_CTRL_PGUP           // ctrl+page-up - back one year
      use_date=MakDate(nMonth,nDay,--nYear)
   CASE l_key == K_PGDN                // page-down key - ahead one month
      IF ++nMonth>12
         nMonth := 1
         nYear++
      ENDIF
      use_date=MakDate(nMonth,nDay,nYear)
   CASE l_key == K_CTRL_PGDN           // ctrl+page-down  - ahead one year
      use_date=MakDate(nMonth,nDay,++nYear)
   OTHERWISE
      LOOP
   ENDCASE
   EXIT
   ENDDO
   // if user paged down from a selected day greater than the number of days in
   // the new month, the
ENDDO
Restscreen(beg_row,beg_col,beg_row+16,beg_col+23,scrn)
Setcolor(ocolor)
Setcursor(ocursor)
// return the date the user selected, or the calling date if user exited with Escape
RETURN IF(l_key==K_ESC,h_use_date,use_date)

STATIC FUNCTION LastDay(month,year)
// returns the last day of a month as an integer.
LOCAL t_date
t_date := CTOD(STR(month,2)+'/27/'+STR(year))
DO WHILE month == Month(++t_date)
ENDDO
RETURN day(--t_date)

STATIC FUNCTION MakDate(Month,Day,Year)
// receives integers of the month day and year and returns a composite date.
// If day in month is greater than the true numbers in the month it returns
// the last day.
LOCAL x
x := ctod(STR(Month,2)+'/'+STR(Day,2)+'/'+STR(Year))
IF x == CTOD("  /  /  ")
   x := ctod(STR(Month,2)+'/'+STR(LastDay(Month,Year),2)+'/'+STR(Year))
ENDIF
RETURN x
