******************   CAL5.PRG   ***********************************************
****     NO Copyright !                                                    ****
****     Released into PUBLIC DOMAIN                                       ****
****     Courtesy of TJS LAB, PO BOX 585366, Orlando, Florida  32858-5366  ****
*******************************************************************************
***                                                                         ***
*** CAL5 demostrates the use of '@ PROMPT TO' within nested FOR/NEXT loops
***                                                                         ***
*** This program is a simple Calendar/Memo Application....
***                                                                         ***
***                  I used PLINK86 to link CAL5.PRG
***              IE: PLINK86 FILE CAL5 LIB CLIPPER, EXTEND                  ***
*******************************************************************************

SET WRAP ON         && 'Wrap around' the prompts
SET EXCLUSIVE OFF   && I always 'assume' multi-user...
SELECT 1
IF !FILE("CAL5.DBF")  && If no calendar database, then make one...
   MAKAFILE()
ELSE
   USE CAL5      && Calendar Database
ENDIF
CLEAR
IF !FILE("CAL5.NTX")
   INDEX ON DATE TO CAL5
ENDIF
SET INDEX TO CAL5
SAVE SCREEN TO FIRSTSCREEN   && Save so as to restore screen when exiting
CLEAR

   *  The following code, just draws a partial screen
   SET COLOR TO BR+/N
   @ 24,0 SAY "TJS LAB, PO BOX 585366, ORLANDO, FLORIDA 32858-5366"
   SET COLOR TO W+/B
   @ 1,11 CLEAR TO 20,40
   @ 1,11 TO 20,40
   @ 2,12  SAY "  APPOINTMENTS & CALENDARS  "
   @ 13,12 SAY CHR(24)+" "+CHR(25)+" "+CHR(26)+" "+CHR(27) +" (move Date/Cursor)"
   @ 14,12 SAY "PgUp for Next Month"
   @ 15,12 SAY "PgDn for Previous Month"
   @ 16,12 SAY "Ctrl PgUp for Next Year"
   @ 17,12 SAY "Ctrl PgDn for Previous Year"
   @ 18,12 SAY "Enter to Edit Appointments"
   @ 19,12 SAY "Esc to Exit/Return to Menu"
   SET COLOR TO R+/B
   @ 13,12 SAY CHR(24)+" "+CHR(25)+" "+CHR(26)+" "+CHR(27)
   @ 14,12 SAY "PgUp"
   @ 15,12 SAY "PgDn"
   @ 16,12 SAY "Ctrl PgUp"
   @ 17,12 SAY "Ctrl PgDn"
   @ 18,12 SAY "Enter"
   @ 19,12 SAY "Esc"

   TDATE=DATE()          && Start at today...

   LF=CHR(13)+CHR(10)    && Append to end of each new line of REMARKS

DO WHILE .T.   && This loop is necessary for any PgUps/PgDns
   SET COLOR TO W+/R
   THEDATE=PCAL(TDATE,3,15) && Call the Calendar prompt routine...
   IF LASTKEY()=27  && Exit if Esc pressed...
      EXIT
   ELSEIF LASTKEY()=13  && If a date was select with the Enter key, then edit
		       ** the notes for that day
      SCRN=SAVESCREEN(1,0,24,50)
      SEEK THEDATE  && See if the date already has a record...
      IF EOF()      && If not, then create a 'template' of sorts...
	 NTS=CDOW(THEDATE)+", "+LTRIM(STR(DAY(THEDATE)))+" "+CMONTH(THEDATE)+" "+LTRIM(STR(YEAR(THEDATE)))+"    Julian: "+JULIAN(THEDATE)
	 NTS=NTS+LF+"0700:"+LF+"0800:"+LF+"0900:"+LF+"1000:"+LF+"1100:"+LF+"1200:"+LF+"1300:"+LF+"1400:"+LF+"1500:"+LF+"1600:"+LF+"1700:"+LF+"1800:"+LF+"1900:"+LF+"2000:"+LF+"2100:"+LF+"2200:"+LF+"2300:"
      ELSE
	 NTS=REMARKS && Else load the remarks into the variable: NTS
      ENDIF

      * The following just moves the cursor to the right of a line...
      KEYBOARD CHR(24)+CHR(4)+CHR(4)+CHR(4)+CHR(4)+CHR(4)+CHR(4)
      SET CURSOR ON

      * Build the screen for the following memoedit() of NTS
      SET COLOR TO G+/N
      @ 24,0
      @ 24,1 SAY "Press Ctrl W to Save and Exit, Esc to Abort"
      SET COLOR TO GR+/N
      @ 24,7 SAY "Ctrl W"
      @ 24,32 SAY "Esc"
      SET COLOR TO B+/N
      @ 1,0 CLEAR TO 23,50
      @ 1,0 TO 23,50
      SET COLOR TO W+/R
      @ 1,14 SAY "[ Selected Date: "+DTOC(THEDATE)+" ]"
      SET COLOR TO W+/B
      READINSERT(.T.)                      && Default INSERT MODE on
      NTS=MEMOEDIT(NTS,2,1,22,49,.T.)      && Memoedit() the variable: NTS
      IF EOF() .AND. LASTKEY()<> 78 .AND. LASTKEY()<>110 && IF Exited OK, then
	 APPEND BLANK
      ENDIF
      DO WHILE !RLOCK()   && Must lock the record before a REPLACE
      ENDDO
      REPLACE DATE WITH THEDATE, REMARKS WITH NTS
      UNLOCK
      TDATE=THEDATE
      SET CURSOR OFF
      RESTSCREEN(1,0,24,50,SCRN)
   ENDIF
ENDDO
*  RESET THE SET KEYS...
SET COLOR TO W/N
SET CURSOR ON
CLOSE DATABASES
RESTORE SCREEN FROM FIRSTSCREEN
RETURN

FUNCTION PCAL
PARAMETERS PARM,PARM1,PARM2
PRIVATE PARM,PARM1,PARM2,TEMPCOLOR,I,J,K,X

*  Set Keys PgUp/PgDn to skip months, Ctrl PgUp/Ctrl PgDn to skip years
SET KEY 18 TO NMONTH()
SET KEY 3 TO PMONTH()
SET KEY 31 TO NYEAR()
SET KEY 30 TO PYEAR()

START=DOW(CTOD(SUBSTR(DTOC(PARM),1,3)+"01"+SUBSTR(DTOC(PARM),6,3))) - 1
@ PARM1,PARM2 CLEAR TO PARM1+9,PARM2+21   && DRAW BOX FOR CALENDAR
@ PARM1,PARM2 TO PARM1+9,PARM2+21
@ PARM1,PARM2+ROUND((22-LEN("["+CMONTH(PARM)+" "+STR(YEAR(TDATE),4)+"]"))/2,0) SAY "["+CMONTH(PARM)+" "+STR(YEAR(TDATE),4)+"]"
@ PARM1+1,PARM2+1 SAY  "S  M  T  W  T  F  S "
@ PARM1+2,PARM2   SAY "Ĵ"
@ PARM1+9,PARM2+12  SAY "TJS LAB"
K=0
FOR I=1 TO 6
   FOR J = START TO 6      && START PRINTING AT 1ST DAY COLUMN (ON 1ST LINE)
      K=K+1               && INCREMENT DAY BY 1
      IF DOW(CTOD(SUBSTR(DTOC(PARM),1,3)+RIGHT("00"+ALLTRIM(STR(K,2)),2)+SUBSTR(DTOC(PARM),6,3)))>0
	 @ PARM1+2+I,PARM2+1+J*3 PROMPT IIF(DOW(CTOD(SUBSTR(DTOC(PARM),1,3)+RIGHT("00"+ALLTRIM(STR(K,2)),2)+SUBSTR(DTOC(PARM),6,3)) )>0,STR(K,2),"")
      ENDIF
      IF CTOD(SUBSTR(DTOC(PARM),1,3)+RIGHT("00"+ALLTRIM(STR(K,2)),2)+SUBSTR(DTOC(PARM),6,3))=TDATE
	 X=K
      ENDIF
   NEXT
   START = 0    && RESET TO 0, WILL NOT NEED FOR OTHER THAN 1ST LINE...
NEXT
MENU TO X

* Reset the keys...
SET KEY 18 TO
SET KEY 3 TO
SET KEY 31 TO
SET KEY 30 TO

* Return the selected date
RETURN CTOD(SUBSTR(DTOC(PARM),1,3)+RIGHT("00"+ALLTRIM(STR(X,2)),2)+SUBSTR(DTOC(PARM),6,3))

FUNCTION PMONTH   && Skip back a month
SET KEY 3 TO
IF MONTH(PARM-28)=MONTH(PARM)
   TDATE=PARM-35
ELSE
   TDATE=PARM-28
ENDIF
KEYBOARD CHR(3)
RETURN ""

FUNCTION NMONTH   && Skip forward a month
SET KEY 18 TO
IF MONTH(PARM+28)=MONTH(PARM)
   TDATE=PARM+35
ELSE
   TDATE=PARM+28
ENDIF
KEYBOARD CHR(18)
RETURN ""

FUNCTION PYEAR   && Skip back a year
TDATE=PARM-365
IF MONTH(TDATE+28)=MONTH(TDATE)
   TDATE=TDATE+35
ELSE
   TDATE=TDATE+28
ENDIF
PARM=TDATE
KEYBOARD CHR(3)
RETURN ""

FUNCTION NYEAR   && Skip forward a year
TDATE=PARM+365
IF MONTH(TDATE-28)=MONTH(TDATE)
   TDATE=TDATE-35
ELSE
   TDATE=TDATE-28
ENDIF
PARM=TDATE
KEYBOARD CHR(18)
RETURN ""

FUNCTION JULIAN    && RETURNS JULIAN DATE IN A STRING OF 3  IE:  089
PARAMETER PARM
PRIVATE PARM,X,JDATE

*   Determine the number of days so far into the year...
X = IIF("01"$SUBSTR(DTOC(PARM),1,2),1,VAL(SUBSTR(DTOC(PARM),1,2)) * 3 - 2)

**  The following line determines if this is a leap year...
   JDATE=IIF(YEAR(PARM)/4<>INT(YEAR(PARM)/4),;
   VAL(SUBSTR("000031059090120151181212243273304334",X,3)),;
   VAL(SUBSTR("000031060091121152182213244274305335",X,3)))+;
   VAL(SUBSTR(DTOC(PARM),4,2))

*  USE THE FOLLOWING LINE FOR MILITARY JULIAN (USE A SINGLE YEAR DIGIT)
*  RETURN RIGHT(LTRIM(STR(YEAR(PARM))),1)+RIGHT("00"+LTRIM(STR(JDATE)),3)

RETURN RIGHT("00"+LTRIM(STR(JDATE)),3)

FUNCTION MAKAFILE   && Make the Calendar Database:  CAL5.DBF
CREATE CAL5.$$$
APPEND BLANK
REPLACE FIELD_NAME WITH "DATE"
REPLACE FIELD_TYPE WITH "D"
REPLACE FIELD_LEN WITH 8
APPEND BLANK
REPLACE FIELD_NAME WITH "REMARKS"
REPLACE FIELD_TYPE WITH "M"
REPLACE FIELD_LEN WITH 10
USE
CREATE CAL5 FROM CAL5.$$$
ERASE CAL5.$$$
RETURN ""

****  EOF CAL5.PRG  ****
