    *****    utility functions for CLIP4WIN               ******
    *****    written from Dieter Stelzner, DS-Datasoft    ******
    *****    Compuserv adress: 100031,1315                ******

/*******************
FUNC WinSetup(cAppName)
FUNC WinNew(nX, nY, nWidth, nHeight, nStyle)
FUNC SetFont(hDC, aFont)
FUNC ResetFont(hDC, aSave)
FUNC FontPara(hDC, aFont, n)
FUNC ClearWindow(hWnd, nXleft, nYtop, nXright, nYbottom)
FUNC WSetColor(hDC, xTxtColor, nBKColor)
FUNC SetWCursor(lSet)
*********************/

#include "clipwin.ch"
#include "windows.ch"
#include "inkey.ch"
#include "wcolors.ch"
#include "font.ch"
#include "textmetr.ch"

STATIC hMainWin, hInst, cApplName:=""
/****************************************************************************/
* init applicationwindow
* full winsize
*****************************************************************************/
FUNCTION WinSetup(cAppName)
LOCAL hWnd, hDC, hPrevInst, nCmdShow

cApplName := cAppName
hInstance := hInst := _GetInstance()
hPrevInst := _GetPrevInstance()
nCmdShow  := _GetnCmdShow()

IF hPrevInst == 0
  // need to register the window class
  If !RegisterClass(CS_PARENTDC, ;    // window style for all following childs
          hInst, ;
          0,     ;                    // default icon
          0,     ;                    // default cursor
          BKCOLOR, ;                  // default background brush
          cAppName )                  // app name

     QUIT
  Endif
ENDIF

// create our main window
hWnd = CreateWindow(cApplName,      ;  // window class from RegisterClass()
         cApplName,       ;           // caption for title bar
         WS_POPUP,;                   // window style
         0,   ;                       // x co-ordinate
         0,       ;                   // y co-ordinate
         640,   ;                     // width
         480,      ;                  // height
         0,         ;                 // hWnd of parent (none)
         0,         ;                 // hMenu of menu (none yet)
         hInst)                       // our own app instance

IF hWnd == 0
  // probably out of resources
  QUIT
ENDIF

// Voll Bildschirm
ShowWindow(hWnd, SW_MAXIMIZE)

// ... and up to date
UpdateWindow(hWnd)

hMainWin := hWnd

RETURN( hWnd )

/****************************************************************************
* create new child window
*****************************************************************************/
FUNCTION WinNew(nX, nY, nWidth, nHeight, nStyle)
LOCAL hWin

Default nStyle To WS_CHILD+WS_VISIBLE+WS_POPUP, ;
        nX To 0, ;
        nY To 0, ;
        nWidth To 639, ;
        nHeight to 479

hWin := CreateWindow(cApplName,           ;       // window class
                    ,              ;       // caption for title bar
                    nStyle,              ;       // window style
                    nX,                  ;       // x co-ordinate
                    nY,                  ;       // y co-ordinate
                    nWidth,              ;       // width
                    nHeight,             ;       // height
                    hMainWin,            ;       // hWnd of parent
                    0,                   ;       // hMenu of menu (none yet)
                    hInst)                       // our own app instance

IF hWin == 0
   // probably out of resources
   MessageBox( , "Can't create window ", "Error", MB_ICONEXCLAMATION + MB_OK)
   RETURN(NIL)
ENDIF

HideCaret(hWin)

ShowWindow(hWin, SW_SHOW)     // ShowWindow(hWin, nCmdShow)

// ... and up to date
UpdateWindow(hWin)

RETURN(hWin)

/****************************************************************************
* set new textfont
*
*  aTextFont := {-22,8,0,0,500,.F.,.F.,.F.,0,0,0,1,49,"Terminal"}
*  hDC:=GetDC(hWin)
*  aOldFont := SetFont(hDC, aTextFont)
*  ResetFont(aOldFont)
*****************************************************************************/
FUNC SetFont(hDC, aFont)
LOCAL hfont := CreateFont(aFont)
LOCAL hOldFont := SelectObject(hDC, hFont)
RETURN( {hfont, hOldFont} )

/****************************************************************************
* reset textfont
*****************************************************************************/
FUNC ResetFont(hDC, aSave)
SelectObject(hDC, aSave[2])
DeleteObject(aSave[1])
RETURN(NIL)

/****************************************************************************
* height of a textfont
*****************************************************************************/
FUNC FontPara(hDC, aFont, n)
LOCAL aTM:=array(20)

Default n TO 1
GetTextMetrics(hDC, @aTM)

RETURN(aTM[n])

/****************************************************************************
* clear window
*****************************************************************************/
FUNC ClearWindow(hWnd, nXleft, nYtop, nXright, nYbottom)
LOCAL hDC:=GetDC(hWnd)

Default  nXleft To 0, ;
    nYtop To 0, ;
    nXright To 640, ;
    nYbottom To 480

ScrollWindow(hWnd, nXright-nXleft, 0,,{nXleft, nYtop, nXright, nYbottom})

ReleaseDC(hWnd, hDC)

RETURN(NIL)


/****************************************************************************
* set colors in windows and returns setting
* replace fr setcolor()
*****************************************************************************/
FUNC WSetColor(hDC, xTxtColor, nBKColor)
LOCAL nOldBk:=GetBKColor(hDC), nOldtxt:=GetTextColor(hDC)

// Farbrestaurierung
IF valtype(xTxtColor) == "A"
  SetTextColor(hDC, xTxtColor[1])
  SetBKColor(hDC, xTxtColor[2])

ELSE
  If ! empty(xTxtColor)
    SetTextColor(hDC, xTxtColor)
  Endif
  If ! empty(nBKColor)
    SetBKColor(hDC, nBKColor)
  Endif
ENDIF

RETURN({nOldTxt, nOldBK})


****************************************************************************
* set/hides mousecursor in windows
* funktions not always well
***************************************************************************/
FUNC SetWCursor(lSet)
LOCAL n, i

IF( valtype(lSet) != "L", lSet := .T., )

n := ShowCursor(lSet)
FOR i:=1 to n+1
   ShowCursor(lSet)
NEXT

RETURN(NIL)