    *****    serial port support functions for CLIP4WIN   ******
    *****    written from Dieter Stelzner DS-Datasoft     ******
    *****    Comuserv adress: 100031,1315                 ******

/*****************
FUNC Com_Open(nPort, nBuffer1, nBuffer2)  => .T./.F.
FUNC Com_Init(nPort, nBaud, cParity, nData, nStop)   => .T./.F.
FUNC Com_Send(cSend) => sended bytes; < 0 if error occured
FUNC Com_Close       => .T./.F.
******************/

#include "inkey.ch"
#include "windows.ch"
#include "infowin.ch"

STATIC nCom, hLib
/**************************************************************************
* Oeffnet COM
* Com_Open(1, 512, 512)
***************************************************************************/
FUNC Com_Open(nPort, nBuffer1, nBuffer2)
LOCAL cOpenCom, cPort
LOCAL lRet:=.T.

//*** DLL-Funktionen alloziieren
hLib = LoadLibrary( "USER.EXE" )             // part of Windows

cOpenCom := GetProcAddress( hLib, "opencomm",  ;
                      "Pascal", "int",    ;
                      "string, int, int" )

//*** open COM port 1
cPort := "COM"+ntoc(nPort)
nCom := CallDLL( cOpenCom, cPort, nBuffer1, nBuffer2 )

IF( nCom < 0, lRet:=.F., )

RETURN(lRet)

/**************************************************************************
* COM initialisieren
* Com_Init(1, 2400, "N", 8, 2)
***************************************************************************/
FUNC Com_Init(nPort, nBaud, cParity, nData, nStop)
LOCAL cMode, aDCB, cDCB, cBuildComDCB, cSetComState, lRet:=.F.

//*** build DCB-Struktur
aDCB = afill(array(31), 0)

aDCB[1] := ""
aDCB[3] := ""
aDCB[4] := ""
aDCB[5] := ""
aDCB[24] := ""
aDCB[25] := ""
aDCB[28] := ""
aDCB[29] := ""
aDCB[30] := ""

cDCB = a2bin(aDCB, "byte, uint, byte[3], uint[18], "  ;
                 + "byte[2], uint[2], byte[3], uint")


//*** DLL-Funktionen alloziieren
cSetComState := GetProcAddress( hLib, "SetCommState",  ;
                      "Pascal", "int",    ;
                      "string" )

cBuildComDCB := GetProcAddress( hLib, "BuildCommDCB",  ;
                      "Pascal", "int",    ;
                      "string, string" )


//*** Modestring: "COM1:2400,n,8,2"
cMode := "COM"+ntoc(nPort)+":"+ntoc(nBaud)+","+cParity+"," ;
        +ntoc(nData)+","+ntoc(nStop)

//*** Put COM parameters into DCB
IF CallDLL( cBuildComDCB, cMode, @cDCB) >= 0
   If CallDLL(cSetComState, cDCB) >= 0      // init COM with DCB
      lRet := .T.
   Endif
ENDIF

RETURN(lRet)


/**************************************************************************
* Com senden
* Com_Send(CHR(33)+CHR(20))
***************************************************************************/
FUNC Com_Send(cSend)
STATIC cWriteCom
LOCAL nlen:=len(cSend), nRet

IF cWriteCom == NIL
   cWriteCom := GetProcAddress( hLib, "writecomm",  ;
                         "Pascal", "int",    ;
                         "int, string, int" )
ENDIF

nRet := CallDll(cWriteCom, nCom, cSend, nlen)

RETURN(nRet)

/**************************************************************************
* COM schliessen
* Com_Close()
***************************************************************************/
FUNC Com_Close
LOCAL cCloseCom, lRet:=.T.

cCloseCom := GetProcAddress( hLib, "CloseComm",  ;
                            "Pascal", "int",    ;
                            "int" )

IF( CallDLL( cCloseCom, nCom) < 0, lRet:=.F., )

FreeLibrary( hLib )

RETURN(lRet)