#include "c5eb.ch"
*- SelectIDX() -------------------------------------------------------------

FUNC SelectIDX

PRIVATE IDXCount,choice

* Get number of indexes in current table
IDXCount := EB_IDXCount()

* If 0, no Indexes
IF IDXCount ==0
   RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF IDXCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_IDXCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare an array to hold index names
PRIVATE IDXList[IDXCount]

* Fill array with index names
IF EB_IDXArray(IDXList) < 1
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_IDXArray()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Display box
@ 0,40,19,59 BOX SglFrame
@ 0,41 SAY " Indexes "

* Display help prompt
PromptLine("Press [ENTER] to select, [F1] for Info, [Esc] to skip selection")

* Get user selection using ACHOICE()
Object := "INDEX"
choice := ACHOICE(2,41,18,58,IDXList,"","AChoiceFunc")

* Clear prompt line
PromptLine("")

IF choice ==0
    RETURN("")
ENDIF

RETURN(IDXList[choice])



