#include "c5eb.ch"
*- SelectEBD() -------------------------------------------------------------

FUNC SelectEBD

PRIVATE EBDCount, x, choice

* Get number of Emerald Bay Databases in current directory
EBDCount := EB_EBDCount()

* If 0, no Databases
IF EBDCount ==0
    PromptLine("No Databases!  Press any key to continue...")
    Error_msg("No Databases in Current Directory!",;
        "Change directory or copy Databases.")
    PromptLine("")
    RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF EBDCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_EBDCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare an array to hold database names
PRIVATE EBDList[EBDCount]

* Fill array with database names
IF EB_EBDArray(EBDList) < 1
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_EBDArray()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Display box
@ 0,0,19,19 BOX SglFrame
@ 0,1 SAY " Databases "

* Display help prompt
PromptLine("Press [ENTER] to select, [Esc] to Cancel")

* Get user selection using ACHOICE()
Object := "DATABASE"
choice := ACHOICE(2,2,18,18,EBDList,"","AChoiceFunc")

* Clear prompt line
PromptLine("")

IF choice ==0
    RETURN("")
ENDIF

RETURN(EBDList[choice])



