#include "c5eb.ch"
*- ShowGets() ---------------------------------------------------------------
*
* Record Edit demo
*

FUNC ShowGets
PARA ebdfile,table,index

IF PCOUNT() < 3
   index := "recno"
ENDIF

PRIVATE Formatted,FldCount,trow,brow,i,Key,FldNames,IsBin

IF eb_setdatabase(ebdfile) .AND. eb_use(table) .AND. eb_setIDX(index)
    @ 0,0 say "database:"+ebdfile
    @ 0,20 say "table:"+table+"("+index+")"
ELSE
    RETURN(FALSE)
ENDIF

IsBin := IF(TYPE("IsBin")=="L", IsBin, FALSE)

* If we somehow got here with an empty table, get out quick
IF EB_TblEmpty()
    PromptLine("Table is Empty!  Press any key to continue...")
    Error_msg("Table is Empty!")
    PromptLine("")
    RETURN(FALSE)
ENDIF

* Get number of fields
FLDCount := EB_FLDCount()

* If 0, no fields
IF FLDCount ==0
    RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF FLDCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_FLDCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare a public array to hold field names and selection flags
* (PUBLIC because we will use it in other non-child functions)
PUBLIC FLDNames[FLDCount]

* Initialize FldNames elements
* (EB_FldNamArray will only fill up to LEN(FldNames[i]) if element
* has been assigned a type
AFILL(FldNames, SPACE(20))

* Refill FldNames (unselected names were nuked in SelectFLD()
EB_FldNamArray(FldNames)

* Don't use more than 18 fields
FldCount := MIN(LEN(FldNames), 18)

* Declare an array to hold record data
PRIVATE RecData[FldCount]

* We want formatted data!
Formatted := TRUE

* Make sure we're at the first record
EB_GoTop()

* Initialize top/bottom of file flags
AtTop := TRUE
AtEnd := FALSE

* Set box top and bottom rows
trow := MAX(1,10 - INT(FldCount / 2))
brow := MIN(22,14 + INT(FldCount / 2))

* Display box
@ trow,5,brow,74 BOX DblFrame

* Display field names
FOR i := 1 TO FldCount
    @ trow+1+i,7 SAY SPACE(20-LEN(FldNames[i])) + FldNames[i] + ":"
NEXT

* Display prompt
IF ! IsBin
    PromptLine("[PgUp] - Prev Record   [PgDn] - Next Record   [Esc] - Exit")
ELSE
    PromptLine("[PgUp] - Prev Rec  [PgDn] - Next Rec  [F10] - "+;
        "Extract Program  [Esc] - Exit")
ENDIF

* Do forever (or at least until someone says stop)
DO WHILE .T.

    @ trow, 7 SAY IF(AtTop, " First Record ", "")
    @ trow,60 SAY IF(AtEnd, " Last Record ", "")

    oldcolor:=SETCOLOR()
    SETCOLOR("gr+/b,n/g,,,w+/r")

    FOR i := 1 TO FldCount
        EB_get(trow+1+i,30,FldNames[i])
    NEXT

*i:=1
*eb_get(trow+1+i++,30,"name","STR","15(ulsABC)","","p+b+")
*eb_get(trow+1+i++,30,"business","STR","20x","","p+")
*eb_get(trow+1+i++,30,"amount","BCD","5.5","","<+f*,+s+b+")
*eb_get(trow+1+i++,30,"phone","PAK","10d","d(ddd) ddd-dddd","")
*eb_get(trow+1+i++,30,"date","DAT","ddddd, mmm d th, yyy","","","","",date(),date()+20)
*eb_get(trow+1+i++,30,"time","TIM","h:m:s pm mm","","","","","12:34:56am","1:23:45pm")
*eb_get(trow+1+i++,30,"bool","LOG","","","t'Ubetcha'f'Noway'")


    x := EB_Read()
    Key := LASTKEY()

    DO CASE

        CASE Key ==ESC
            SETCOLOR(oldcolor)
            EXIT

        CASE Key ==PGUP
            IF AtTop
                TONE(1000,2)
                LOOP
            ENDIF

            EB_Skip(-1)

            AtEnd := FALSE

            IF EB_BOF()
                AtTop := TRUE
            ENDIF

        CASE Key ==PGDN
            IF AtEnd
                TONE(1000,2)
                LOOP
            ENDIF

            EB_Skip()
            AtTop := FALSE

            IF EB_EOF()
                AtEnd := TRUE
            ENDIF

        OTHERWISE
            TONE(1000,2)

    ENDCASE

ENDDO

Cls()

RETURN(TRUE)


