/****************************************************************

   This is a little program to help you zip-sort a mailing list 
   database file into the required US postal packages.  The resulting
   files are placed sorted into 4 .dbf's: 5-digit, 3-digit,
   state, and mixed.  

   THIS PROGRAM ASSUMES YOU HAVE AN INDEX CREATED: MAIL.NTX/NDX/IDX
   THAT IS THE MAIL.DBF SORTED BY ZIP CODE.

   MAIL.DBF is the main mailing list - if you need to use your
   own .DBF (of couse you will!!) make sure the other .dbf's in
   this package all have the same structure.

   After seeing what was out there in public domain to do this,
   I wasn't real impressed, so I thought I'd write my own, then
   give this one out!

   This program is useful in that it prepares separate .DBF files
   for you that contain the proper sorts; 5-digit, 3-digit, state
   and mixed.  The .dbf's when you are done - likewise are named -
   fdigit, tdigit, state, and mixed.dbf.  (Clipper didn't like the
   name 5digit so I improvised!)

   The files 5sep, 3sep, and stsep are just blank "direction"
   labels that tell you how to "label" the labels that were just
   printed.  (get it??)  These get appended into the respective
   .dbfs as needed.  (the append command did allow .dbf's starting
   with numbers!)
   
   If you find this code to be of value, please send $10.00 to:

   Jordan Redner
   PO Box 4461
   Breckenridge, CO  80424

   Or, if you have any productive comments, I'd love to hear them!
                              
   Now for the boring stuff...

   This program was written solely by Jordan Redner, president of
   Arapahoe Software, Inc.
   Breckenridge, CO  80424

   Copyright 1994 by Jordan Redner 
   All Rights Reserved

   This program is not released into the public domain
   and may not be copied or distributed without the express 
   written permission of Jordan Redner.

   Jordan Redner makes no representations as to the fitness of 
   this program for any particular purpose.

   Now that the boring stuff is over.......I hope you find this
   program of some value.....HAVE FUN!!!

****************************************************************/

store 'AL' to lstate     /* Put the state you want to print here! */
                         /* No, I don't live in Alabama, try CO,
                            the list I supplied began with AL */

close data
set stat off
set safety off
set talk off

clear

use mail index mail
@8,10 say 'Please wait...locating state and resetting mailing flags...'

copy all to alist for agent_stat = lstate
use alist
replace all mail_flag with "N"

@8,10 say '                                                           '

copy stru to fdigit
copy stru to tdigit
copy stru to state
copy stru to mixed
copy stru to temp

set filter to mail_flag = "N" 
goto top

select 2
use fdigit
zap               /* zap and pack are in here in case you */
pack              /* run this more than once */

select 3
use temp
zap
pack
use

select 1

go top
@8,10 say 'Please wait...locating 5 digit Zip Code packages...'

select 1
do while .not. eof()
  store agent_zipc to tzip
  store 0 to z
  store recno() to getback
  do while substr(tzip,1,5) = substr(agent_zipc,1,5) .and. .not. eof()
    @11,10 say 'Same 5-Digit count: '+str(z,5,0)
    store z+1 to z
    skip +1
  enddo
  if z >= 10
    select 3
    use temp
    zap
    pack
    use
    select 1
    goto getback
    copy next z to temp
    goto getback
    replace next z mail_flag with "Y"
    select 2
    append from temp
    append from 5sep
    select 1
    goto top
    loop
  endif
  @10,10 say 'Record Number: '+str(recno(),10,0)
enddo


go top
@8,10 say 'Please wait...locating 3 digit Zip Code packages...'

select 2
use tdigit
zap
pack

select 1
do while .not. eof()
  store agent_zipc to tzip
  store 0 to z
  store recno() to getback
  do while substr(tzip,1,3) = substr(agent_zipc,1,3) .and. .not. eof()
    @11,10 say 'Same 3-Digit count: '+str(z,5,0)
    store z+1 to z
    skip +1
  enddo
  if z >= 10
    select 3
    use temp
    zap
    pack
    use
    select 1
    goto getback
    copy next z to temp
    goto getback
    replace next z mail_flag with "Y"
    select 2
    append from temp
    append from 3sep
    select 1
    goto top
    loop
  endif
  @10,10 say 'Record Number: '+str(recno(),10,0)
enddo

goto top

@8,0 clear to 12,78

@10,10 say 'Packaging any remaining pieces of mail...please wait...'

count rest to nleft
goto top

if nleft >= 10
  select 2
  use state

  select 3
  use temp
  zap
  pack
  use
  select 1
  copy next nleft to temp
  goto top
  replace next nleft mail_flag with "Y"
  select 2
  append from temp
  append from stsep
  select 1
  goto top
else
  select 2
  use mixed

  select 3
  use temp
  zap
  pack
  use
  select 1
  copy rest to temp
  goto top
  replace rest mail_flag with "Y"
  select 2
  append from temp
  select 1
  goto top
endif

close data
return
