;**                                   Develop.m
;** is to be used with dBaseIII(1.0,1.1,1.2),III+ to speed up the develop- 
;** ment of your .prg files by creating the proper variables from your .dbf
;** for editing,data entry and replacing.
;** develop.m must have the file dispstru.com in the path or in the same 
;** sub-directory to properly work....this file is on the Solution Systems
;** RBBS in the /dbrief file area
;** Written by Randy Wallin
;**            COB System Designs
;**            620 Dogwood Road
;**            W. Palm Beach,Fl 33409
;**            305-471-3036
;** This file is for your enjoyment and productivity...please use it alot.
;** 
(macro develop
    (
    (int  counter   ;** number of fields in a data base
          recount   ;** will reset the counter for next op
          flen      ;** file name length
          procnum   ;** procedure number
          doit      ;** triggers one task
          rowb      ;** beginning row
          colb      ;** beginning col
          rowe      ;** ending row
          cole      ;** ending col
          this_buffer  ;** current buffer
          dev_buffer   ;** the development buffer
          show_buffer  ;** show case buffer
          msg_level    ;** what the last msg_level  
          sizefn       ;** size of a numeric field
          on1          ;** simple position counter 
          on2          ;** simple position counter 
          on3)         ;** simple position counter

      (string line     ;** read a line
              field    ;** field name
              typef    ;** field type
              sizef    ;** character size of field
              filea        ;*** name of the file 
              fileb        ;*** if to be printed the file with ".lst" 
              filec        ;*** display purposes only 
              filev        ;*** verify file
              path         ;*** the path 
              driveq       ;*** the drive
              temp         ;*** a unique variable
              )
         (global
                 field     ; field description
                 typef     ; type field
                 sizef     ; size field
                 sizefn    ; numeric size field
                 procnum   ; procedure number
                 this_buffer ;current buffer
                 show_buffer ;show buffer
                 dev_buffer) ;development buffer
        (pause_on_error)
        (= show_buffer 1)
        (= dev_buffer 1)
        (= this_buffer 1)
         ;** get the file name
         (if (get_parm NULL filea "Enter .dbf for Develop please: " 9)
           (
                 (inq_names path)
                 (= driveq(substr path 1 2))
                 (= flen (- (strlen filea) 1))
                 (= filea (+ (upper (substr filea 1 1)) (substr filea 2 flen )))
                 (= filec (+ filea ".Dbf"))
                 (= fileb (+ filea ".lst"))
                 (= fileb (+ driveq fileb))
                 (= filea (+ filea ".dbf>&"))
                 (= filea (+ filea fileb))
               (message "Creating %s Variables ..........." filec)
               (= filea (+ driveq filea))
               (= filev (+ driveq filec))
               (if (! (exist filev))
                   ;** check to make sure the file exists
                   (
                     (beep)
                     (message "Sorry boss ...... no such .dbf")
                   )
               ;* other wise it exists
                 (
                 (if (exist fileb)
                     (del fileb)
                  )
                  (save_position)
                  (= this_buffer (inq_buffer))
         	   	(= msg_level (inq_msg_level))	
         		   (set_msg_level 3)					
                  (dos (+ "dispstru " filea ))
                  (= this_buffer (inq_buffer))
                  (= dev_buffer (create_buffer "data base" fileb 1))
                  (= show_buffer (create_buffer "Variables" NULL 1))
               (create_window 38 15 76 3 "Variable Developer")
               (set_buffer show_buffer)
               (attach_buffer show_buffer)
               (top_of_buffer)
               (inq_position rowb colb)
               (mark)
               (end_of_buffer)
               (delete)
               (refresh)
               (_loadfile)
                  ;* prepare the area
         		   (set_msg_level 0)					
                  (message "Creating memory variables")
         		   (set_msg_level 3)					
                  (beginning_of_line)
                  (insert "** Memory Variables from " )
                  (insert filec)
                  (insert "\n")
                  (set_buffer dev_buffer)
                  (search_fwd "Total " )
                  ;** find out how many fields there are
                  (inq_position counter 0)
                  (= counter (- counter 6))
                  ;** set up recount to reset counter
                  (= recount counter)
                  (move_abs 6 1)
                  ;** moves to first field
                  (= procnum 3)
                  ;** procnum is a procedure # .... a bit like Case,in this case
                  (while (>= procnum 1)
                     (
                     (= doit 1)
                     (while (>= counter 1)
                            (
                             (set_buffer dev_buffer)
                             (beginning_of_line)
                             (= line (read 46))
                             (= field (substr line 8 12))
                             (= on1 (- (index field " ") 1))
                             (= field (+ (substr field 1 1) (lower(substr field 2 on1))))
                             (= typef (substr line 20 1))
                             (= on2 34)
                             (= on3 2)
                             (if (== (substr line 34 1) " ")
                              (
                              (= on2 35)
                              (= on3 1)
                              )
                             )
                             (= sizef (substr line on2 on3))
                             (= sizefn (atoi sizef 1))
                             (if (== procnum 3)
                                (
                                ;* do the mem store stmts
                                  (if (!= typef "N")
                                      (_loadfile)
                                  )
                                  (_memstore)
                                  (set_buffer dev_buffer)
                                  (= counter (- counter 1))
                                )
                             )
                             (if (== procnum 2)
                                (
                                ;* do the field store stmts
                                  (_loadfile)
                                  (if (== doit 1)
                                     (
                                		   (set_msg_level 0)					
                                      (message "Creating Fields -> memory variables")
                              		   (set_msg_level 3)					
                                      (insert "\n")
                                      (insert "** Fields -> mem variables for ")
                                      (insert filec)
                                      (insert "\n")
                                      (= doit 0)
                                      )
                                   )
                                  (_memfield)
                                  (set_buffer dev_buffer)
                                  (= counter (- counter 1))
                                )
                             )
                             (if (== procnum 1)
                                (
                                ;* do the replace field store stmts
                                  (_loadfile)
                                  (if (== doit 1)
                                     (
                              		   (set_msg_level 0)					
                                      (message "Creating Replace Fields -> memory variables")
                              		   (set_msg_level 3)					
                                      (insert "\n")
                                      (insert "** Replace Fields -> mem variables for ")
                                      (insert filec)
                                      (insert "\n")
                                      (= doit 0)
                                      )
                                   )
                                  (_repfield)
                                  (set_buffer dev_buffer)
                                  (= counter (- counter 1))
                                )
                             )
                             (down)
                             (beginning_of_line)
                       )
                    )      ; end of counter routine
                    (= procnum (- procnum 1))
                    (move_abs 6 1)
                    ;** reposition cursor and counter
                    (= counter recount)
                  )
                 )         ; end of procnum routine
               (delete_buffer dev_buffer)
               (set_buffer show_buffer)
               (end_of_buffer)
               (inq_position rowe cole)
               (_bloadfile)
               (transfer show_buffer rowb colb rowe cole)
               (restore_position)
               (delete_window)
               (delete_buffer show_buffer)
       		   (set_msg_level msg_level)
               (message "Done!")
               )
             )    ;* end of if the file didn't exist
        )
       )  ;* end of if the file name was entered or esc pressed 
 )
)
(macro _loadfile
      (
       (set_buffer show_buffer)
       (attach_buffer show_buffer)
       (edit_file show_buffer)
       (refresh)
     )
)
(macro _bloadfile
      (
       (set_buffer this_buffer)
       (attach_buffer this_buffer)
       (edit_file this_buffer)
       (refresh)
     )
)

(macro _memstore
       (
          ;* numeric data type
            (if (== typef "N")
               (
                (set_buffer dev_buffer)
                (_ntype)
               )
             )
             ;* character type data 
             (if (== typef "C")
                (
                 (insert "STORE SPACE(")
                 (insert sizef)
                 (insert ") TO m")
                 (insert field)
                 (insert "\n")
                 )
             ;*else

             )
             ;* date type
             (if (== typef "D")
                (
                (insert "STORE CTOD([  /  /  ])  TO m")
                (insert field)
                (insert "\n")
                )
             )
    (refresh)
    )
 )
(macro _memfield
     (
       (insert "STORE ")
       (insert field )
       (insert "TO m")
       (insert field )
       (insert "\n")
       (refresh)
    )
)

(macro _repfield
    (
       (insert "REPLACE ")
       (insert field )
       (insert "WITH m")
       (insert field )
       (insert "\n" )
       (refresh)
    )   
)
(macro _ntype
     (
       (string sizedec)
       (int dec
            on2n
            on3n
            sizedecn
            sized)
       (= dec 0)
       (= on2n 42)
       (= on3n 2)
       (move_abs 0 42)
       (if (!= (read 2) "  ") ;* check for decimal
          (
             (= dec 1)
             (if (== (read 1) " ")  ;* less than 10 decimal.
                (
                 (= on2n 43)
                 (= on3n 1)
                 )
              )
              (move_abs 0 on2n)
              (= sizedec (read on3n))
              (= sizedecn (atoi sizedec 1))
              (= sizefn (- sizefn sizedecn))
              (= sizefn (- sizefn 1))
           )
        )
       (_loadfile)
       (insert "STORE ")
       (= sized  sizefn )
       (while (> sized 0)
          (
           (insert "0")                                
           (= sized (- sized 1))
          )
       )
       (if (== dec 1)
          (
          (insert ".")
           (while (> sizedecn 0)
              (
               (insert "0")                                
               (= sizedecn (- sizedecn 1))
              )
            )
        )
      )
      (insert " TO m")
      (insert field)
      (insert "\n")
   )
)
