*********************************************************************
*
*   Demo.Prg    -   Demo Program for Bp_Label Library
*
*   Copyright (C) 1991 - Business Programming & Systems (BPS)
*                        Del Texley
*
*
/*  This program demostrates some of the capabilities of the Bp_Label
    library.  It is provided for the express purpose of allowing the
    purchaser to have some examples of how to use the functions provided
    in the library.  This program is not released into the public domain
    and may not be copied or distributed without the express written
    permission of either BPS or Del Texley

    Now that that's out of the way on to the rest of things.  This program
    will give examples of how to use the functions in the Bp_Label library.
    The amount of time I can invest in this is limited so it is fairly
    sketchy.  I usually have a fairly exhaustive user-definable color sheme
    but have not implemented for this program.  None of the sub-routines change
    the color set, and always restore the screen to its original contents
    unless explicitly noted otherwise.

*/

#include 'bp_label.ch'      && This file contains the command redefinition
                            && for the LABEL FORM command.  If you want to
                            && print barcodes with the standard .LBL files
                            && this file must be #included in the appropriate
                            && file

#include 'box.ch'
#include 'inkey.ch'
#include 'set.ch'

MEMVAR getlist          // Stupid! Should be in Std.ch

STATIC cprintername := 'EPSON'

FUNCTION main
LOCAL cmd := 1, tpprint

SET( _SET_SCOREBOARD, .F. )
SET( _SET_WRAP, .T. )

DO WHILE cmd > 0
    @  0,  0, 24, 79 BOX B_DOUBLE + CHR(177)
    @  2, 27,  4, 51 BOX B_SINGLE + ' '
    BP_CENTER( 3, 'Bp_Label Demo Program' )
    @  6, 24, 14, 55 BOX B_DOUBLE + ' '
    Bp_Center( 14, 'Bar:' + cPrinterName )
    @  8, 29 PROMPT 'Create New Label File '
    @  9, 29 PROMPT 'Edit A Label File     '
    @ 10, 29 PROMPT 'Print Labels          '
    @ 11, 29 PROMPT 'Select Printer Type   '
    @ 12, 29 PROMPT 'X Exit Program        '

    MENU TO cmd
    DO CASE
    CASE cmd == 1
        Label_Add()
    CASE cmd == 2
        Label_Change()
    CASE cmd == 3
        Label_Print()
    CASE cmd == 4
        tpprint := PADR( cprintername, 10 )
        @ 23, 20 SAY 'Enter Printer Name:' GET tpprint PICT '@K@!' VALID;
            ASCAN( { 'IBMPRO', 'TOSHIBA', 'EPSON', 'EPSONLQ', 'CITOH',;
                'PCL4', 'HPLJ', 'OFF' }, TRIM(tpprint) ) > 0
        READ
        IF !(LASTKEY() == K_ESC)
            cPrinterName := TRIM( tpprint )
        ENDIF
    OTHERWISE
        cmd := 0
    ENDCASE
ENDDO

RETURN( NIL )

*********************************************************************
*   This function creates a new .LBL File.  Notice that you must open
*   the databases in order for the program to verify the syntax!
*
*********************************************************************
FUNCTION label_add
LOCAL cLabelFile := SPACE(8)
LOCAL scrn := SAVESCREEN( 4, 0, 24, 79 )

USE demo

@ 20, 10, 24, 69 BOX '         '
DO WHILE EMPTY( cLabelFile ) .OR. FILE( TRIM(cLabelFile) + '.LBL' )
    @ 22, 15 SAY 'Enter Label File Name:' GET cLabelFile PICT '@A'
    READ
    IF LASTKEY() == K_ESC
        RETURN(NIL)
    ENDIF
ENDDO

@ 20, 10, 24, 69 BOX REPLICATE( '', 8 )

// Set your colors here

demo->(Bp_Add_Label( cLabelFile ))

RESTSCREEN( 5, 0, 24, 79, scrn )

CLOSE DATABASES

RETURN( NIL )

***********************************************************************
* This function allows the editting of an existing .LBL file.  All
* databases that you wish to use in the labels must be openned before
* calling the label functions.
***********************************************************************
FUNCTION label_change
LOCAL aLabel := {}, cLabelFile, x
LOCAL scrn := SAVESCREEN( 4, 0, 24, 79 )

cLabelFile := BP_PICKLABEL()    // Function shows a popup menu of all the
                                // .LBL files in the current directory and
                                // the remarks contained within

IF '' == TRIM( cLabelFile )     // No file selected, Exit
    RETURN( NIL )
ENDIF

USE demo

// Set your Colors Here!

demo->(Bp_Edit_Label( cLabelFile ))

RESTSCREEN( 4, 0, 24, 79, scrn )
CLOSE DATABASES

RETURN( NIL )

***********************************************************************
*  This function actually prints the labels by calling the print
*   routines included in the library
***********************************************************************
FUNCTION label_print
LOCAL cLabelFile, bQuery, whatprinter := ' '
LOCAL scrn := SAVESCREEN( 4, 0, 24, 79 )

// Set your Colors Here!
cLabelFile := BP_PICKLABEL()    // Function shows a popup menu of all the
                                // .LBL files in the current directory and
                                // the remarks contained within

RESTSCREEN( 4, 0, 24, 79, scrn )

IF '' == TRIM( cLabelFile )     // No file selected, Exit
    RETURN( NIL )
ENDIF

@ 19, 20, 23, 59 BOX B_SINGLE + ' '
DO WHILE !(whatprinter $ 'DL')
    @ 21, 27 SAY '<D>ot Matrix or <L>aser:' GET whatprinter PICT '@!' VALID whatprinter $ 'DL'
    READ
    IF LASTKEY() == K_ESC
        RETURN(NIL)
    ENDIF
ENDDO

@ 19, 10, 23, 69 BOX REPLICATE( '', 8 )
USE demo

PO_SETUP( cPrinterName )        // Don't forget to tell the barcode routine
                                // what type of printer to expect...

IF whatprinter == 'L'
    bQuery := { || .T. }    // This is a Filter string expressed as a code block
                            // it can be anything your heart desires, it is
                            // equivalent to the FOR command in the LABEL FORM

    Bp_LaserSetup( 'N' )   // Setup Laser Printer, The 'N' designates 10 cpi
                            // rather that 16.67. This later will include
                            // methods for selecting other label formats and
                            // barcode modes as they are needed.

    Bp_LaserLbl( cLabelFile, bQuery )   // Prints Labels in Avery 5162 1" x 2 5/8" 30
                            // Labels per page.  Future versions will support
                            // multiple label formats from Avery, 3M, and others.
    EJECT
ELSE
    @ 24, 0 SAY ''
    LABEL FORM (cLabelFile) SAMPLE TO PRINT WHILE !(INKEY(.1) == 27)
ENDIF

CLOSE DATABASES

RETURN( NIL )

