// oMsgBox.prg - Written By Kurt R. Hoehn 11/04/93
//               Update 11/05/93

#include "xBox.ch"

CREATE CLASS oMsgBox FROM oBox
   PROTECTED:
   
      VAR MsgAstring TYPE array

   EXPORT:
      VAR MsgLength
      VAR MsgBoxWidth

      METHOD init
      METHOD MsgShow
      METHOD MsgWrap

END CLASS

METHOD init( cString, nWidth, nTop, nLeft, nBottom, nRight, ;
             cStyle, nCursor, cColor, lShadow ), ( nTop, nLeft, nBottom, ;
             nRight, cStyle, nCursor, cColor, lShadow )
   local nLength := 0  

   ::MsgAstring := ::MsgWrap( cString, nWidth )
   aEval( ::MsgAstring, { |elem| nLength := max( nLength, len(elem) ) } )

   ::MsgLength   := nLength
   ::MsgBoxWidth := nWidth
   ::BoxBottom   := ::BoxTop + len( ::MsgAstring ) +1
   ::BoxRight    := ::BoxLeft + ::MsgBoxWidth + 1
RETURN self
  
   
METHOD MsgWrap( cString, nWidth )   
   local nLines := mlcount( cString, ( nWidth-2 ) ) 
   local aLines := array(nLines), nLineNum

   for nLineNum := 1 to nLines 
      aLines[ nLineNum ] := trim( memoline( cString, ( nWidth-2 ), nLineNum ) )
   next
RETURN aLines

METHOD MsgShow
   local ncol := round( ::BoxCenter() - ( ::MsgLength / 2 ), 0 )
   ::BoxShow()
   aeval( ::MsgAstring, {|elem, n| setpos(::BoxTop+n, nCol), qqout( elem )} )
RETURN self




