// oBox.prg - Written By Kurt R. Hoehn 11/03/93

#include "xbox.ch"

CREATE CLASS oBox
   VAR BoxShowShadow
      
   METHOD BoxShadow
   
   PROTECTED: 
      CLASS VAR oBoxStack
      MESSAGE oBoxStack TO CLASS

      VAR BoxEnv
      VAR BoxCursor

   EXPORT:
      VAR BoxTop, BoxLeft      READONLY
      VAR BoxBottom, BoxRight  READONLY
      VAR BoxStyle             READONLY
      VAR BoxColor             READONLY

      METHOD init
      METHOD BoxShow
      METHOD BoxHide
      METHOD BoxCenter

      CLASS METHOD initClass

END CLASS

METHOD initClass
   ::oBoxStack := oStack():New()
RETURN self

METHOD init( nTop, nLeft, nBottom, nRight, cStyle, nCursor, ;
             cColor, lShadow ), ()

   DEFAULT cColor  TO setcolor(), ;
           cStyle  TO B_DOUBLE, ;
           nCursor TO setcursor(0),;
           lShadow TO FALSE

   ::BoxTop        := nTop
   ::BoxLeft       := nLeft
   ::BoxBottom     := nBottom
   ::BoxRight      := nRight
   ::BoxColor      := cColor
   ::BoxStyle      := cStyle
   ::BoxShowShadow := lShadow
   ::BoxCursor     := nCursor
   ::BoxEnv        := oEnv():new()
RETURN self

METHOD BoxShow   
   ::BoxEnv:SaveEnv( ::BoxTop, ::BoxLeft, ::BoxBottom, ::BoxRight, ;
                     ::BoxShowShadow )

   IF ::BoxShowShadow THEN ::BoxShadow()

   setcolor( ::BoxColor )
   setcursor( ::BoxCursor )
   
   @ ::BoxTop, ::BoxLeft, ::BoxBottom, ::BoxRight box ::BoxStyle + " "
   
   ::oBoxStack:push(self)
RETURN self

METHOD BoxHide
   ::oBoxStack:pop( ::BoxEnv:RestEnv() )
RETURN self

METHOD BoxCenter()
RETURN (::BoxRight - ::BoxLeft)/2 + ::BoxLeft

METHOD BoxShadow   
   RestScreen( ::BoxTop +1, ::BoxLeft +1, ::BoxBottom +1, ::BoxRight +2,     ;
      Transform( SaveScreen(::BoxTop +1, ::BoxLeft +1, ::BoxBottom +1,       ;
         ::BoxRight +2 ), Replicate("X" + Chr(7), Len(SaveScreen(::BoxTop +1,; 
             ::BoxLeft +1, ::BoxBottom +1, ::BoxRight +2)) )))
RETURN self



   
