// oEnv.prg  - Written by Kurt R. Hoehn 11/03/93

#include "xbox.ch"

CREATE CLASS oEnv
   VAR shape
   VAR buffer

   EXPORT:
      VAR top, left
      VAR bottom, right
      VAR row, col
      VAR color

      METHOD init
      METHOD SaveEnv
      METHOD RestEnv

ENDCLASS

METHOD init(), ()
RETURN self

METHOD SaveEnv( nTop, nLeft, nBottom, nRight, lShadow )
   DEFAULT  nTop    TO 0, ;
            nLeft   TO 0, ;
            nBottom TO maxrow(), ;
            nRight  TO maxcol(), ;
            lShadow TO FALSE

   ::row    := row()
   ::col    := col()
   ::color  := setcolor()
   ::shape  := setcursor()
   ::top    := nTop
   ::left   := nLeft
   ::bottom := iif( lShadow .or. nBottom < maxrow() -1, nBottom +1, nBottom )
   ::right  := iif( lShadow .or. nRight < maxcol() -2, nRight +2, nRight )
   ::buffer := savescreen( ::top, ::left, ::bottom, ::right, ::buffer )
RETURN self
  
METHOD RestEnv()
   setpos( ::row, ::col )
   setcolor( ::color )
   setcursor( ::shape )
   restscreen( ::top, ::left, ::bottom, ::right, ::buffer )
RETURN self
