/* shadow.c

   Written by Jon Cole
   Modified by Tom Leylan
   and used with permission from the author

   distribute freely with this header intact

   QuickC : QCL /AL /Zl /Gs /c shadow.c
*/

#include <extend.h>
#include <dos.h>

#define VIDEO_MODE    *(char far *)0x00400049
#define MONO_MODE     0x07
#define COLOR_PTR     0xB8000000
#define MONO_PTR      0xB0000000
#define GREY_ON_BLACK 0x07

CLIPPER Shadow()
{
   char far *cpScrn;
   unsigned int iOffSet, iTop, iLeft, iBottom, iRight, iMaxR, iMaxC;
   unsigned int iLoLeft, iLoRight, iUpRight;

   /* Depending on the adapter installed, set starting address */
   cpScrn = ( char far *)(VIDEO_MODE == MONO_MODE ? MONO_PTR : COLOR_PTR);

   /* Adjust parameters received from Clipper */
   iTop    = _parni(1) + 1;
   iLeft   = _parni(2) + 1;
   iBottom = _parni(3) + 1;
   iRight  = _parni(4) + 1;

   if ( _parinfo(0) == 6 )
   {
      iMaxR   = _parni(5) + 1;
      iMaxC   = _parni(6) + 1;
   }

   else
   {
      iMaxR   = 25;
      iMaxC   = 80;
   }

   iUpRight = (((iTop * 80) + iRight) * 2) + 1;
   iLoRight = (((iBottom * 80) + iRight) * 2) + 1;
   iLoLeft  = (((iBottom * 80) + iLeft) * 2) + 1;

   /* make sure we're on the screen */

   if( (iRight < iMaxC) )
      {
      /* shadow to the right of box */
      for( iOffSet = iUpRight; iOffSet <= iLoRight; iOffSet += 160)
         *(cpScrn + iOffSet) = GREY_ON_BLACK;
      }

   if( (iBottom < iMaxR) )
      {
      /* shadow below the box */
      for( iOffSet = iLoLeft; iOffSet <= iLoRight; iOffSet += 2)
         *(cpScrn + iOffSet) = GREY_ON_BLACK;
      }

   _ret();

   return;
}

