******************* GUIDE **********************
* Author...: Jerry Gilmore
* BBS......: (603) 352-7919
* Date.....: 06/03/88
* Generated: 8-25-88 by UI Programmer version 2 beta 2, Wallsoft Systems
* Template.: AP_CLBRW.TEM
* UI screen: GUIDE.WW
* Notice...: Template structure Copyright 1988, Jerry Gilmore
* Compiler.: Clipper Summer '87
* Note.....: Displays 18 records in the window big enough to accomidate
*            the entire record. The up and Down arrows highlight the next or
*            previous record. The record pointer is moved accordingly.
*            Keys: Home - Go to top of file
*                  End  - Go to bottom of file
*                     - Go to Next/Previous record
*                  PgUp - Go to previous page ({scrollcnt} lines)
*                  PgDn - Go to next page ({scrollcnt} lines)
*
*            Keys while in expand mode:
*                grey '-' - moves to the previous help screen
*                     '+' - moves to the next help screen
*                    Home - Go to top of screen
*                       - Scroll text donw/up 1 line
*                    PgUp - Go to previous page
*                    PgDn - Go to next page
*
*            The browsing is a kludge that works ok while using memo_disp().
*            Eventualy, it will be modified to handle scrolling like memoedit()
*            does.
private mSCRN
public lite_ptr, rec_cnt
public del_cnt
del_cnt = 0    && Set delete record(s) flag to 0

*------------------------------------------------------------*
*                I N I T   D B F   F I L E S                 *
*     Open all dbfs and create indexes if not there.         *
*------------------------------------------------------------*
use BMATE.HLP
if ! file("bmate.ntx")
   index on upper(screen) to bmate
endif
set index to bmate
do funval

del_cnt = 0             && Delete count flag
if iscolor()
   * These colors may be changed to the colors you prefer.
   * Keep in mind that if the user has a color graphics board, but a monochrome
   * monitor, color won't work well.
   F_COLOR = "BG+/B"  && Frame Color              (BG+/B)
   att = 1
   H_COLOR = "BG+/B"  && Unselected Record Color  (N/W)
   M_COLOR = "BG+/B"  && Menu Color               (BG+/B)
   S_COLOR = "R/W"    && Special Message Color    (R/W)
   A_COLOR = "RG+/W"  && Selected Record Color    (RG+/W)
else
   * These colors should be left the way they are for monochrome.
   F_COLOR = "W+/N"  && Frame Color
   att = 0
   H_COLOR = "W/N"   && Unselected Record Color
   M_COLOR = "W/N"   && Menu Color
   S_COLOR = "W/N"   && Special Message Color
   A_COLOR = "N/W"   && Selected Record Color
endif
save screen to mSCRN

select 1
* Display main screen
set cursor off
clear
@ 1,0,22,79 BOX "ͻȺ "
@ 3,0 say ""
@ 3,79 say ""
@ 3,1 say replicate("",78)
@ 2,30 say "Library Functions"
* Display all memvars
rec_cnt = reccount() && Get record count
scrollcnt = 17
goto top
set color to &H_COLOR
lite_ptr = 0
do while (.not. eof()) .and. (lite_ptr <= scrollcnt)
   do sayrecord
   lite_ptr = m->lite_ptr + 1
   skip
enddo

go top              && reset record pointer
lite_ptr = 0        && Cursor Pointer
* Reverse Highlite
set color to &A_COLOR
do sayrecord
do while .t.
   set color to &M_COLOR
   @ 24,0 clear
   @ 24,0 say "  Next/Prev   Return - Expand  S)earch  Q)uit "
   key = asc(upper(chr(inkey(0)))) && Get command from keyboard
   do case
   case m->key == 13               && return
      save screen to mSCRN
      ptr = 1
      ptr2 = 1
      fflag = .f.
      @ TOP,LEFT TO BOT,RIGHT DOUBLE
      @ BOT,LEFT + 2 say " Esc - Return "
      mmsg = MESSAGE
      do while .t.
         memo_disp(substr(mmsg,ptr),TOP+1,LEFT+1,BOT-1,RIGHT-1)
         mINKEY = kbd_scan(0)
         do case
         case mINKEY = 71  && Home
            ptr = 1
         case mINKEY = 80  && Down arrow
            ptr2 = at(chr(13),substr(mmsg,ptr))  && find next <CR>
            if ptr2 > 0
               ptr = ptr + ptr2
            endif
         case mINKEY = 72  && Up arrow
            ptr2 = rat(chr(13),substr(mmsg,1,ptr))  && Find previous <CR>
            if ptr2 > 0
               ptr = ptr2 - 1
            endif
         case mINKEY = 73  && Page up
            for x = 1 to 15
            ptr2 = rat(chr(13),substr(mmsg,1,ptr))  && Find previous <CR>
            if ptr2 > 0
               ptr = ptr2 - 1
            endif
            next
         case mINKEY = 81  && PgDn
            for x = 1 to 15
            ptr2 = at(chr(13),substr(mmsg,ptr))  && find next <CR>
            if ptr2 > 0
               ptr = ptr + ptr2
            endif
            next
         case mINKEY = 78  && Grey +
            skip
            mmsg = MESSAGE
            ptr = 1
            fflag = .t.  && set fill screen flag
         case mINKEY = 74  && Grey -
            skip -1
            mmsg = MESSAGE
            ptr = 1
            fflag = .t.  && set fill screen flag
         case mINKEY = 1
           clear typeahead
           exit
         endcase
      enddo
      restore screen from mSCRN
      if fflag
         mlst_rec = recno()
         do fillwindow
         set color to &A_COLOR
         lite_ptr = 0
         goto m->mlst_rec
         do sayrecord
      endif
   case m->key == 1                && Home
      goto top
      do fillwindow
      lite_ptr = 0
      goto top
      set color to &A_COLOR
      do sayrecord
   case m->key == 3                && PgDn
      skip scrollcnt + m->lite_ptr
      mlst_rec = recno()
      do fillwindow
      set color to &A_COLOR
      lite_ptr = 0
      goto m->mlst_rec
      do sayrecord
   case (m->key == 5) .and. (.not. bof())  && Up Arrow
      do sayrecord      && Re-display current record
      skip -1           && Point to previous record
      if .not. bof()
          lite_ptr = m->lite_ptr - 1  && Move highlite pointer up
          if m->lite_ptr < 0
              * Scroll window down
              window(att,1,1,4,1,4 + scrollcnt,78)
              m->lite_ptr = 0
          endif
      endif
      set color to &A_COLOR  && Reverse Highlite
      do sayrecord
   case m->key == 6                && End
      goto bottom
      skip -1* scrollcnt
      do fillwindow
      set color to &A_COLOR  && Reverse Highlite
      do sayrecord
   case m->key == 18               && PgUp
      skip -1 * scrollcnt - lite_ptr
      mlst_rec = recno()
      do fillwindow
      set color to &A_COLOR  && Reverse Highlite
      lite_ptr = 0
      goto m->mlst_rec
      do sayrecord
   case m->key == 83               && Seek
      @ 24,0 clear
      mSEEK = space(len(screen))
      set cursor on
      @ 24,5 say "Search for:" get m->mSEEK
      read
      set cursor off
      if empty(mSEEK)
         loop
      endif
      do SEEK_REC with upper(m->mSEEK)
   case (m->key == 24) .and. (.not. eof())  && Down Arrow
      do sayrecord      && Display old record
      skip 1            && Point to next record
      if eof()
         skip -1
      else
         lite_ptr = m->lite_ptr + 1  && Move highlite pointer down
         if m->lite_ptr > scrollcnt
            * Scroll window up
            window(att,0,1,4,1,4+scrollcnt,78)
            lite_ptr = scrollcnt
         endif
      endif
      set color to &A_COLOR  && Reverse Highlite
      do sayrecord
   case m->key == 28               && HELP
     * do HELP with "GUIDE","0","KEY" && HELP can't be invoked from inkey()
   case m->key == 81               && Quit
      set cursor on
      return
   endcase
enddo
*------------------------------------------*
*     P R O C E D U R E   S E C T I O N    *
*------------------------------------------*
******************* SEEK_REC ***************
proc SEEK_REC
parameter mtSEEK
private mlst_rec, ans
mlst_rec = recno()
mtSEEK = trim(m->mtSEEK)
seek m->mtSEEK
if found()
   mlst_rec = recno()      && Save current record position
   do fillwindow           && Fill window with records
   lite_ptr = 0
   goto m->mlst_rec        && Go back to last record
   set color to &A_COLOR   && Highlite color
   do sayrecord
endif
RETURN

******************* FILLWINDOW *********************
procedure fillwindow
* Starting at top of scroll window, display enough records to fill area.
lite_ptr = 0
window(att,0,0,4,1,4+scrollcnt,78)
set color to &H_COLOR
do while lite_ptr <= scrollcnt
   do sayrecord
   skip
   if eof()
      skip -1
      exit
   else
      lite_ptr = m->lite_ptr + 1
   endif
enddo
return

******************* SAYRECORD *********************
PROCEDURE SAYRECORD
* Display 1 record at current lite pointer location.
* Display all fields
  @ 4 + m->lite_ptr , 1 say screen
  @ 4 + m->lite_ptr , 23 say descript
return
