/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Eliminates duplicate records from a database file
//
// Syntax:
//    C> ELIDUP [<cFile> [<cExpr>]]
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cFile       Database file name
//    cExpr       Expression for indexing and duplication check
//
// Files:
//    (<cFile>.dbf[/t])
//    (unique index file name)
//
// Description:
//    Eliminates duplicate records from a database file.  <cExpr> is the
//    index expression, and defines s duplicate record.
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION EliDup(cFilename, cDupExpr)
   LOCAL aRC, cOld := Chr(255), cTemp, nCount := 0
   fSaveRecord()
   vCursSave()
   cDupExpr  := iif(cDupExpr=NIL, Space(200), sSetLength(cDupExpr, 200))
   cFilename := iif(cFilename=NIL, Space(64), sSetLength(cFilename, 64))
   vSave(2, 70)
   aRC := vWindow(2, 70, .y., "")
   @ aRC[1], aRC[2] say "Filename ..............." get cFilename picture "@!K"
   @ Row()+1, aRC[2] say "Duplicate expression ..." get cDupExpr
   READ
   vRestore()
   vMessageOn("Creating temporary index...")
   USE (cFilename := Trim(cFilename)) EXCLUSIVE NEW
   INDEX on (cDupExpr := Trim(cDupExpr)) to (cTemp := fUnique())
   vMessageOff()
   vMessageOn("Eliminating duplicate records")
   GO TOP
   vSave(MaxRow())
   @ MaxRow(), 0
   WHILE !eof()
      cTemp := &(cDupExpr)
      @ MaxRow(), 6 say cTemp
      IF cTemp=cOld
         nCount++
         @ MaxRow(), 0 say nCount picture "9,999"
         DELETE
      ENDIF
      cOld := cTemp
      SKIP
   ENDWHILE
   vRestore()
   vMessageOff()
   vCursRest()
   CLOSE
   fRestoreRecord()
ENDFUNCTION
