/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

* Find & Replace Global File Fixer
#define False .n.
#define True .y.

Static lIgnoreCase := False, cFind, cReplace, cFile := '*.PRG'

////////////////
////////////////
//
// Purpose:
//    Global file find & replace utility
//
// Syntax:
//    C> FINDREPL [<cOpt1> [<cOpt2> [<cOpt3> [<cOpt4>]]]]
//
// Formal Arguments: (4)
//    Name        Description
//    ___________ ____________
//    cOpt1       Optional parameters, see description
//    cOpt2       Optional parameters, see description
//    cOpt3       Optional parameters, see description
//    cOpt4       Optional parameters, see description
//
// Description:
//    Finds and replaces strings in one or more files.  Possible command line
//    options include /I to ignore case, /F<string> to define the string to
//    find, /R<string> to define the replacement string and /N<name> to define
//    the file name, which may be a wild card specification.  If no /F
//    parameter is passed, then this program looks for a file called
//    FINDREPL.TXT, which contains one or more find/replace definitions.  Each
//    line in FINDREPL.TXT is of the format:
//
//          "<cFind>" "<cReplace>"
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fFindRepl(cOpt1, cOpt2, cOpt3, cOpt4)
   LOCAL lUseFile := False, aFile, SysVersion := '1.1', BakFile, cCheck, nCounter
   LOCAL cTemp, cTemp2, nCtr, hnewfile
   FIELD cText
   ? 'Find & Replace Global File Fixer v'+SysVersion
   ? 'Copyright (c)1990 John Wm Beckner - All Rights Reserved'
   IF PCount()>=1
      SetOption(cOpt1)
   ENDIF
   IF PCount()>=2
      SetOption(cOpt2)
   ENDIF
   IF PCount()>=3
      SetOption(cOpt3)
   ENDIF
   IF PCount()>=4
      SetOption(cOpt4)
   ENDIF
   IF Empty(cFind) .or. Empty(cReplace)
      IF !File('FINDREPL.TXT')
         ? 'Invalid Parameters'
         Quit
      ENDIF
      lUseFile := True
      fCreateDBF('TempIn/cLook/C/254/cChange/C/254')
      USE TempIn New
      APPEND FROM FindRepl.Txt delimited
   ENDIF
   aFile := Directory(cFile)
   fCreateDBF('Temp/cText/C/254')
   USE Temp new
   CLS
   @ 1,0 say 'Find & Replace Global File Fixer v'+SysVersion
   @ 2,0 say 'Copyright (c)1990 John Wm Beckner - All Rights Reserved'
   @ 4,0 say 'Current file:'
   @ 5,0 say '     Change #'
   cFind    := Trim(lTrim(cFind))
   cReplace := Trim(lTrim(cReplace))
   FOR nCtr := 1 to len(aFile)
      @ 4,14 say aFile[nCtr,1]
      nCounter := 0
      SET COLOR to i*
      @ 24,0 say '*READING*'
      APPEND FROM (aFile[nCtr,1]) sdf
      SET COLOR to
      @ 24,0 say space(9)
      IF lUseFile
         SELECT TempIn
         GO TOP
         WHILE !eof()
            @ 5,14 say ++nCounter pict '9,999,999'
            SELECT Temp
            REPLACE all cText with strtran(trim(cText), alltrim(TempIn->cLook),;
            alltrim(TempIn->cChange))
            SELECT TempIn
            SKIP
         ENDWHILE
      ELSE
         REPLACE all cText with strtran(trim(cText), cFind, cReplace)
      ENDIF
      SELECT Temp
      BakFile := fExtNew(aFile[nCtr,1], "BAK")
      IF file(BakFile)
         ERASE (BakFile)
      ENDIF
      RENAME (aFile[nCtr,1]) to (BakFile)
      hNewFile := fcreate(aFile[nCtr,1])
      GO TOP
      WHILE !eof()
         fwrite(hNewFile,trim(cText)+CRLF)
         SKIP
      ENDWHILE
      fclose(hNewFile)
      ZAP
   NEXT
   CLOSE ALL
   ERASE Temp.dbf
   IF lUseFile
      ERASE TempIn.dbf
   ENDIF
   QUIT
ENDFUNCTION

////////////////
////////////////
//
// Purpose:
//    Sets the correct options from the command line parameters
//
// Syntax:
//    SetOption(<cOption>) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cOption     Option to set
//
// Returns:
//    NIL
//
// Files:
//    none
//
// Description:
//    Sets the command line options.
//
// Category:
//    Support Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

STATIC FUNCTION SetOption(cOption)
   LOCAL cChoice
   IF left(cOption,1)='/'
      cOption := substr(cOption,2)
   ENDIF
   cChoice := upper(left(cOption,1))
   cOption := substr(cOption,2)
   IF cChoice="I"
      lIgnoreCase := True
   ELSEIF cChoice="F"
      cFind       := cOption
   ELSEIF cChoice="R"
      cReplace    := cOption
   ELSEIF cChoice="N"
      cFile       := cOption
   ENDIF
ENDFUNCTION
