#include "beckner.inc"
#include "alias.ch"
#include "set.ch"
#include "inkey.ch"
#include "directry.ch"
#define  F_ALIAS 6

STATIC aFile := {}

FUNCTION Assist()
   LOCAL GetList := {}, cVersion := "0.1", nOption
   LOCAL lExclusive := Set(_SET_EXCLUSIVE, .n.)
   LOCAL lDeleted := Set(_SET_DELETED, .n.)
   LOCAL lScoreboard := Set(_SET_SCOREBOARD, .n.)
   SET KEY K_F9 TO pCtrlW
   SET KEY K_INS TO vInsCursor
   vSave()
   vCursSave()
   CLS
   vTitle({"Database File Assistance System",;
         "Version "+cVersion,;
         "Written by John Wm Beckner",;
         "Copyright (c)1992 BecknerVision Inc - All Rights Reserved"})
   vBackground(Chr(177))
   @ MaxRow(), 0
   @ MaxRow(), 0 SAY "DBF Assistant v"+cVersion+" (c)1992 BecknerVision Inc"
   WHILE LOOPING
      vSave()
      asstCurrent()
      nOption := vMenu("T/Load/File/Structure/Report/Maintenance/Exit")
      DO CASE
      CASE nOption=1
         asstLoad()
      CASE nOption=2
         asstFile()
      CASE nOption=3
         asstStructure()
      CASE nOption=4
         asstReport()
      CASE nOption=5
         asstMaint()
      CASE nOption=6
         EXIT
      ENDCASE
      vRestore()
   ENDWHILE
   CLOSE DATABASES
   Set(_SET_EXCLUSIVE, lExclusive)
   Set(_SET_DELETED, lDeleted)
   Set(_SET_SCOREBOARD, lScoreboard)
   vRestore()
   vCursRest()
ENDFUNCTION

STATIC FUNCTION asstFile()
   LOCAL nOption
   @ MaxRow(), 60 SAY "FILE"
   WHILE LOOPING
      nOption := vMenu("T/Open/Close/New/Relate/Index/Pack/Zap/Exit")
      DO CASE
      CASE nOption=1
         fileOpen()
      CASE nOption=2
         fileClose()
      CASE nOption=3
         fileNew()
      CASE nOption=4
         fileRelate()
      CASE nOption=5
         fileIndex()
      CASE nOption=6
         filePack()
      CASE nOption=7
         fileZap()
      CASE nOption=8
         EXIT
      ENDCASE
   ENDWHILE
ENDFUNCTION

STATIC FUNCTION fileOpen()
   GetFile()
ENDFUNCTION

STATIC FUNCTION fileClose()
   LOCAL nElement, nWorkArea
   nElement := aPickList(3, 20, Min(MaxRow()-2, Len(aFile)+2), 35,;
         a1From2(aFile, F_ALIAS), , "CLOSE WHICH?")
   IF nElement=0
      Alert("No files closed!")
   ELSE
      nWorkArea := Select()
      dbSelectArea(aFile[nElement, F_ALIAS])
      CLOSE
      aDel(aFile, nElement)
      SELECT (nWorkArea)
   ENDIF
ENDFUNCTION

STATIC FUNCTION GetFile(cWildcard)
   LOCAL aRC, cAlias, aList, nElement, GetList := {}
   DEFAULT cWildcard TO "*"
   cWildcard := fExtNew(cWildcard, "DBF")
   aList := Directory(cWildcard, "H")
   aSort2(aList)
   vSave()
   nElement := aPickList(3, 20, MaxRow()-2, 35, a1From2(aList, F_NAME), ,;
         "PICK A FILE")
   cAlias := sSetLength(fExtNone(aList[nElement, F_NAME]), 10)
   aRC := vWindow(1, 18, .y., "")
   @ aRC[1], aRC[2] SAY "Alias:" GET cAlias PICTURE "@K"
   READ
   vRestore()
   fShare(aList[nElement, F_NAME], Trim(cAlias))
   aAdd(aFile, aList[nElement, F_NAME])
   aAdd(aFile[Len(aFile)], cAlias)
   RETURN cAlias
ENDFUNCTION

STATIC FUNCTION asstCurrent()
   LOCAL nFiles
   nFiles := Len(aFile)
   IF Empty(aFile)
      RETURN NIL
   ENDIF
   @ 4, 6 CLEAR TO Min(MaxRow()-3, nFiles+2), 20
   @ 4, 6 TO Min(MaxRow()-3, nFiles+2), 20
   @ 4, 8 SAY " Current File"
   DevOut(iif(nFiles=1, " ", "s "))
   DevPos(4, 0)
   aEval(aFile, {|aEntry| DevPos(Row()+1, 8), DevOut(aEntry[F_ALIAS])})
ENDFUNCTION
