/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Utility program to index a file
//
// Syntax:
//    C> INDEX <cFile> <cIndex> <cExpr>
//
// Formal Arguments: (3)
//    Name        Description
//    ___________ ____________
//    cFile       Dbf name
//    cIndex      Ntx name
//    cExpr       Valid index expression.
//
// Files:
//    (<cFile>.dbf)
//    (<cIndex>.ntx)
//
// Description:
//    Utility program to create an index file for a database file.  Note that
//    you cannot use quote marks <"> in <cExpr>, as this is a violation of
//    DOS rules.  Use apostophes or square brackets instead where needed.
//
// See Also:
//    fCreateNtx()
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION Main(cFile, cIndex, cExpr)
   IF cFile=NIL
      ? "Syntax: INDEX <file> <indexfile> <expression>"
      ?
      QUIT
   ENDIF
   fShare(cFile)
   iif(File(fExtNew(cIndex, "NTX")), fKill(fExtNew(cIndex, "NTX")),)
   INDEX ON &(cExpr) TO (cIndex)
ENDFUNCTION
