/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "fileio.ch"
#include "inkey.ch"

STATIC nConfiguration, aPrompts := {}

FIELD cPrompt, cHelp, cBatch

FUNCTION pMenu()
   LOCAL cTemp, nOption, nChoice
   eSave()
   CLS
   vMessageOn("Initializing...")
   IF !fIsDir("\MENU")
      vMessageOff()
      vMessageOn("Creating \MENU")
      fMkDir("\MENU")
   ENDIF
   IF !file("\MENU\BVMENU.CFG")
      vMessageOff()
      vMessageOn("Creating default configuration file")
      nConfiguration := fCreate("\MENU\BVMenu.CFG")
      fWrite(nConfiguration, "BV  /  /  ")
      fClose(nConfiguration)
/*
   IF !fTestLine("\AUTOEXEC.BAT", "PATH", "Within", ";Menu")
      fModifyLine("\AUTOEXEC.BAT", "PATH", "Add", ";Menu")
      pSetEnv("PATH", pSetEnv("PATH")+";Menu")
   ENDIF
*/
   ENDIF
   nConfiguration := fOpen("\MENU\BVMenu.CFG", FO_READWRITE)
   cTemp := fReadStr(nConfiguration, 2)
   cTemp := fReadStr(nConfiguration, 8)
   IF ctod(cTemp)!=Date()
      vMessageOff()
      vTitle({"Beckner Menu System", "version 1.0", "---",;
            "Copyright (c)1991 BecknerVision Inc - All Rights Reserved",;
            "Written by John Wm Beckner"})
      vMessageOn("Initializing...")
      fSeek(nConfiguration, 2, FS_SET)
      fWrite(nConfiguration, DtoC(Date()))
   ENDIF
   fClose(nConfiguration)
   SET SCOREBOARD OFF
   SET KEY K_F1 TO Maint
   SET KEY K_F2 TO Dos
   SET KEY K_F9 TO DoIt
   SET KEY K_F10 TO ExitMenu
   IF !File("\MENU\BVMenu.DBF")
      cTemp := "\MENU\BVMenu/cPrompt/C/30/cHelp/C/80/cBatch/M"
      fCreateDBF(cTemp)
   ENDIF
   nConfiguration := fCreate("\MENU\Menu.Bat")
   fWriteLine(nConfiguration, "@echo off")
   fWriteLine(nConfiguration, "cls")
   fWriteLine(nConfiguration, "\MENU\pMenu")
   fWriteLine(nConfiguration, "Call \MENU\BVMenuGo")
   fWriteLine(nConfiguration, "\menu\Menu")
   fClose(nConfiguration)
   nConfiguration := fCreate("\MENU\BVMenuGo.Bat")
   fWriteLine(nConfiguration, "@echo off")
   fShare("\MENU\BVMenu")
   IF !File("\MENU\BVMenu.NTX")
      fCreateNTX("\MENU\BVMenu.NTX", "cPrompt")
   ELSE
      SET INDEX TO \MENU\BVMenu
   ENDIF
   vMessageOff()
   IF IsColor()
      SET COLOR to w/b, w+/br, , , w/br
   ENDIF
   CLS
   vBackground(Chr(177))
   IF IsColor()
      SET COLOR to w/b, w+/br, , , w/br
   ENDIF
   @ 0, 0
   @ MaxRow(), 0
   vCenter(80, 0, 0,;
         "Beckner Menu System - Copyright (c)1991 BecknerVision Inc")
   @ 0, 0 SAY Date()
   vCenter(80, MaxRow(), 0, "<F1> Maintenance    <F2> DOS    <F9> Go    <F10> Exit Menu")
   WHILE LOOPING
      aPrompts := {}
      dbEval({||aAdd(aPrompts, cPrompt)})
      IF Empty(aPrompts)
         Maint()
      ENDIF
      nChoice := aPickList(1, 20, MaxRow()-3, 59, aPrompts)
      IF nChoice=0
         LOOP
      ENDIF
      SEEK aPrompts[nChoice]
      MemoWrit("\MENU\BVMENUGO.BAT", cBatch)
      fClose(nConfiguration)
      CLS
      QUIT
   ENDWHILE
ENDFUNCTION

STATIC FUNCTION DoIt()
   KEYBOARD CR
ENDFUNCTION

STATIC FUNCTION ExitMenu()
   fClose(nConfiguration)
   nConfiguration := fCreate("\MENU\Menu.Bat")
   fWriteLine(nConfiguration, "@echo off")
   fWriteLine(nConfiguration, "cls")
   fWriteLine(nConfiguration, "\menu\pMenu")
   fWriteLine(nConfiguration, "@cls"+chr(26))
   fClose(nConfiguration)
   QUIT
ENDFUNCTION

FUNCTION fTestLine(cFile, cLineStart, cCheckType, c2Find)
   LOCAL nFile, cTest, lFound := .n.
   IF (nFile := fOpen(cFile))<1
      RETURN .n.
   ENDIF
   cCheckType := Upper(Left(cCheckType, 1))
   c2Find     := Upper(c2Find)
   cLineStart := Upper(cLineStart)
   WHILE !fEOF(nFile)
      cTest := Upper(fReadLine(nFile))
      IF cTest!=cLineStart
         LOOP
      ENDIF
      IF cCheckType="W"
         IF c2Find$cTest
            lFound := .y.
            EXIT
         ENDIF
      ENDIF
   ENDWHILE
   fClose(nFile)
   RETURN lFound
ENDFUNCTION

FUNCTION fModifyLine(cFile, cLineStart, cCheckType, c2Modify)
   LOCAL nInFile, nOutFile, cTest
   IF (nInFile := fOpen(cFile, FO_READWRITE))<1
      RETURN NIL
   ENDIF
   cCheckType := Upper(Left(cCheckType, 1))
   cLineStart := Upper(cLineStart)
   nOutFile   := fCreate(fExtNew(cFile, "$BV"))
   WHILE !fEOF(nInFile)
      cTest := fReadLine(nInFile)
      IF Upper(cTest)!=cLineStart
         fWriteLine(nOutFile, cTest)
         LOOP
      ENDIF
      IF cCheckType="A"
         fWriteLine(nOutFile, cTest+c2Modify)
      ENDIF
   ENDWHILE
   fClose(nInFile)
   fClose(nOutFile)
   RENAME (cFile) TO (fExtNew(cFile, "BAK"))
   RENAME (fExtNew(cFile, "$BV")) TO (cFile)
ENDFUNCTION

FUNCTION pSetEnv(cEnvVar, cNewParm)
   LOCAL nSets, cFile, aSet := {}, cTemp
   cFile := fExtNone(fUnique())
   RUN &("SET>"+cFile)
   nSets := fOpen(cFile)
   WHILE !fEOF(nSets)
      cTemp := fReadLine(nSets)
      aAdd(aSet, {sParse(@cTemp, "="), cTemp})
   ENDWHILE
   fClose(nSets)
   fKill(cFile)
   cTemp := aSet[aScan(a1from2(aSet, 1), Upper(cEnvVar)), 2]
   IF cNewParm!=NIL
      RUN &("SET "+cEnvVar+"="+cNewParm)
   ENDIF
RETURN NIL

STATIC FUNCTION Maint()
   LOCAL nOption, nChoice, GetList := {}, aRC
   vSave()
   SET CURSOR on
   CLS
   WHILE LOOPING
      nOption := vMenu("T/Add entry/Delete entry/Edit entry/Browse/Quit")
      IF nOption=0 .or. nOption=5
         EXIT
      ENDIF
      DO CASE
      CASE nOption=1
         vSave()
         fAddRecord()
         aRC := vWindow(2, 78, .y., "Adding a menu item")
         @ aRC[1], aRC[2] SAY "Prompt .............." GET cPrompt
         @ Row()+1, aRC[2] SAY "Help line ..........." GET cHelp PICTURE "@S56"
         READ
         CLS
         @ 0, 0 SAY "Enter BATCH commands, including cd\menu at end:"
         Field->cBatch := MemoEdit("", 1, 0, MaxRow(), MaxCol())
         vRestore()
         LOOP
      CASE nOption=2
         vSave()
         @ MaxRow(), 0
         @ MaxRow(), 0 SAY "Choose option to delete, press <ESC> to abort"
         nChoice := aPickList(1, 20, MaxRow()-3, 59, aPrompts)
         IF nChoice!=0
            IF vIsSure()
               GO nChoice
               fLockRec()
               DELETE
               UNLOCK
               aPrompts[nChoice] := NIL
               aPack(aPrompts, .y.)
            ENDIF
         ENDIF
         vRestore()
         LOOP
      CASE nOption=3
         vSave()
         @ MaxRow(), 0
         @ MaxRow(), 0 SAY "Choose option to edit, press <ESC> to abort"
         nChoice := aPickList(1, 20, MaxRow()-3, 59, aPrompts)
         vRestore()
         IF nChoice=0
            LOOP
         ENDIF
         vSave()
         GO nChoice
         fLockRec()
         aRC := vWindow(2, 78, .y., "Editing a menu item")
         @ aRC[1], aRC[2] SAY "Prompt .............." GET cPrompt
         @ Row()+1, aRC[2] SAY "Help line ..........." GET cHelp PICTURE "@S78"
         READ
         CLS
         @ 0, 0 SAY "Enter BATCH commands, including cd\menu at end:"
         Field->cBatch := MemoEdit("", 1, 0, MaxRow(), MaxCol())
         vRestore()
         UNLOCK
         LOOP
      CASE nOption=4
         fLockFile()
         Browse()
         UNLOCK
      ENDCASE
   ENDWHILE
   SET CURSOR off
   vRestore()
   KEYBOARD Chr(27)
ENDFUNCTION

STATIC FUNCTION Dos()
   vSave()
   CLS
   ?? "Exiting to DOS.  Enter 'EXIT' to return."
   ?
   RUN Command
   vRestore()
ENDFUNCTION
