/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

/* COMPATIBILITY NOTE - FOR THOSE USING BECKNER.LIB 1.0, THIS FUNCTION IS
   ENTIRELY NEW IN THIS RELEASE.  HOWEVER, THE OLD CODE IS COMMENTED OUT
   AFTER THE NEW FUNCTION DEFINITION.  TO USE IT, SIMPLY COMMENT OUT THE
   NEW AND UNCOMMENT THE OLD.
*/

#define PMT_DATE  1
#define PAYMENT   2
#define PRINCIPAL 3
#define INTEREST  4
#define BALANCE   5

FUNCTION mAmortSched(nStartBal, nAPR, nNumPmts, dStart, lUse365)
   LOCAL aSchedule := Array(nNumPmts, 5), nCtr, nPayment, nDaysInYear
   DEFAULT lUse365 TO .n., dStart TO dBegMonth(dSame())
   nDaysInYear := iif(lUse365, 365, 360)
   iif(nAPR>1, nAPR := Round(nAPR/100, 7),)
   nPayment    := Round(nStartBal*nAPR/12/(1-(1+nAPR/12)^-nNumPmts), 2)
   dStart      := dSame(dStart, -1)
   FOR nCtr := 1 TO nNumPmts-1
      aSchedule[nCtr, PMT_DATE] := dSame(dStart)
      aSchedule[nCtr, PAYMENT]  := nPayment
      aSchedule[nCtr, INTEREST] := Round(1.0000000*nStartBal*iif(lUse365,;
            aSchedule[nCtr, PMT_DATE]-dStart, dDays30(dStart,;
            aSchedule[nCtr, PMT_DATE]))*nAPR/nDaysInYear, 2)
      dStart := aSchedule[nCtr, PMT_DATE]
      aSchedule[nCtr, PRINCIPAL] := nPayment-aSchedule[nCtr, INTEREST]
      aSchedule[nCtr, BALANCE]   := nStartBal-aSchedule[nCtr, PRINCIPAL]
      nStartBal := aSchedule[nCtr, BALANCE]
   NEXT
   aSchedule[nCtr, PMT_DATE] := dSame(dStart)
   aSchedule[nCtr, INTEREST] := Round(1.0000000*nStartBal*iif(lUse365,;
         aSchedule[nCtr, PMT_DATE]-dStart, dDays30(dStart,;
         aSchedule[nCtr, PMT_DATE]))*nAPR/nDaysInYear, 2)
   aSchedule[nCtr, PAYMENT]   := nStartBal+aSchedule[nCtr, INTEREST]
   aSchedule[nCtr, PRINCIPAL] := nStartBal
   aSchedule[nCtr, BALANCE]  := 0.00
   RETURN aSchedule
ENDFUNCTION


/* old s'87 version  (for compatibility purposes)
FUNCTION mAmortSched()
   para sbal,sdate,apr,pmt,princ,int,bal,pmt_date,use_365
   if pcount()<3.or.pcount()>9
      retu -1
   endi
   priv x
   if pcount()<9
      use_365=.n.
   endi
   if pcount()=4
      if type('M->PMT')='L'
         use_365=m->pmt
      else
         use_365=.n.
         priv bal[len(m->pmt)],int[len(m->pmt)],princ[len(m->pmt)]
         priv pmt_date[len(m->pmt)]
      endi
   elseif pcount()=5
      if type('M->PRINC')='L'
         use_365=m->princ
         rele princ
         priv bal[len(m->pmt)],int[len(m->pmt)],princ[len(m->pmt)]
         priv pmt_date[len(m->pmt)]
      else
         priv bal[len(m->pmt)],int[len(m->pmt)],pmt_date[len(m->pmt)]
      endi
   elseif pcount()=6
      if type('M->INT')='L'
         use_365=m->int
         rele int
         priv bal[len(m->pmt)],int[len(m->pmt)],pmt_date[len(m->pmt)]
      else
         priv bal[len(m->pmt)],pmt_date[len(m->pmt)]
      endi
   elseif pcount()=7
      if type('M->BAL')='L'
         use_365=m->bal
         rele bal
         priv bal[len(m->pmt)],pmt_date[len(m->pmt)]
      else
         priv pmt_date[len(m->pmt)]
      endi
   elseif pcount()=8
      if type('M->PMT_DATE')='L'
         use_365=m->pmt_date
         rele pmt_date
         priv pmt_date[len(m->pmt)]
      endi
   endi
   reg_pmt=round(m->sbal*m->apr/if(m->apr<1,12,1200)/(1-(1+m->apr/;
   iif(m->apr<1,12,1200))^-m->no_pmts),2)
   if pcount()=3.or.type('M->PMT')='L'
      retu m->reg_pmt
   endi
   for x=1 to len(m->pmt)-1
      pmt[m->x]=min(m->reg_pmt,m->sbal)
      int[m->x]=round(1.0000000*m->sbal*if(m->use_365,dSame(m->sdate)-;
      m->sdate,dDays30(m->sdate,dSame(m->sdate)))*;
      m->apr/if(m->apr<1,1,100)/if(m->use_365,365,360),2)
      pmt_date[m->x]=dSame(m->sdate)
      princ[m->x]=pmt[m->x]-int[m->x]
      bal[m->x]=m->sbal-princ[m->x]
      sbal=bal[m->x]
      sdate=pmt_date[m->x]
   next
   int[m->x]=round(1.0000000*m->sbal*if(m->use_365,dSame(m->sdate)-m->sdate,;
   dDays30(m->sdate,dSame(m->sdate)))*m->apr/if(m->apr<1,1,100)/;
   iif(m->use_365,365,360),2)
   pmt[m->x]=m->sbal+int[m->x]
   pmt_date[m->x]=dSame(m->sdate)
   princ[m->x]=m->sbal
   bal[m->x]=0.00
   retu 0
*/

