/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "set.ch"
#define INFINITY_SYMBOL Chr(236)

FUNCTION fShare(cFileName, cAlias, nSeconds)
   LOCAL cSaveChar
   DEFAULT nSeconds TO 3600
   vCursSave()
   cSaveChar := vSave(MaxRow(), MaxCol(), MaxRow(), MaxCol())
   @ MaxRow(), MaxCol() SAY INFINITY_SYMBOL
   tElapsedS()
   WHILE LOOPING
      DO CASE
      CASE cAlias=NIL .and. Set(_SET_EXCLUSIVE)
         IF iShare()
            USE (cFileName) EXCLUSIVE
         ELSE
            USE (cFileName) NEW EXCLUSIVE
         ENDIF
      CASE cAlias=NIL
         IF iShare()
            USE (cFileName) SHARED
         ELSE
            USE (cFileName) NEW SHARED
         ENDIF
      CASE Set(_SET_EXCLUSIVE)
         IF iShare()
            USE (cFileName) ALIAS (cAlias) EXCLUSIVE
         ELSE
            USE (cFileName) ALIAS (cAlias) NEW EXCLUSIVE
         ENDIF
      OTHERWISE
         IF iShare()
            USE (cFileName) ALIAS (cAlias) SHARED
         ELSE
            USE (cFileName) ALIAS (cAlias) NEW SHARED
         ENDIF
      ENDCASE
      IF !neterr() .or. tElapsedC()>nSeconds
         EXIT
      ENDIF
      vMessageOn({"Attempting to open as SHARED, the file", ALIAS(),;
      "File is already opened EXCLUSIVELY or LOCKED"})
      Inkey(.3)
      vMessageOff()
   ENDWHILE
   vRestore(cSaveChar)
   tElapsedO()
   vCursRest()
   RETURN !Empty(ALIAS())
ENDFUNCTION
