/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"

FUNCTION fQuery(acWorkAreas)
   LOCAL aOptions := {'Average', 'Count', 'Sum', 'User defined', 'View'}
   LOCAL nOption, cFields, nCurRec, aAnswers, aFldNames := {}, cTemp, nCtr
   LOCAL aCoordinates, cScreen, nAnswer, nCurSel
   cScreen := vSave()
   nCurSel := Select()
   nCurRec := RecNo()
   iif(acWorkAreas=NIL, acWorkAreas := Alias(),)
   iif(ValType(acWorkAreas)="C", acWorkAreas := aChar2Array(acWorkAreas),)
   SELECT (Select(acWorkAreas[aPickList(acWorkAreas)]))
   fSetFilter()
   nOption := aPickList(aOptions)
   DO CASE
   CASE nOption=1
      cTemp := cFields := fFields2Use("N")
      WHILE !Empty(cTemp)
         aAdd(aFldNames, sParse(@cTemp))
      ENDWHILE
      aAnswers     := fAverage(cFields)
      aCoordinates := vWindow(Len(aAnswers), 30, .y., 'AVERAGES')
      FOR nCtr := 1 to len(aAnswers)
         @ aCoordinates[1]+nCtr-1, aCoordinates[2] SAY aFldNames[nCtr]
         @ Row(), Col()+1 say aAnswers[nCtr]
      NEXT
      vAnyKey()
   CASE nOption=2
      COUNT to nAnswer
      aCoordinates := vWindow(1, 15, .y., 'COUNT')
      @ aCoordinates[1], aCoordinates[2] SAY nAnswer
      vAnyKey()
   CASE nOption=3
      cTemp := cFields := fFields2Use("N")
      WHILE !Empty(cTemp)
         aAdd(aFldNames, sParse(@cTemp))
      ENDWHILE
      aAnswers     := fSumRec(cFields)
      aCoordinates := vWindow(Len(aAnswers), 30, .y., 'TOTALS')
      FOR nCtr := 1 to Len(aAnswers)
         @ aCoordinates[1]+nCtr-1, aCoordinates[2] SAY aFldNames[nCtr]
         @ row(), col()+1 SAY aAnswers[nCtr]
      NEXT
      vAnyKey()
   ENDCASE
   vRestore(cScreen)
   SELECT (nCurSel)
   GO nCurRec
ENDFUNCTION
