/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Erases (deletes) files by wildcard
//
// Syntax:
//    fEraseFiles(<cWild>) -> nDeleted
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cWild       DOS wild card file specification
//
// Returns:
//    nDeleted    Number of files deleted
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       fClose(fCreate("testtest.tst"))  /* create test file */
//       ? fEraseFiles("*.tst")           /* 1 */
//    ENDFUNCTION
//
// Files:
//    (<cWild>)
//
// Description:
//    Erases the files specified in <cWild>, which is a valid DOS wild card
//    file specification.  The number of files actually deleted is returned,
//    or -1 if no parameter is passed.
//
// See Also:
//    fKill()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fEraseFiles(cWildCard)
   LOCAL nCtr, y, aFile2Erase := {}
   IF pCount()!=1
      RETURN -1
   ENDIF
   IF !('*'$cWildCard .or. '?'$cWildCard)
      IF File(cWildCard)
         ERASE (cWildCard)
      ENDIF
      RETURN 0
   ENDIF
   nCtr := aDir(cWildCard)
   IF nCtr=0
      RETURN 0
   ENDIF
   aSize(aFile2Erase[nCtr], nCtr)
   aDir(cWildCard,aFile2Erase)
   FOR y=1 TO nCtr
      ERASE (aFile2Erase[y])
   NEXT
   RETURN nCtr
ENDFUNCTION
