/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      SOURCE CODE (THIS FILE) MAY NOT BE
    Winston-Salem NC 27116            DISTRIBUTED!  ONLY REGISTERED USERS
    Fax: 919/760-1003                 OF BECKNER LIBRARY & UTILITIES II MAY
                                      BE IN POSSESSION OF THIS FILE.
*/

#include "beckner.inc"
#include "dbstruct.ch"

FUNCTION fDbt2Dbv(cFileName, aStructure)
   LOCAL nCurSel := Select(), aNewStructure
   LOCAL cNewFile := fExtNew(cFileName, "new")
   LOCAL cDbvFile := fExtNew(cFileName, "dbv")
   DEFAULT aStructure TO dbStruct()
   cFileName := fExtNew(cFileName, "dbf")
   USE (cFileName) NEW ALIAS vSource
   IF aScan(aStructure, {|aField| aField[DBS_TYPE]="M"})=0
      CLOSE
      SELECT (nCurSel)
      RETURN .n.
   ELSE
      aNewStructure := aClone(aStructure)
      aEval(aNewStructure, {|aField|;
            iif(aField[DBS_TYPE]="M", aField[DBS_LEN]  := 6,),;
            iif(aField[DBS_TYPE]="M", aField[DBS_TYPE] := "C",)})
      dbCreate(cNewFile, aNewStructure)
      USE (cNewFile) ALIAS vDest NEW
      fKill(cDbvFile)
      IF V_Use(cDbvFile)=-1
         RETURN .n.
      ENDIF
      SELECT vSource
      dbEval({|| copyrec(aStructure)})
      SELECT vSource
      CLOSE
      SELECT vDest
      CLOSE
      V_Close()
   ENDIF
   SELECT (nCurSel)
   RETURN .y.
ENDFUNCTION

STATIC FUNCTION copyrec( aStructure )
   LOCAL nCtr, nFieldCnt := fCount()
   SELECT vDest
   ADDRECORD
   FOR nCtr := 1 TO nFieldCnt
      IF aStructure[nCtr, DBS_TYPE]="M"
         IF !Empty(vSource->(FieldGet(nCtr)))
            FieldPut(nCtr, V_Replace(vSource->(FieldGet(nCtr)), "      "))
         ENDIF
      ELSE
         FieldPut(nCtr, vSource->(FieldGet(nCtr)))
      ENDIF
   NEXT
   IF vSource->(Deleted())
      vDest->(dbDelete())
   ENDIF
   SELECT vSource
ENDFUNCTION

/*
 1.02 01.21.93 created
*/
