/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Creates a FRM file from a passed array
//
// Syntax:
//    fCreateFrm(<cFile>, <aReport>) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cFile       File name
//    aReport     Report parameters
//
// Returns:
//    NIL
//
// Examples:
//    FUNCTION TestIt()
//       LOCAL cFile    := "Test"
//
//       LOCAL aColumn1 := {32,              /* column width               */;
//                .n.,                       /* total?                     */;
//                0,                         /* decimal positions          */;
//                "Name",                    /* column expression          */;
//                "Name",                    /* column header 1            */;
//                "",                        /* column header 2            */;
//                "",                        /* column header 3            */;
//                ""                         /* column header 4            */}
//
//       LOCAL aColumn2 := {12,              /* column width               */;
//                .y.,                       /* total?                     */;
//                2,                         /* decimal positions          */;
//                "Balance",                 /* column expression          */;
//                "Balance",                 /* column header 1            */;
//                "",                        /* column header 2            */;
//                "",                        /* column header 3            */;
//                ""                         /* column header 4            */}
//
//       LOCAL aColumn3 := {1,               /* column width               */;
//                .n.,                       /* total?                     */;
//                0,                         /* decimal positions          */;
//                "Transform(Over21, [Y])",  /* column expression          */;
//                ">",                       /* column header 1            */;
//                "2",                       /* column header 2            */;
//                "1",                       /* column header 3            */;
//                "?"                        /* column header 4            */}
//
//       LOCAL aReport  := {"Name List",     /* page heading 1             */;
//                "",                        /* page heading 2             */;
//                "",                        /* page heading 3             */;
//                "",                        /* page heading 4             */;
//                80,                        /* page width                 */;
//                10,                        /* left margin                */;
//                10,                        /* right margin               */;
//                58,                        /* printable lines per page   */;
//                .n.,                       /* double space?              */;
//                .n.,                       /* plain page?                */;
//                .y.,                       /* eject after report?        */;
//                .n.,                       /* eject before report?       */;
//                "",                        /* group expression           */;
//                "",                        /* group header               */;
//                .n.,                       /* summary only?              */;
//                .n.,                       /* eject after group          */;
//                "",                        /* subgroup expression        */;
//                "",                        /* subgroup header            */;
//                3,                         /* number of columns          */;
//                aColumn1,                  /* column 1 definition        */;
//                aColumn2,                  /* column 2 definition        */;
//                aColumn3                   /* column 3 definition        */}
//
//       CreateTest()
//       fCreateFrm(cFile, aReport)
//       REPORT FORM Test TO PRINTER NOCONSOLE
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
// Files:
//    created frm
//
// Description:
//    Creates an FRM file from the supplied array.  The elements of the array
//    are defined in the example above.
//
// See Also:
//    fCreateLbl()
//    fCreateNtx()
//    fCreateDbf()
//    pRepGen()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fCreateFRM(cFilename, aReport)
   LOCAL nFormFile, nExprLens := 4, nCtr, nExprOffs := 114, nExpr := 224
   LOCAL nExprNum := 0, nHdrNum := 0
   LOCAL nFldOffs := 1676, cTemp := "", aOffset, nField, nCtr2, nFieldNum
   nFormFile := fCreate(fExtNew(Trim(cFilename), "FRM"))
   fWrite(nFormFile, pVal2Word(2)+Replicate(Chr(0), 1988))
   FOR nCtr := 1 to 4
      cTemp += Trim(aReport[nCtr])+";"
   NEXT
   WHILE Right(cTemp, 1)=";"
      cTemp := Left(cTemp, Len(cTemp)-1)
   ENDWHILE
   aOffset := iFRMWrHdrs({cTemp, aReport[13], aReport[17], aReport[14],;
   aReport[18]}, {4, 114, 224, nExprNum}, nFormFile, 1964)
   fSeek(nFormFile, 1964)
   fWrite(nFormFile, pVal2Word(iif(Empty(cTemp), 65535, nHdrNum++)))
   fWrite(nFormFile, pVal2Word(iif(Empty(aReport[13]), 65535, nHdrNum++)))
   fWrite(nFormFile, pVal2Word(iif(Empty(aReport[17]), 65535, nHdrNum++)))
   fWrite(nFormFile, pVal2Word(iif(Empty(aReport[14]), 65535, nHdrNum++)))
   fWrite(nFormFile, pVal2Word(iif(Empty(aReport[18]), 65535, nHdrNum++)))
   fWrite(nFormFile, pVal2Word(aReport[5]))
   fWrite(nFormFile, pVal2Word(aReport[8]))
   fWrite(nFormFile, pVal2Word(aReport[6]))
   fWrite(nFormFile, pVal2Word(aReport[7]))
   fWrite(nFormFile, pVal2Word(aReport[19]))
   fWrite(nFormFile, iif(aReport[9], "Y", "N"))
   fWrite(nFormFile, iif(aReport[15], "Y", "N"))
   fWrite(nFormFile, iif(aReport[16], "Y", "N"))
   fWrite(nFormFile, Chr(iif(aReport[10], 4, 0)+iif(aReport[11], 2, 0)+;
         iif(aReport[12], 0, 1)))
   fWrite(nFormFile, pVal2Word(2))
   nFieldNum := nHdrNum
   FOR nCtr := 1 to aReport[19]
      cTemp := ""
      nField := nCtr+19
      FOR nCtr2 := 5 to 8
         cTemp += Trim(aReport[nField, nCtr2])+";"
      NEXT
      WHILE Right(cTemp, 1)=";"
         cTemp := Left(cTemp, Len(cTemp)-1)
      ENDWHILE
      fSeek(nFormFile, nFldOffs)
      fWrite(nFormFile, pVal2Word(aReport[nField, 1])+Replicate(Chr(0), 3))
      fWrite(nFormFile, iif(aReport[nField, 2], "Y", "N"))
      fWrite(nFormFile, pVal2Word(aReport[nField, 3]))
      aOffset := iFRMWrHdrs({aReport[nField, 4]}, aOffset, nFormFile,;
            nFldOffs+10)
      aOffset := iFRMWrHdrs({cTemp}, aOffset, nFormFile, nFldOffs+8)
      fSeek(nFormFile, nFldOffs+8)
      fWrite(nFormFile, pVal2Word(nFieldNum++))
      fSeek(nFormFile, nFldOffs+10)
      fWrite(nFormFile, pVal2Word(nFieldNum++))
      nFldOffs += 12
   NEXT
   fSeek(nFormFile, 2)
   fWrite(nFormFile, pVal2Word(aOffset[3]+aOffset[4]-224))
   fClose(nFormFile)
ENDFUNCTION

////////////////
////////////////
//
// Purpose:
//    Internal function
//
// Category:
//    Internal Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

STATIC FUNCTION iFRMWrHdrs(aExpr, aOffset, nFormFile, nHdrNum)
   LOCAL nCtr, nExprLength
   FOR nCtr := 1 to Len(aExpr)
      fSeek(nFormFile, nHdrNum)
      nHdrNum += 2
      IF Empty(aExpr[nCtr] := Trim(aExpr[nCtr]))
         fWrite(nFormFile, Chr(255)+Chr(255))
      ELSE
         fWrite(nFormFile, pVal2Word(aOffset[4]++))
         fSeek(nFormFile, aOffset[1])
         aOffset[1] += 2
         fWrite(nFormFile, pVal2Word(nExprLength := (Len(aExpr[nCtr])+1)))
         fSeek(nFormFile, aOffset[2])
         aOffset[2] += 2
         fWrite(nFormFile, pVal2Word(aOffset[3]-224))
         fSeek(nFormFile, aOffset[3])
         aOffset[3] += nExprLength
         fWrite(nFormFile, aExpr[nCtr])
         aOffset[4] += nExprLength
      ENDIF
   NEXT
   RETURN aOffset
ENDFUNCTION
