/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Creates a dbf file
//
// Syntax:
//    fCreateDbf(<cStructure>, [<lFlexIt>]) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cStructure  Structure definition
//    lFlexIt     .y.=create FlexFile compatible dbv instead of dbt
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL cFileName := "Test"
//       LOCAL cField1   := "Name/C/32"
//       LOCAL cField2   := "Balance/N/12/2"
//       LOCAL cField3   := "Date/D"
//       LOCAL cField4   := "Logical/L"
//       LOCAL cField5   := "Notes/M"
//       fCreateDbf(cFileName+"/"+cField1+"/"+cField2+"/"+cField3+"/"+;
//                   cField4+"/"+cField5)
//       ? File("Test.dbf")      /* true */
//    ENDFUNCTION
//
// Files:
//    created dbf, with a dbt if a memo field is defined
//
// Description:
//    Creates a database (dbf) file from a structure string.  The structure
//    string is in the format: <file>/<field1>/<fieldN>.  Each field in the
//    structure has additional parameters based on its type.  Character types
//    have a length parameter, numeric types have a length and decimal
//    parameter, while date, logical and memo types have no additional
//    parameters.  See the example.  Note that even if a numeric field has no
//    decimal places, then 0 must be specified.
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fCreateDBF(cStructure, lFlexFile)
   LOCAL cFileName, aStructure := {}, nElNum := 0
   DEFAULT lFlexFile TO .n.
   cStructure := Upper(cStructure)
   cFileName := sParse(@cStructure)
   WHILE !Empty(cStructure)
      aAdd(aStructure, {sParse(@cStructure), sParse(@cStructure), 0, 0})
      nElNum++
      DO CASE
      CASE aStructure[nElNum, 2]='C'
         aStructure[nElNum, 3] := Val(sParse(@cStructure))
      CASE aStructure[nElNum, 2]='D'
         aStructure[nElNum, 3] := 8
      CASE aStructure[nElNum, 2]='M'
         aStructure[nElNum, 3] := 10
      CASE aStructure[nElNum, 2]='N'
         aStructure[nElNum, 3] := Val(sParse(@cStructure))
         aStructure[nElNum, 4] := Val(sParse(@cStructure))
      CASE aStructure[nElNum, 2]='L'
         aStructure[nElNum, 3] := 1
      ENDCASE
   ENDWHILE
   dbCreate(cFileName, aStructure)
   IF lFlexFile
      fDbt2Dbv(cFileName)
      fKill(fExtNew(cFileName, "dbt"))
   ENDIF
ENDFUNCTION

/* Modifications
 1.02 01.21.93 Added lFlexFile and processing for it
*/
