/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "fileio.ch"

////////////////
////////////////
//
// Purpose:
//    Adds a line to a text file
//
// Syntax:
//    fAddLine(<cnFile>, <cLine>) -> NIL
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cnFile      File name or file handle
//    cLine       Text to add to end of file
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       /* first way */
//       LOCAL nFile := fCreate("Text.txt")
//       fAddLine(nFile, "This is line #1.")
//       fClose(nFile)
//       /* second way */
//       fAddLine("Text.txt", "Line #2.")
//    ENDFUNCTION
//
// Files:
//    (cnFile)
//
// Description:
//    Adds a line to a text file.  If the file is already opened, then 
//    <cnFile> is the file handle, and the file remains opened upon
//    completion.  If <cnFile> is a file name, the file is opened, the line
//    is added, and the file is closed - the file in this case must pre-exist.
//
// See Also:
//    fWriteLine()
//
// Category:
//    File Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION fAddLine(cnFile, cLine)
   LOCAL nHandle
   nHandle := iif(ValType(cnFile)="C", fOpen(cnFile, FO_WRITE), cnFile)
   fSeek(nHandle, 0, FS_END)
   fWrite(nHandle, sType2Char(cLine)+CRLF)
   iif(ValType(cnFile)="C", fClose(nHandle), NIL)
ENDFUNCTION
