/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Sets the system (DOS) date
//
// Syntax:
//    dSetSysDate(<dAny>) -> NIL
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Non-empty date expression
//
// Returns:
//    NIL
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest := CtoD("6/22/93")
//       dSetSysDate(dTest)      /* Sets system date */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Functionally the same as dSetDate(), but uses a DOS BIOS call instead of
//    the RUN command.
//
// See Also:
//    dSetDate()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dSetSysDate(dDate)
   apSetDate(Month(dDate), Day(dDate), Year(dDate))
ENDFUNCTION
