/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Returns the quarter in which the date exists
//
// Syntax:
//    dQuarter([<dAny>]) -> nQuarter
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    dAny        Any date [Date()]
//
// Returns:
//    nQuarter    Quarter number
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL dTest1 := dEmpty(), dTest2 := CtoD("9/26/98")
//       ? dQuarter(dTest1)      /* 0 */
//       ? dQuarter(dTest2)      /* 3 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the quarter number in which the passed date exists.  The default
//    date is the current system date.  If the passed date is empty, then 0
//    is returned.
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dQuarter(dAny)
   LOCAL nMonth
   DEFAULT dAny TO Date()
   IF Empty(dAny)
      RETURN 0
   ENDIF
   nMonth := Month(dAny)
   RETURN iif(nMonth<4, 1, iif(nMonth<7, 2, iif(nMonth<10, 3, 4)))
ENDFUNCTION
