/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Decrement a date get field
//
// Syntax:
//    dDec(<cProcName>, <nLineNum>, <cVariable>) -> NIL
//
// Formal Arguments: (3)
//    Name        Description
//    ___________ ____________
//    cProcName   not used
//    nLineNum    not used
//    cVariable   GET variable name (must be MEMVAR)
//
// Returns:
//    NIL
//
// Examples:
//    #include "inkey.ch"
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL GetList := {}
//       MEMVAR dTest
//       PRIVATE dTest := Date()
//       SET KEY K_PLUS  TO dInc
//       SET KEY K_MINUS TO dDec
//       CLS
//       @ 5, 1 SAY "<+> OR <-> ..." GET dTest
//       READ
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    The date variable must be either public or private.  Locals and Statics
//    will not work.  This function lets you assign a key to cause the date
//    field to decrement by one day.
//
// See Also:
//    dInc()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDec(cProcName, nLineNum, cVariable)
   LOCAL uHold
   IF Type(cVariable)="U"
      RETURN NIL
   ENDIF
   uHold := &cVariable.
   IF ValType(uHold)="D"
      &cVariable. := uHold-1
   ENDIF
ENDFUNCTION
