/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "set.ch"

////////////////
////////////////
//
// Purpose:
//    Returns the number of days between dates using a 360-day year
//
// Syntax:
//    dDays30(<dOld>, <dNew>) -> nDays
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    dOld        First date
//    dNew        Second date
//
// Returns:
//    nDays       Number of days between the dates using 360-day year
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL d1 := CtoD("1/1/95"), d2 := CtoD("3/1/95")
//       ? dDays30(d1, d2)    /* 60 */
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Returns the number of days between two dates assuming a 360-day year.
//    Used in certain accounting operations.  Each month is assumed to have
//    only 30 days, so that there are 30 days between the same day in two
//    consecutive months.
//
// See Also:
//    mAmortize()
//    mAPR()
//
// Category:
//    Date Function
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION dDays30(dOld, dNew)
   LOCAL nDays := 0, dLast, dNext, nMM, nYYYY, nOrigDay
   IF empty(dOld) .or. dOld>dNew
      RETURN 0
   ENDIF
   nOrigDay := day(dOld)
   dLast    := dOld
   WHILE LOOPING
      nMM   := Month(dLast)+1
      nYYYY := Year(dLast)
      IF nMM=13
         nMM := 1
         nYYYY++
      ENDIF
      dNext := CtoD(Str(nMM,2)+'/'+Str(nOrigDay,2)+'/'+;
            Str(nYYYY-set(_SET_EPOCH), 2))
      iif(Empty(dNext),;
            dNext := CtoD(Str(nMM,2)+'/'+Str(iif(nMM=2, 28, 30), 2)+;
      '/'+str(nYYYY-Set(_SET_EPOCH), 2)),)
      IF dNext<=dNew
         nDays += 30
         IF dNext=dNew
            EXIT
         ENDIF
      ELSE
         nDays += (dNew-dLast)
         EXIT
      ENDIF
      dLast := dNext
   ENDWHILE
   RETURN nDays
ENDFUNCTION
